/* eslint-disable */
 
/*!
 * @pixi/graphics-smooth - v0.0.30
 * Compiled Mon, 11 Jul 2022 13:30:59 UTC
 *
 * @pixi/graphics-smooth is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 * 
 * Copyright 2019-2020, Ivan Popelyshev, All Rights Reserved
 */
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var math = require('@pixi/math');
var core = require('@pixi/core');
var constants = require('@pixi/constants');
var graphics = require('@pixi/graphics');
var utils = require('@pixi/utils');
var display = require('@pixi/display');

function matrixEquals(th, matrix, eps = 1e-3)
{
    return this === matrix || Math.abs(th.a - matrix.a) < eps
        && Math.abs(th.b - matrix.b) < eps
        && Math.abs(th.c - matrix.c) < eps
        && Math.abs(th.d - matrix.d) < eps
        && Math.abs(th.tx - matrix.tx) < eps
        && Math.abs(th.ty - matrix.ty) < eps;
}

class BatchStyleArray
{
    
    
    
    

    constructor()
    {
        this.textureIds = [];
        this.matrices = [];
        this.lines = [];
        this.count = 0;
        // TODO: mapCoord for atlas cases
        // TODO: gradients?
    }

    clear()
    {
        for (let i = 0; i < this.count; i++)
        {
            this.textureIds[i] = null;
            this.matrices[i] = null;
        }
        this.count = 0;
    }

    add(textureId, matrix,
        lineWidth, lineAlignment, lineScaleMode,
        settings)
    {
        const { textureIds, matrices, lines, count } = this;

        textureId = (textureId * 4) + lineScaleMode;
        for (let i = 0; i < count; i++)
        {
            if (lines[i * 2] === lineWidth && lines[(i * 2) + 1] === lineAlignment
                && textureIds[i] === textureId && (matrixEquals(matrices[i], matrix)))
            {
                return i;
            }
        }
        if (count >= settings.maxStyles)
        {
            return -1;
        }
        textureIds[count] = textureId;
        matrices[count] = matrix;
        lines[count * 2] = lineWidth;
        lines[(count * 2) + 1] = lineAlignment;
        this.count++;

        return count;
    }
}

class BatchDrawCall
{
    
    
    
    
    
    
    
    
    

    constructor()
    {
        this.texArray = new core.BatchTextureArray();
        this.styleArray = new BatchStyleArray();
        this.shader = null;
        this.blend = constants.BLEND_MODES.NORMAL;

        this.start = 0;
        this.size = 0;
        this.TICK = 0; // for filling textures
        this.settings = null;
        /**
         * data for uniforms or custom webgl state
         * @member {object}
         */
        this.data = null;
    }

    clear()
    {
        this.texArray.clear();
        this.styleArray.clear();
        this.settings = null;
        this.data = null;
        this.shader = null;
    }

    begin(settings, shader)
    {
        this.TICK = ++core.BaseTexture._globalBatch;
        this.settings = settings;
        this.shader = shader;
        // start and size calculated outside
        this.start = 0;
        this.size = 0;
        this.data = null;
        if (shader && (shader ).settings)
        {
            this.settings = (shader ).settings;
        }
    }

    check(shader)
    {
        if (this.size === 0)
        {
            this.shader = shader;

            return true;
        }

        return (this.shader === shader);
    }

    add(texture, matrix, lineWidth,
        lineAlignment, lineScaleMode)
    {
        const { texArray, TICK, styleArray, settings } = this;
        const { baseTexture } = texture;
        // check tex

        if (baseTexture._batchEnabled !== TICK && texArray.count === settings.maxTextures)
        {
            return -1;
        }
        const loc = baseTexture._batchEnabled !== TICK ? texArray.count : baseTexture._batchLocation;
        // check and add style
        // add1 -> add2 only works in chain, not when there are several adds inside
        const res = styleArray.add(loc, matrix || math.Matrix.IDENTITY,
            lineWidth, lineAlignment, lineScaleMode, settings);

        if (res >= 0)
        {
            // SUCCESS here
            // add tex
            if (baseTexture._batchEnabled !== TICK)
            {
                baseTexture._batchEnabled = TICK;
                baseTexture._batchLocation = texArray.count;
                texArray.elements[texArray.count++] = baseTexture;
            }
        }

        return res;
    }
}

class BatchPart
{
    
    
    
    
    
    
    
    

    constructor()
    {
        this.reset();
    }

     begin(style, startIndex, attribStart)
    {
        this.reset();
        this.style = style;
        this.start = startIndex;
        this.attribStart = attribStart;
        this.jointEnd = 0;
    }

     end(endIndex, endAttrib)
    {
        this.attribSize = endAttrib - this.attribStart;
        this.size = endIndex - this.start;
    }

     reset()
    {
        this.style = null;
        this.size = 0;
        this.start = 0;
        this.attribStart = 0;
        this.attribSize = 0;
        this.styleId = -1;
        this.rgba = 0;
        this.jointEnd = 0;
    }
}

class FillStyle
{
    constructor()
    {
        this.reset();
    }

    
    
    
    
    
    
    
    

    toJSON()
    {
        return this.copyTo({});
    }

    clone()
    {
        return this.copyTo(new FillStyle());
    }

    copyTo(obj)
    {
        obj.color = this.color;
        obj.alpha = this.alpha;
        obj.texture = this.texture;
        obj.matrix = this.matrix;
        obj.shader = this.shader;
        obj.visible = this.visible;
        obj.smooth = this.smooth;
        obj.matrixTex = null;

        return obj;
    }

    packLineScale()
    {
        return 0;
    }

    reset()
    {
        this.color = 0xFFFFFF;

        this.alpha = 1;

        this.texture = core.Texture.WHITE;

        this.matrix = null;

        this.shader = null;

        this.visible = false;

        this.smooth = false;

        this.matrixTex = null;
    }

    destroy()
    {
        this.texture = null;
        this.matrix = null;
        this.matrixTex = null;
    }

    getTextureMatrix()
    {
        const tex = this.texture;

        if (!this.matrix)
        {
            return null;
        }

        if (tex.frame.width === tex.baseTexture.width
            && tex.frame.height === tex.baseTexture.height)
        {
            return this.matrix;
        }

        if (!this.matrixTex)
        {
            this.matrixTex = this.matrix.clone();
        }
        else
        {
            this.matrixTex.copyFrom(this.matrix);
        }
        this.matrixTex.translate(Number(tex.frame.x), Number(tex.frame.y));

        return this.matrixTex;
    }
}

exports.LINE_SCALE_MODE = void 0; (function (LINE_SCALE_MODE) {
    const NONE = 'none'; LINE_SCALE_MODE["NONE"] = NONE;
    const NORMAL = 'normal'; LINE_SCALE_MODE["NORMAL"] = NORMAL;
    const HORIZONTAL = 'horizontal'; LINE_SCALE_MODE["HORIZONTAL"] = HORIZONTAL;
    const VERTICAL = 'vertical'; LINE_SCALE_MODE["VERTICAL"] = VERTICAL;
})(exports.LINE_SCALE_MODE || (exports.LINE_SCALE_MODE = {}));

class LineStyle extends FillStyle
{
    
    

    
    
    
    

    clone()
    {
        return this.copyTo(new LineStyle());
    }

    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    copyTo(obj)
    {
        obj.color = this.color;
        obj.alpha = this.alpha;
        obj.texture = this.texture;
        obj.matrix = this.matrix;
        obj.shader = this.shader;
        obj.visible = this.visible;
        obj.width = this.width;
        obj.alignment = this.alignment;
        obj.cap = this.cap;
        obj.join = this.join;
        obj.miterLimit = this.miterLimit;
        obj.scaleMode = this.scaleMode;

        return obj;
    }

    /**
     * returns width multiplied by scaleMode
     */
    packLineScale()
    {
        switch (this.scaleMode)
        {
            case exports.LINE_SCALE_MODE.NORMAL: return 1;
            case exports.LINE_SCALE_MODE.HORIZONTAL: return 2;
            case exports.LINE_SCALE_MODE.VERTICAL: return 3;
            default: return 0;
        }
    }

    reset()
    {
        super.reset();

        this.smooth = true;

        this.color = 0x0;

        this.width = 0;

        this.alignment = 0.5;

        this.cap = graphics.LINE_CAP.BUTT;
        this.join = graphics.LINE_JOIN.MITER;
        this.miterLimit = 10;
        this.scaleMode = exports.LINE_SCALE_MODE.NORMAL;
    }
}

class BuildData
{constructor() { BuildData.prototype.__init.call(this);BuildData.prototype.__init2.call(this);BuildData.prototype.__init3.call(this);BuildData.prototype.__init4.call(this);BuildData.prototype.__init5.call(this); }
    __init() {this.verts = [];}
    __init2() {this.joints = [];}
    __init3() {this.vertexSize = 0;}
    __init4() {this.indexSize = 0;}
    __init5() {this.closePointEps = 1e-4;}

    clear()
    {
        this.verts.length = 0;
        this.joints.length = 0;
        this.vertexSize = 0;
        this.indexSize = 0;
    }

    destroy()
    {
        this.verts.length = 0;
        this.joints.length = 0;
    }
}

exports.JOINT_TYPE = void 0; (function (JOINT_TYPE) {
    const NONE = 0; JOINT_TYPE[JOINT_TYPE["NONE"] = NONE] = "NONE";
    const FILL = 1; JOINT_TYPE[JOINT_TYPE["FILL"] = FILL] = "FILL";
    const JOINT_BEVEL = 4; JOINT_TYPE[JOINT_TYPE["JOINT_BEVEL"] = JOINT_BEVEL] = "JOINT_BEVEL";
    const JOINT_MITER = 8; JOINT_TYPE[JOINT_TYPE["JOINT_MITER"] = JOINT_MITER] = "JOINT_MITER";
    const JOINT_ROUND = 12; JOINT_TYPE[JOINT_TYPE["JOINT_ROUND"] = JOINT_ROUND] = "JOINT_ROUND";
    const JOINT_CAP_BUTT = 16; JOINT_TYPE[JOINT_TYPE["JOINT_CAP_BUTT"] = JOINT_CAP_BUTT] = "JOINT_CAP_BUTT";
    const JOINT_CAP_SQUARE = 18; JOINT_TYPE[JOINT_TYPE["JOINT_CAP_SQUARE"] = JOINT_CAP_SQUARE] = "JOINT_CAP_SQUARE";
    const JOINT_CAP_ROUND = 20; JOINT_TYPE[JOINT_TYPE["JOINT_CAP_ROUND"] = JOINT_CAP_ROUND] = "JOINT_CAP_ROUND";
    const FILL_EXPAND = 24; JOINT_TYPE[JOINT_TYPE["FILL_EXPAND"] = FILL_EXPAND] = "FILL_EXPAND";
    const CAP_BUTT = 1 << 5; JOINT_TYPE[JOINT_TYPE["CAP_BUTT"] = CAP_BUTT] = "CAP_BUTT";
    const CAP_SQUARE = 2 << 5; JOINT_TYPE[JOINT_TYPE["CAP_SQUARE"] = CAP_SQUARE] = "CAP_SQUARE";
    const CAP_ROUND = 3 << 5; JOINT_TYPE[JOINT_TYPE["CAP_ROUND"] = CAP_ROUND] = "CAP_ROUND";
    const CAP_BUTT2 = 4 << 5; JOINT_TYPE[JOINT_TYPE["CAP_BUTT2"] = CAP_BUTT2] = "CAP_BUTT2";
})(exports.JOINT_TYPE || (exports.JOINT_TYPE = {}));

class SegmentPacker
{constructor() { SegmentPacker.prototype.__init.call(this);SegmentPacker.prototype.__init2.call(this);SegmentPacker.prototype.__init3.call(this); }
    static __initStatic() {this.vertsByJoint = [];}

    __init() {this.strideFloats = 12;}

    updateBufferSize(jointStart, jointLen, triangles, target)
    {
        const { joints } = target;
        let foundTriangle = false;

        let vertexSize = 0;
        let indexSize = 0;

        for (let i = jointStart; i < jointStart + jointLen; i++)
        {
            const prevCap = joints[i] & ~31;
            const joint = joints[i] & 31;

            if (joint === exports.JOINT_TYPE.FILL)
            {
                foundTriangle = true;
                vertexSize++;
                continue;
            }

            if (joint >= exports.JOINT_TYPE.FILL_EXPAND)
            {
                vertexSize += 3;
                indexSize += 3;
                continue;
            }

            const vs = SegmentPacker.vertsByJoint[joint] + SegmentPacker.vertsByJoint[prevCap];

            if (vs >= 4)
            {
                vertexSize += vs;
                indexSize += 6 + (3 * Math.max(vs - 6, 0));
            }
        }
        if (foundTriangle)
        {
            indexSize += triangles;
        }

        target.vertexSize += vertexSize;
        target.indexSize += indexSize;
    }

    __init2() {this.bufferPos = 0;}
    __init3() {this.indexPos = 0;}
    
    
    
    

    beginPack(buildData, bufFloat, bufUint,
        indices, bufferPos = 0, indexPos = 0)
    {
        this.buildData = buildData;
        this.bufFloat = bufFloat;
        this.bufUint = bufUint;
        this.indices = indices;
        this.bufferPos = bufferPos;
        this.indexPos = indexPos;
    }

    endPack()
    {
        this.buildData = null;
        this.bufFloat = null;
        this.bufUint = null;
        this.indices = null;
    }

    packInterleavedGeometry(jointStart, jointLen, triangles,
        lineStyle, color)
    {
        const { bufFloat, bufUint, indices, buildData, strideFloats } = this;
        const { joints, verts } = buildData;

        let bufPos = this.bufferPos;
        let indPos = this.indexPos;
        let index = this.bufferPos / this.strideFloats;

        // eslint-disable-next-line max-len
        let x1; let y1;
        let x2; let y2;
        let prevX; let prevY;
        let nextX; let nextY;
        // let type: number;
        let hasTriangle = false;

        let travel = 0;

        for (let j = jointStart; j < jointStart + jointLen; j++)
        {
            const fullJoint = joints[j];
            const prevCap = joints[j] & ~31;
            const joint = joints[j] & 31;

            if (joint === exports.JOINT_TYPE.FILL)
            {
                // just one vertex
                hasTriangle = true;
                x1 = verts[(j * 2)];
                y1 = verts[(j * 2) + 1];
                bufFloat[bufPos] = x1;
                bufFloat[bufPos + 1] = y1;
                bufFloat[bufPos + 2] = x1;
                bufFloat[bufPos + 3] = y1;
                bufFloat[bufPos + 4] = x1;
                bufFloat[bufPos + 5] = y1;
                bufFloat[bufPos + 6] = x1;
                bufFloat[bufPos + 7] = y1;
                bufFloat[bufPos + 8] = travel;
                bufFloat[bufPos + 9] = 16 * joint;
                bufFloat[bufPos + 10] = lineStyle;
                bufUint[bufPos + 11] = color;
                bufPos += strideFloats;
                continue;
            }

            if (joint >= exports.JOINT_TYPE.FILL_EXPAND)
            {
                prevX = verts[j * 2];
                prevY = verts[(j * 2) + 1];
                x1 = verts[(j * 2) + 2];
                y1 = verts[(j * 2) + 3];
                x2 = verts[(j * 2) + 4];
                y2 = verts[(j * 2) + 5];

                const bis = j + 3;

                for (let i = 0; i < 3; i++)
                {
                    bufFloat[bufPos] = prevX;
                    bufFloat[bufPos + 1] = prevY;
                    bufFloat[bufPos + 2] = x1;
                    bufFloat[bufPos + 3] = y1;
                    bufFloat[bufPos + 4] = x2;
                    bufFloat[bufPos + 5] = y2;
                    bufFloat[bufPos + 6] = verts[(bis + i) * 2];
                    bufFloat[bufPos + 7] = verts[((bis + i) * 2) + 1];

                    bufFloat[bufPos + 8] = travel;
                    bufFloat[bufPos + 9] = (16 * fullJoint) + i;
                    bufFloat[bufPos + 10] = lineStyle;
                    bufUint[bufPos + 11] = color;
                    bufPos += strideFloats;
                }

                indices[indPos] = index;
                indices[indPos + 1] = index + 1;
                indices[indPos + 2] = index + 2;
                indPos += 3;
                index += 3;
                continue;
            }

            const vs = SegmentPacker.vertsByJoint[joint] + SegmentPacker.vertsByJoint[prevCap];

            if (vs === 0)
            {
                continue;
            }
            x1 = verts[j * 2];
            y1 = verts[(j * 2) + 1];
            x2 = verts[(j * 2) + 2];
            y2 = verts[(j * 2) + 3];
            // TODO: caps here
            prevX = verts[(j * 2) - 2];
            prevY = verts[(j * 2) - 1];

            const dist = Math.sqrt(((x2 - x1) * (x2 - x1)) + ((y2 - y1) * (y2 - y1)));

            if (SegmentPacker.vertsByJoint[joint] === 0)
            {
                travel -= dist;
            }

            if ((joint & ~2) !== exports.JOINT_TYPE.JOINT_CAP_BUTT)
            {
                nextX = verts[(j * 2) + 4];
                nextY = verts[(j * 2) + 5];
            }
            else
            {
                nextX = x1;
                nextY = y1;
            }
            // type = joint;

            for (let i = 0; i < vs; i++)
            {
                bufFloat[bufPos] = prevX;
                bufFloat[bufPos + 1] = prevY;
                bufFloat[bufPos + 2] = x1;
                bufFloat[bufPos + 3] = y1;
                bufFloat[bufPos + 4] = x2;
                bufFloat[bufPos + 5] = y2;
                bufFloat[bufPos + 6] = nextX;
                bufFloat[bufPos + 7] = nextY;
                bufFloat[bufPos + 8] = travel;
                bufFloat[bufPos + 9] = (16 * fullJoint) + i;
                bufFloat[bufPos + 10] = lineStyle;
                bufUint[bufPos + 11] = color;
                bufPos += strideFloats;
            }

            travel += dist;

            indices[indPos] = index;
            indices[indPos + 1] = index + 1;
            indices[indPos + 2] = index + 2;
            indices[indPos + 3] = index;
            indices[indPos + 4] = index + 2;
            indices[indPos + 5] = index + 3;
            indPos += 6;
            for (let j = 5; j + 1 < vs; j++)
            {
                indices[indPos] = index + 4;
                indices[indPos + 1] = index + j;
                indices[indPos + 2] = index + j + 1;
                indPos += 3;
            }
            index += vs;
        }

        if (hasTriangle)
        {
            for (let i = 0; i < triangles.length; i++)
            {
                indices[indPos + i] = triangles[i] + index;
            }
            indPos += triangles.length;
        }

        this.bufferPos = bufPos;
        this.indexPos = indPos;
    }
} SegmentPacker.__initStatic();

const verts = SegmentPacker.vertsByJoint;

for (let i = 0; i < 256; i++)
{ verts.push(0); }
// simple fill
verts[exports.JOINT_TYPE.FILL] = 1;

for (let i = 0; i < 8; i++)
{
    verts[exports.JOINT_TYPE.FILL_EXPAND + i] = 3;
}

// no caps for now
verts[exports.JOINT_TYPE.JOINT_BEVEL] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_BEVEL + 1] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_BEVEL + 2] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_BEVEL + 3] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_ROUND] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_ROUND + 1] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_ROUND + 2] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_ROUND + 3] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_MITER] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_MITER + 1] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_MITER + 2] = 4;
verts[exports.JOINT_TYPE.JOINT_MITER + 3] = 4;
verts[exports.JOINT_TYPE.JOINT_CAP_BUTT] = 4;
verts[exports.JOINT_TYPE.JOINT_CAP_BUTT + 1] = 4;
verts[exports.JOINT_TYPE.JOINT_CAP_SQUARE] = 4;
verts[exports.JOINT_TYPE.JOINT_CAP_SQUARE + 1] = 4;
verts[exports.JOINT_TYPE.JOINT_CAP_ROUND] = 4 + 5;
verts[exports.JOINT_TYPE.JOINT_CAP_ROUND + 1] = 4 + 5;

verts[exports.JOINT_TYPE.CAP_ROUND] = 4;

/**
 * A class to contain data useful for Graphics objects
 *
 * @class
 * @memberof PIXI
 */
class SmoothGraphicsData
{
    
    
    
    
    
    

    // result of simplification
    
    
    
    // indices in build
    
    
    
    
    
    

    constructor(shape, fillStyle = null, lineStyle = null, matrix = null)
    {
        this.shape = shape;

        this.lineStyle = lineStyle;

        this.fillStyle = fillStyle;

        this.matrix = matrix;

        this.type = shape.type;

        this.points = [];

        this.holes = [];

        this.triangles = [];

        this.closeStroke = false;

        this.clearBuild();
    }

     clearPath()
    {
        this.points.length = 0;
        this.closeStroke = true;
    }

     clearBuild()
    {
        this.triangles.length = 0;
        this.fillStart = 0;
        this.fillLen = 0;
        this.strokeStart = 0;
        this.strokeLen = 0;
        this.fillAA = false;
    }

     clone()
    {
        return new SmoothGraphicsData(
            this.shape,
            this.fillStyle,
            this.lineStyle,
            this.matrix
        );
    }

     capType()
    {
        let cap;

        switch (this.lineStyle.cap)
        {
            case graphics.LINE_CAP.SQUARE:
                cap = exports.JOINT_TYPE.CAP_SQUARE;
                break;
            case graphics.LINE_CAP.ROUND:
                cap = exports.JOINT_TYPE.CAP_ROUND;
                break;
            default:
                cap = exports.JOINT_TYPE.CAP_BUTT;
                break;
        }

        return cap;
    }

     goodJointType() {
        let joint;

        switch (this.lineStyle.join)
        {
            case graphics.LINE_JOIN.BEVEL:
                joint = exports.JOINT_TYPE.JOINT_BEVEL;
                break;
            case graphics.LINE_JOIN.ROUND:
                joint = exports.JOINT_TYPE.JOINT_ROUND;
                break;
            default:
                joint = exports.JOINT_TYPE.JOINT_MITER + 3;
                break;
        }

        return joint;
    }

     jointType()
    {
        let joint;

        switch (this.lineStyle.join)
        {
            case graphics.LINE_JOIN.BEVEL:
                joint = exports.JOINT_TYPE.JOINT_BEVEL;
                break;
            case graphics.LINE_JOIN.ROUND:
                joint = exports.JOINT_TYPE.JOINT_ROUND;
                break;
            default:
                joint = exports.JOINT_TYPE.JOINT_MITER;
                break;
        }

        return joint;
    }

     destroy()
    {
        this.shape = null;
        this.holes.length = 0;
        this.holes = null;
        this.points.length = 0;
        this.points = null;
        this.lineStyle = null;
        this.fillStyle = null;
        this.triangles = null;
    }
}

// for type only

class CircleBuilder 
{
    path(graphicsData, _target)
    {
        // need to convert points to a nice regular data
        const points = graphicsData.points;

        let x;
        let y;
        let dx;
        let dy;
        let rx;
        let ry;

        if (graphicsData.type === math.SHAPES.CIRC)
        {
            const circle = graphicsData.shape ;

            x = circle.x;
            y = circle.y;
            rx = ry = circle.radius;
            dx = dy = 0;
        }
        else if (graphicsData.type === math.SHAPES.ELIP)
        {
            const ellipse = graphicsData.shape ;

            x = ellipse.x;
            y = ellipse.y;
            rx = ellipse.width;
            ry = ellipse.height;
            dx = dy = 0;
        }
        else
        {
            const roundedRect = graphicsData.shape ;
            const halfWidth = roundedRect.width / 2;
            const halfHeight = roundedRect.height / 2;

            x = roundedRect.x + halfWidth;
            y = roundedRect.y + halfHeight;
            rx = ry = Math.max(0, Math.min(roundedRect.radius, Math.min(halfWidth, halfHeight)));
            dx = halfWidth - rx;
            dy = halfHeight - ry;
        }

        if (!(rx >= 0 && ry >= 0 && dx >= 0 && dy >= 0))
        {
            points.length = 0;

            return;
        }

        // Choose a number of segments such that the maximum absolute deviation from the circle is approximately 0.029
        const n = Math.ceil(2.3 * Math.sqrt(rx + ry));
        const m = (n * 8) + (dx ? 4 : 0) + (dy ? 4 : 0);

        points.length = m;

        if (m === 0)
        {
            return;
        }

        if (n === 0)
        {
            points.length = 8;
            points[0] = points[6] = x + dx;
            points[1] = points[3] = y + dy;
            points[2] = points[4] = x - dx;
            points[5] = points[7] = y - dy;

            return;
        }

        let j1 = 0;
        let j2 = (n * 4) + (dx ? 2 : 0) + 2;
        let j3 = j2;
        let j4 = m;

        {
            const x0 = dx + rx;
            const y0 = dy;
            const x1 = x + x0;
            const x2 = x - x0;
            const y1 = y + y0;

            points[j1++] = x1;
            points[j1++] = y1;
            points[--j2] = y1;
            points[--j2] = x2;

            if (dy)
            {
                const y2 = y - y0;

                points[j3++] = x2;
                points[j3++] = y2;
                points[--j4] = y2;
                points[--j4] = x1;
            }
        }

        for (let i = 1; i < n; i++)
        {
            const a = Math.PI / 2 * (i / n);
            const x0 = dx + (Math.cos(a) * rx);
            const y0 = dy + (Math.sin(a) * ry);
            const x1 = x + x0;
            const x2 = x - x0;
            const y1 = y + y0;
            const y2 = y - y0;

            points[j1++] = x1;
            points[j1++] = y1;
            points[--j2] = y1;
            points[--j2] = x2;
            points[j3++] = x2;
            points[j3++] = y2;
            points[--j4] = y2;
            points[--j4] = x1;
        }

        {
            const x0 = dx;
            const y0 = dy + ry;
            const x1 = x + x0;
            const x2 = x - x0;
            const y1 = y + y0;
            const y2 = y - y0;

            points[j1++] = x1;
            points[j1++] = y1;
            points[--j4] = y2;
            points[--j4] = x1;

            if (dx)
            {
                points[j1++] = x2;
                points[j1++] = y1;
                points[--j4] = y2;
                points[--j4] = x2;
            }
        }
    }

    fill(graphicsData, target)
    {
        const { verts, joints } = target;
        const { points, triangles } = graphicsData;

        if (points.length === 0)
        {
            return;
        }

        let x;
        let y;

        if (graphicsData.type !== math.SHAPES.RREC)
        {
            const circle = graphicsData.shape ;

            x = circle.x;
            y = circle.y;
        }
        else
        {
            const roundedRect = graphicsData.shape ;

            x = roundedRect.x + (roundedRect.width / 2);
            y = roundedRect.y + (roundedRect.height / 2);
        }

        const matrix = graphicsData.matrix;
        const cx = matrix ? (matrix.a * x) + (matrix.c * y) + matrix.tx : x;
        const cy = matrix ? (matrix.b * x) + (matrix.d * y) + matrix.ty : y;

        let vertPos = 1;
        const center = 0;

        if (!graphicsData.fillAA)
        {
            verts.push(cx, cy);
            joints.push(exports.JOINT_TYPE.FILL);
            verts.push(points[0], points[1]);
            joints.push(exports.JOINT_TYPE.FILL);

            for (let i = 2; i < points.length; i += 2)
            {
                verts.push(points[i], points[i + 1]);
                joints.push(exports.JOINT_TYPE.FILL);

                triangles.push(vertPos++, center, vertPos);
            }

            triangles.push(center + 1, center, vertPos);

            return;
        }

        const len = points.length;

        let x1 = points[len - 2];
        let y1 = points[len - 1];

        let nx1 = y1 - points[len - 3];
        let ny1 = points[len - 4] - x1;
        const n1 = Math.sqrt(nx1 * nx1 + ny1 * ny1);

        nx1 /= n1;
        ny1 /= n1;

        let bx1;
        let by1;

        for (let i = 0; i < len; i += 2)
        {
            const x2 = points[i];
            const y2 = points[i + 1];

            let nx2 = y2 - y1;
            let ny2 = x1 - x2;
            const n2 = Math.sqrt(nx2 * nx2 + ny2 * ny2);

            nx2 /= n2;
            ny2 /= n2;

            let bx2 = nx1 + nx2;
            let by2 = ny1 + ny2;
            const b2 = nx2 * bx2 + ny2 * by2;

            bx2 /= b2;
            by2 /= b2;

            if (i > 0)
            {
                verts.push(bx2);
                verts.push(by2);
            }
            else
            {
                bx1 = bx2;
                by1 = by2;
            }

            verts.push(cx);
            verts.push(cy);
            verts.push(x1);
            verts.push(y1);
            verts.push(x2);
            verts.push(y2);

            verts.push(0);
            verts.push(0);
            verts.push(bx2);
            verts.push(by2);

            joints.push(exports.JOINT_TYPE.FILL_EXPAND + 2);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);

            x1 = x2;
            y1 = y2;
            nx1 = nx2;
            ny1 = ny2;
        }

        verts.push(bx1);
        verts.push(by1);
    }

    line(graphicsData, target)
    {
        const { verts, joints } = target;
        const { points } = graphicsData;
        const joint = points.length === 8 // we dont need joints for arcs
            ? graphicsData.goodJointType() : exports.JOINT_TYPE.JOINT_MITER + 3;
        const len = points.length;

        if (len === 0)
        {
            return;
        }

        verts.push(points[len - 2], points[len - 1]);
        joints.push(exports.JOINT_TYPE.NONE);
        for (let i = 0; i < len; i += 2)
        {
            verts.push(points[i], points[i + 1]);
            joints.push(joint);
        }
        verts.push(points[0], points[1]);
        joints.push(exports.JOINT_TYPE.NONE);
        verts.push(points[2], points[3]);
        joints.push(exports.JOINT_TYPE.NONE);
    }
}

const tempArr = [];

function fixOrientation(points, hole = false)
{
    const m = points.length;

    if (m < 6)
    {
        return;
    }

    let area = 0;

    for (let i = 0, x1 = points[m - 2], y1 = points[m - 1]; i < m; i += 2)
    {
        const x2 = points[i];
        const y2 = points[i + 1];

        area += (x2 - x1) * (y2 + y1);

        x1 = x2;
        y1 = y2;
    }

    if ((!hole && area > 0) || (hole && area <= 0))
    {
        const n = m / 2;

        for (let i = n + (n % 2); i < m; i += 2)
        {
            const i1 = m - i - 2;
            const i2 = m - i - 1;
            const i3 = i;
            const i4 = i + 1;

            [points[i1], points[i3]] = [points[i3], points[i1]];
            [points[i2], points[i4]] = [points[i4], points[i2]];
        }
    }
}

class PolyBuilder 
{
    path(graphicsData, buildData)
    {
        const shape = graphicsData.shape ;
        const points = graphicsData.points = shape.points.slice();
        const eps = buildData.closePointEps;
        const eps2 = eps * eps;

        if (points.length === 0)
        {
            return;
        }

        const firstPoint = new math.Point(points[0], points[1]);
        const lastPoint = new math.Point(points[points.length - 2], points[points.length - 1]);
        const closedShape = graphicsData.closeStroke = shape.closeStroke;

        let len = points.length;
        let newLen = 2;

        // 1. remove equal points
        for (let i = 2; i < len; i += 2)
        {
            const x1 = points[i - 2]; const y1 = points[i - 1]; const x2 = points[i]; const
                y2 = points[i + 1];
            let flag = true;

            if (Math.abs(x1 - x2) < eps
                && Math.abs(y1 - y2) < eps)
            {
                flag = false;
            }

            if (flag)
            {
                points[newLen] = points[i];
                points[newLen + 1] = points[i + 1];
                newLen += 2;
            }
        }
        points.length = len = newLen;

        newLen = 2;
        // 2. remove middle points
        for (let i = 2; i + 2 < len; i += 2)
        {
            let x1 = points[i - 2]; let y1 = points[i - 1]; const x2 = points[i]; const y2 = points[i + 1];
            let x3 = points[i + 2]; let
                y3 = points[i + 3];

            x1 -= x2;
            y1 -= y2;
            x3 -= x2;
            y3 -= y2;
            let flag = true;

            if (Math.abs(x3 * y1 - y3 * x1) < eps2)
            {
                if (x1 * x3 + y1 * y3 < -eps2)
                {
                    flag = false;
                }
            }

            if (flag)
            {
                points[newLen] = points[i];
                points[newLen + 1] = points[i + 1];
                newLen += 2;
            }
        }
        points[newLen] = points[len - 2];
        points[newLen + 1] = points[len - 1];
        newLen += 2;

        points.length = len = newLen;

        if (len <= 2)
        {
            // suddenly, nothing
            return;
        }

        if (closedShape)
        {
            // first point should be last point in closed line!
            const closedPath = Math.abs(firstPoint.x - lastPoint.x) < eps
                && Math.abs(firstPoint.y - lastPoint.y) < eps;

            if (closedPath)
            {
                points.pop();
                points.pop();
            }
        }
    }

    line(graphicsData, buildData)
    {
        const { closeStroke, points } = graphicsData;
        // const eps = buildData.closePointEps;
        // const eps2 = eps * eps;
        const len = points.length;
        // const style = graphicsData.lineStyle;

        if (len <= 2)
        {
            return;
        }
        const { verts, joints } = buildData;

        // TODO: alignment

        const joint = graphicsData.jointType();
        const cap = graphicsData.capType();
        let prevCap = 0;

        let prevX; let
            prevY;

        if (closeStroke)
        {
            prevX = points[len - 2];
            prevY = points[len - 1];
            joints.push(exports.JOINT_TYPE.NONE);
        }
        else
        {
            prevX = points[2];
            prevY = points[3];
            if (cap === exports.JOINT_TYPE.CAP_ROUND)
            {
                verts.push(points[0], points[1]);
                joints.push(exports.JOINT_TYPE.NONE);
                joints.push(exports.JOINT_TYPE.CAP_ROUND);
                prevCap = 0;
            }
            else
            {
                prevCap = cap;
                joints.push(exports.JOINT_TYPE.NONE);
            }
        }
        verts.push(prevX, prevY);

        /* Line segments of interest where (x1,y1) forms the corner. */
        for (let i = 0; i < len; i += 2)
        {
            const x1 = points[i]; const
                y1 = points[i + 1];

            // let x2: number; let
            //     y2: number;

            // if (i + 2 < len)
            // {
            //     x2 = points[i + 2];
            //     y2 = points[i + 3];
            // }
            // else
            // {
            //     x2 = points[0];
            //     y2 = points[1];
            // }

            // const dx = x2 - x1;
            // const dy = y2 - y1;
            // let nextX: number; let
            //     nextY: number;

            let endJoint = joint;

            if (i + 2 >= len)
            {
                // nextX = points[2];
                // nextY = points[3];
                if (!closeStroke)
                {
                    endJoint = exports.JOINT_TYPE.NONE;
                }
            }
            else if (i + 4 >= len)
            {
                // nextX = points[0];
                // nextY = points[1];
                if (!closeStroke)
                {
                    if (cap === exports.JOINT_TYPE.CAP_ROUND)
                    {
                        endJoint = exports.JOINT_TYPE.JOINT_CAP_ROUND;
                    }
                    if (cap === exports.JOINT_TYPE.CAP_BUTT)
                    {
                        endJoint = exports.JOINT_TYPE.JOINT_CAP_BUTT;
                    }
                    if (cap === exports.JOINT_TYPE.CAP_SQUARE)
                    {
                        endJoint = exports.JOINT_TYPE.JOINT_CAP_SQUARE;
                    }
                }
            }
            // else
            // {
            //     nextX = points[i + 4];
            //     nextY = points[i + 5];
            // }

            // const dx3 = x1 - prevX;
            // const dy3 = y1 - prevY;

            endJoint += prevCap;
            prevCap = 0;

            verts.push(x1, y1);
            joints.push(endJoint);

            prevX = x1;
            prevY = y1;
        }

        if (closeStroke)
        {
            verts.push(points[0], points[1]);
            joints.push(exports.JOINT_TYPE.NONE);
            verts.push(points[2], points[3]);
            joints.push(exports.JOINT_TYPE.NONE);
        }
        else
        {
            verts.push(points[len - 4], points[len - 3]);
            joints.push(exports.JOINT_TYPE.NONE);
        }
    }

    fill(graphicsData, buildData)
    {
        let points = graphicsData.points;
        // TODO: simplify holes too!
        const holes = graphicsData.holes;
        const eps = buildData.closePointEps;

        const { verts, joints } = buildData;

        if (points.length < 6)
        {
            return;
        }
        const holeArray = [];
        let len = points.length;

        fixOrientation(points, false);

        // Process holes..
        for (let i = 0; i < holes.length; i++)
        {
            const hole = holes[i];

            fixOrientation(hole.points, true);

            holeArray.push(points.length / 2);
            points = points.concat(hole.points);
        }

        // TODO: reduce size later?
        const pn = tempArr;

        if (pn.length < points.length)
        {
            pn.length = points.length;
        }
        let start = 0;

        for (let i = 0; i <= holeArray.length; i++)
        {
            let finish = len / 2;

            if (i > 0)
            {
                if (i < holeArray.length)
                {
                    finish = holeArray[i];
                }
                else
                {
                    finish = (points.length >> 1);
                }
            }
            pn[start * 2] = finish - 1;
            pn[(finish - 1) * 2 + 1] = start;
            for (let j = start; j + 1 < finish; j++)
            {
                pn[j * 2 + 1] = j + 1;
                pn[j * 2 + 2] = j;
            }
            start = finish;
        }

        // sort color
        graphicsData.triangles = utils.earcut(points, holeArray, 2);

        if (!graphicsData.triangles)
        {
            return;
        }

        if (!graphicsData.fillAA)
        {
            for (let i = 0; i < points.length; i += 2)
            {
                verts.push(points[i], points[i + 1]);
                joints.push(exports.JOINT_TYPE.FILL);
            }

            return;
        }

        const { triangles } = graphicsData;

        len = points.length;

        for (let i = 0; i < triangles.length; i += 3)
        {
            // TODO: holes prev/next!!!
            let flag = 0;

            for (let j = 0; j < 3; j++)
            {
                const ind1 = triangles[i + j];
                const ind2 = triangles[i + (j + 1) % 3];

                if (pn[ind1 * 2] === ind2 || pn[ind1 * 2 + 1] === ind2)
                {
                    flag |= (1 << j);
                }
            }
            joints.push(exports.JOINT_TYPE.FILL_EXPAND + flag);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
            joints.push(exports.JOINT_TYPE.NONE);
        }

        // bisect, re-using pn
        for (let ind = 0; ind < len / 2; ind++)
        {
            const prev = pn[ind * 2];
            const next = pn[ind * 2 + 1];
            let nx1 = (points[next * 2 + 1] - points[ind * 2 + 1]); let
                ny1 = -(points[next * 2] - points[ind * 2]);
            let nx2 = (points[ind * 2 + 1] - points[prev * 2 + 1]); let
                ny2 = -(points[ind * 2] - points[prev * 2]);
            const D1 = Math.sqrt(nx1 * nx1 + ny1 * ny1);

            nx1 /= D1;
            ny1 /= D1;
            const D2 = Math.sqrt(nx2 * nx2 + ny2 * ny2);

            nx2 /= D2;
            ny2 /= D2;

            let bx = (nx1 + nx2);
            let by = (ny1 + ny2);
            const D = bx * nx1 + by * ny1;

            if (Math.abs(D) < eps)
            {
                bx = nx1;
                by = ny1;
            }
            else
            {
                bx /= D;
                by /= D;
            }
            pn[ind * 2] = bx;
            pn[ind * 2 + 1] = by;
        }

        for (let i = 0; i < triangles.length; i += 3)
        {
            const prev = triangles[i];
            const ind = triangles[i + 1];
            const next = triangles[i + 2];
            const nx1 = (points[next * 2 + 1] - points[ind * 2 + 1]); const
                ny1 = -(points[next * 2] - points[ind * 2]);
            const nx2 = (points[ind * 2 + 1] - points[prev * 2 + 1]); const
                ny2 = -(points[ind * 2] - points[prev * 2]);

            let j1 = 1;

            if (nx1 * ny2 - nx2 * ny1 > 0.0)
            {
                j1 = 2;
            }

            for (let j = 0; j < 3; j++)
            {
                const ind = triangles[i + (j * j1) % 3];

                verts.push(points[ind * 2], points[ind * 2 + 1]);
            }
            for (let j = 0; j < 3; j++)
            {
                const ind = triangles[i + (j * j1) % 3];

                verts.push(pn[ind * 2], pn[ind * 2 + 1]);
            }
        }
    }
}

class RectangleBuilder 
{constructor() { RectangleBuilder.prototype.__init.call(this); }
    __init() {this._polyBuilder = new PolyBuilder();}

    path(graphicsData, _target)
    {
        // --- //
        // need to convert points to a nice regular data
        //
        const rectData = graphicsData.shape ;
        const x = rectData.x;
        const y = rectData.y;
        const width = rectData.width;
        const height = rectData.height;
        const points = graphicsData.points;

        points.length = 0;

        points.push(x, y,
            x + width, y,
            x + width, y + height,
            x, y + height);
    }

    line(graphicsData, target)
    {
        const { verts, joints } = target;
        const { points } = graphicsData;

        const joint = graphicsData.goodJointType();
        const len = points.length;

        verts.push(points[len - 2], points[len - 1]);
        joints.push(exports.JOINT_TYPE.NONE);
        for (let i = 0; i < len; i += 2)
        {
            verts.push(points[i], points[i + 1]);
            joints.push(joint);
        }
        verts.push(points[0], points[1]);
        joints.push(exports.JOINT_TYPE.NONE);
        verts.push(points[2], points[3]);
        joints.push(exports.JOINT_TYPE.NONE);
    }

    fill(graphicsData, target)
    {
        const { verts, joints } = target;
        const { points, triangles } = graphicsData;

        triangles.length = 0;

        if (!graphicsData.fillAA)
        {
            verts.push(points[0], points[1],
                points[2], points[3],
                points[4], points[5],
                points[6], points[7]);

            joints.push(exports.JOINT_TYPE.FILL, exports.JOINT_TYPE.FILL, exports.JOINT_TYPE.FILL, exports.JOINT_TYPE.FILL);
            triangles.push(0, 1, 2, 0, 2, 3);

            return;
        }

        this._polyBuilder.fill(graphicsData, target);
    }
}

function getPt(n1, n2, perc)
{
    const diff = n2 - n1;

    return n1 + (diff * perc);
}

function quadraticBezierCurve(
    fromX, fromY,
    cpX, cpY,
    toX, toY,
    out = [],
    eps = 0.001)
{
    const n = 20;
    const points = out;

    let xa = 0;
    let ya = 0;
    let xb = 0;
    let yb = 0;
    let x = 0;
    let y = 0;

    for (let i = 0, j = 0; i <= n; ++i)
    {
        j = i / n;

        // The Green Line
        xa = getPt(fromX, cpX, j);
        ya = getPt(fromY, cpY, j);
        xb = getPt(cpX, toX, j);
        yb = getPt(cpY, toY, j);

        // The Black Dot
        x = getPt(xa, xb, j);
        y = getPt(ya, yb, j);

        // Handle case when first curve points overlaps and earcut fails to triangulate
        if (i === 0
            && Math.abs(x - points[points.length - 2]) < eps
            && Math.abs(y - points[points.length - 1]) < eps)
        {
            continue;
        }

        points.push(x, y);
    }

    return points;
}

class RoundedRectangleBuilder 
{constructor() { RoundedRectangleBuilder.prototype.__init.call(this); }
    __init() {this._circleBuilder = new CircleBuilder();}

    path(graphicsData, _target)
    {
        if ((graphics.Graphics ).nextRoundedRectBehavior)
        {
            this._circleBuilder.path(graphicsData, _target);

            return;
        }

        const rrectData = graphicsData.shape ;
        const { points } = graphicsData;
        const x = rrectData.x;
        const y = rrectData.y;
        const width = rrectData.width;
        const height = rrectData.height;

        // Don't allow negative radius or greater than half the smallest width
        const radius = Math.max(0, Math.min(rrectData.radius, Math.min(width, height) / 2));

        points.length = 0;

        // No radius, do a simple rectangle
        if (!radius)
        {
            points.push(x, y,
                x + width, y,
                x + width, y + height,
                x, y + height);
        }
        else
        {
            const eps = _target.closePointEps;

            quadraticBezierCurve(x, y + radius,
                x, y,
                x + radius, y,
                points, eps);
            quadraticBezierCurve(x + width - radius,
                y, x + width, y,
                x + width, y + radius,
                points, eps);
            quadraticBezierCurve(x + width, y + height - radius,
                x + width, y + height,
                x + width - radius, y + height,
                points, eps);
            quadraticBezierCurve(x + radius, y + height,
                x, y + height,
                x, y + height - radius,
                points, eps);

            if (points.length >= 4
                && Math.abs(points[0] - points[points.length - 2]) < eps
                && Math.abs(points[1] - points[points.length - 1]) < eps)
            {
                points.pop();
                points.pop();
            }
        }
    }

    line(graphicsData, target)
    {
        this._circleBuilder.line(graphicsData, target);
    }

    fill(graphicsData, target)
    {
        this._circleBuilder.fill(graphicsData, target);
    }
}

const FILL_COMMANDS = {
    [math.SHAPES.POLY]: new PolyBuilder(),
    [math.SHAPES.CIRC]: new CircleBuilder(),
    [math.SHAPES.ELIP]: new CircleBuilder(),
    [math.SHAPES.RECT]: new RectangleBuilder(),
    [math.SHAPES.RREC]: new RoundedRectangleBuilder()
};

/*
 * Complex shape type
 * @todo Move to Math shapes
 */


const BATCH_POOL = [];
const DRAW_CALL_POOL = [];

const tmpPoint = new math.Point();
const tmpBounds = new display.Bounds();

class SmoothGraphicsGeometry extends core.Geometry
{
     static __initStatic() {this.BATCHABLE_SIZE = 100;}

    

    __init() {this.indicesUint16 = null;}
    

    

    get points()
    {
        return this.buildData.verts;
    }

    get closePointEps()
    {
        return this.buildData.closePointEps;
    }

    
    
    
    
    
    
    
    

    
    
    
    
    
    
    

    
    
    
    

    initAttributes(_static)
    {
        this._buffer = new core.Buffer(null, _static, false);
        this._bufferFloats = new Float32Array();
        this._bufferUint = new Uint32Array();

        this._indexBuffer = new core.Buffer(null, _static, true);
        this.addAttribute('aPrev', this._buffer, 2, false, constants.TYPES.FLOAT)
            .addAttribute('aPoint1', this._buffer, 2, false, constants.TYPES.FLOAT)
            .addAttribute('aPoint2', this._buffer, 2, false, constants.TYPES.FLOAT)
            .addAttribute('aNext', this._buffer, 2, false, constants.TYPES.FLOAT)
            .addAttribute('aTravel', this._buffer, 1, false, constants.TYPES.FLOAT)
            // number of vertex
            .addAttribute('aVertexJoint', this._buffer, 1, false, constants.TYPES.FLOAT)
            // line width, alignment
            .addAttribute('aStyleId', this._buffer, 1, false, constants.TYPES.FLOAT)
            // the usual
            .addAttribute('aColor', this._buffer, 4, true, constants.TYPES.UNSIGNED_BYTE)
            .addIndex(this._indexBuffer);

        this.strideFloats = 12;
    }

    constructor()
    {
        super();SmoothGraphicsGeometry.prototype.__init.call(this);
        this.initAttributes(false);

        this.buildData = new BuildData();

        this.graphicsData = [];

        this.dirty = 0;

        this.batchDirty = -1;

        this.cacheDirty = -1;

        this.clearDirty = 0;

        this.drawCalls = [];

        this.batches = [];

        this.shapeBuildIndex = 0;

        this.shapeBatchIndex = 0;

        this._bounds = new display.Bounds();

        this.boundsDirty = -1;

        this.boundsPadding = 0;

        this.batchable = false;

        this.indicesUint16 = null;

        this.packer = null;
        this.packSize = 0;
        this.pack32index = null;
    }

     checkInstancing(instanced, allow32Indices)
    {
        if (this.packer)
        {
            return;
        }
        this.packer = new SegmentPacker();
        this.pack32index = allow32Indices;
    }

    /**
     * Get the current bounds of the graphic geometry.
     *
     * @member {PIXI.Bounds}
     * @readonly
     */
     get bounds()
    {
        if (this.boundsDirty !== this.dirty)
        {
            this.boundsDirty = this.dirty;
            this.calculateBounds();
        }

        return this._bounds;
    }

    /**
     * Call if you changed graphicsData manually.
     * Empties all batch buffers.
     */
     invalidate()
    {
        this.boundsDirty = -1;
        this.dirty++;
        this.batchDirty++;
        this.shapeBuildIndex = 0;
        this.shapeBatchIndex = 0;
        this.packSize = 0;

        this.buildData.clear();

        for (let i = 0; i < this.drawCalls.length; i++)
        {
            this.drawCalls[i].clear();
            DRAW_CALL_POOL.push(this.drawCalls[i]);
        }

        this.drawCalls.length = 0;

        for (let i = 0; i < this.batches.length; i++)
        {
            const batchPart = this.batches[i];

            batchPart.reset();
            BATCH_POOL.push(batchPart);
        }

        this.batches.length = 0;
    }

     clear()
    {
        if (this.graphicsData.length > 0)
        {
            this.invalidate();
            this.clearDirty++;
            this.graphicsData.length = 0;
        }

        return this;
    }

     drawShape(
        shape,
        fillStyle = null,
        lineStyle = null,
        matrix = null)
    {
        const data = new SmoothGraphicsData(shape, fillStyle, lineStyle, matrix);

        this.graphicsData.push(data);
        this.dirty++;

        return this;
    }

     drawHole(shape, matrix = null)
    {
        if (!this.graphicsData.length)
        {
            return null;
        }

        const data = new SmoothGraphicsData(shape, null, null, matrix);

        const lastShape = this.graphicsData[this.graphicsData.length - 1];

        data.lineStyle = lastShape.lineStyle;

        lastShape.holes.push(data);

        this.dirty++;

        return this;
    }

     destroy()
    {
        super.destroy();

        // destroy each of the SmoothGraphicsData objects
        for (let i = 0; i < this.graphicsData.length; ++i)
        {
            this.graphicsData[i].destroy();
        }

        this.buildData.destroy();
        this.buildData = null;
        this.indexBuffer.destroy();
        this.indexBuffer = null;
        this.graphicsData.length = 0;
        this.graphicsData = null;
        this.drawCalls.length = 0;
        this.drawCalls = null;
        this.batches.length = 0;
        this.batches = null;
        this._bounds = null;
    }

    /**
     * Check to see if a point is contained within this geometry.
     *
     * @param {PIXI.IPointData} point - Point to check if it's contained.
     * @return {Boolean} `true` if the point is contained within geometry.
     */
     containsPoint(point)
    {
        const graphicsData = this.graphicsData;

        for (let i = 0; i < graphicsData.length; ++i)
        {
            const data = graphicsData[i];

            if (!data.fillStyle.visible)
            {
                continue;
            }

            // only deal with fills..
            if (data.shape)
            {
                if (data.matrix)
                {
                    data.matrix.applyInverse(point, tmpPoint);
                }
                else
                {
                    tmpPoint.copyFrom(point);
                }

                if (data.shape.contains(tmpPoint.x, tmpPoint.y))
                {
                    let hitHole = false;

                    if (data.holes)
                    {
                        for (let i = 0; i < data.holes.length; i++)
                        {
                            const hole = data.holes[i];

                            if (hole.shape.contains(tmpPoint.x, tmpPoint.y))
                            {
                                hitHole = true;
                                break;
                            }
                        }
                    }

                    if (!hitHole)
                    {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    updatePoints()
    {
        // do nothing
    }

    updateBufferSize()
    {
        this._buffer.update(new Float32Array());
    }

    updateBuild()
    {
        const { graphicsData, buildData } = this;
        const len = graphicsData.length;

        for (let i = this.shapeBuildIndex; i < len; i++)
        {
            const data = graphicsData[i];

            data.strokeStart = 0;
            data.strokeLen = 0;
            data.fillStart = 0;
            data.fillLen = 0;
            const { fillStyle, lineStyle, holes } = data;

            if (!fillStyle.visible && !lineStyle.visible)
            {
                continue;
            }

            const command = FILL_COMMANDS[data.type];

            data.clearPath();

            command.path(data, buildData);
            if (data.matrix)
            {
                this.transformPoints(data.points, data.matrix);
            }

            data.clearBuild();
            if (data.points.length <= 2)
            {
                continue;
            }
            if (fillStyle.visible || lineStyle.visible)
            {
                this.processHoles(holes);
            }
            if (fillStyle.visible)
            {
                data.fillAA = (data.fillStyle ).smooth
                    && data.fillStyle.texture === core.Texture.WHITE
                    && holes.length === 0
                    && !(data.closeStroke
                    && data.lineStyle.visible
                    && !data.lineStyle.shader
                    && data.lineStyle.alpha >= 0.99
                    && data.lineStyle.width * Math.min(data.lineStyle.alignment, 1 - data.lineStyle.alignment) >= 0.495);

                data.fillStart = buildData.joints.length;

                if (holes.length)
                {
                    FILL_COMMANDS[math.SHAPES.POLY].fill(data, buildData);
                }
                else
                {
                    command.fill(data, buildData);
                }

                data.fillLen = buildData.joints.length - data.fillStart;
            }
            if (lineStyle.visible)
            {
                data.strokeStart = buildData.joints.length;
                command.line(data, buildData);
                for (let i = 0; i < holes.length; i++)
                {
                    const hole = holes[i];
                    FILL_COMMANDS[hole.type].line(hole, buildData);
                }
                data.strokeLen = buildData.joints.length - data.strokeStart;
            }
        }
        this.shapeBuildIndex = len;
    }

    updateBatches(shaderSettings)
    {
        if (!this.graphicsData.length)
        {
            this.batchable = true;

            return;
        }
        this.updateBuild();

        if (!this.validateBatching())
        {
            return;
        }

        const { buildData, graphicsData } = this;
        const len = graphicsData.length;

        this.cacheDirty = this.dirty;

        let batchPart = null;

        let currentStyle = null;

        if (this.batches.length > 0)
        {
            batchPart = this.batches[this.batches.length - 1];
            currentStyle = batchPart.style;
        }

        for (let i = this.shapeBatchIndex; i < len; i++)
        {
            const data = graphicsData[i];
            const fillStyle = data.fillStyle;
            const lineStyle = data.lineStyle;

            if (data.matrix)
            {
                this.transformPoints(data.points, data.matrix);
            }
            if (!fillStyle.visible && !lineStyle.visible)
            {
                continue;
            }
            for (let j = 0; j < 2; j++)
            {
                const style = (j === 0) ? fillStyle : lineStyle;

                if (!style.visible) continue;

                const nextTexture = style.texture.baseTexture;
                const attribOld = buildData.vertexSize;
                const indexOld = buildData.indexSize;

                nextTexture.wrapMode = constants.WRAP_MODES.REPEAT;
                if (j === 0)
                {
                    this.packer.updateBufferSize(data.fillStart, data.fillLen, data.triangles.length, buildData);
                }
                else
                {
                    this.packer.updateBufferSize(data.strokeStart, data.strokeLen, data.triangles.length, buildData);
                }

                const attribSize = buildData.vertexSize;

                if (attribSize === attribOld) continue;
                // close batch if style is different
                if (batchPart && !this._compareStyles(currentStyle, style))
                {
                    batchPart.end(indexOld, attribOld);
                    batchPart = null;
                }
                // spawn new batch if its first batch or previous was closed
                if (!batchPart)
                {
                    batchPart = BATCH_POOL.pop() || new BatchPart();
                    batchPart.begin(style, indexOld, attribOld);
                    this.batches.push(batchPart);
                    currentStyle = style;
                }

                if (j === 0)
                {
                    batchPart.jointEnd = data.fillStart + data.fillLen;
                }
                else
                {
                    batchPart.jointEnd = data.strokeStart + data.strokeLen;
                }
            }
        }
        this.shapeBatchIndex = len;

        if (batchPart)
        {
            batchPart.end(buildData.indexSize, buildData.vertexSize);
        }

        if (this.batches.length === 0)
        {
            // there are no visible styles in SmoothGraphicsData
            // its possible that someone wants Graphics just for the bounds
            this.batchable = true;

            return;
        }

        // TODO make this a const..
        this.batchable = this.isBatchable();

        if (this.batchable)
        {
            this.packBatches();
        }
        else
        {
            this.buildDrawCalls(shaderSettings);
            this.updatePack();
        }
    }

    updatePack()
    {
        const { vertexSize, indexSize } = this.buildData;

        if (this.packSize === vertexSize)
        {
            return;
        }

        const { strideFloats, packer, buildData, batches } = this;
        const buffer = this._buffer;
        const index = this._indexBuffer;
        const floatsSize = vertexSize * strideFloats;

        if (buffer.data.length !== floatsSize)
        {
            const arrBuf = new ArrayBuffer(floatsSize * 4);

            this._bufferFloats = new Float32Array(arrBuf);
            this._bufferUint = new Uint32Array(arrBuf);
            buffer.data = this._bufferFloats;
        }
        if (index.data.length !== indexSize)
        {
            if (vertexSize > 0xffff && this.pack32index)
            {
                index.data = new Uint32Array(indexSize);
            }
            else
            {
                index.data = new Uint16Array(indexSize);
            }
        }

        packer.beginPack(buildData, this._bufferFloats, this._bufferUint, index.data );

        let j = 0;

        for (let i = 0; i < this.graphicsData.length; i++)
        {
            const data = this.graphicsData[i];

            if (data.fillLen)
            {
                while (batches[j].jointEnd <= data.fillStart)
                {
                    j++;
                }
                packer.packInterleavedGeometry(data.fillStart, data.fillLen, data.triangles,
                    batches[j].styleId, batches[j].rgba);
            }
            if (data.strokeLen)
            {
                while (batches[j].jointEnd <= data.strokeStart)
                {
                    j++;
                }
                packer.packInterleavedGeometry(data.strokeStart, data.strokeLen, data.triangles,
                    batches[j].styleId, batches[j].rgba);
            }
        }

        buffer.update();
        index.update();
        this.packSize = vertexSize;
    }

    /**
     * Affinity check
     *
     * @param {PIXI.FillStyle | PIXI.LineStyle} styleA
     * @param {PIXI.FillStyle | PIXI.LineStyle} styleB
     */
     _compareStyles(styleA, styleB)
    {
        if (!styleA || !styleB)
        {
            return false;
        }

        if (styleA.texture.baseTexture !== styleB.texture.baseTexture)
        {
            return false;
        }

        if (styleA.color + styleA.alpha !== styleB.color + styleB.alpha)
        {
            return false;
        }
        // TODO: propagate width for FillStyle
        if ((styleA ).width !== (styleB ).width)
        {
            return false;
        }
        if ((styleA ).scaleMode !== (styleB ).scaleMode)
        {
            return false;
        }
        if ((styleA ).alignment !== (styleB ).alignment)
        {
            return false;
        }

        const mat1 = styleA.matrix || math.Matrix.IDENTITY;
        const mat2 = styleB.matrix || math.Matrix.IDENTITY;

        return matrixEquals(mat1, mat2);
    }

    /**
     * Test geometry for batching process.
     *
     * @protected
     */
     validateBatching()
    {
        if (this.dirty === this.cacheDirty || !this.graphicsData.length)
        {
            return false;
        }

        for (let i = 0, l = this.graphicsData.length; i < l; i++)
        {
            const data = this.graphicsData[i];
            const fill = data.fillStyle;
            const line = data.lineStyle;

            if (fill && !fill.texture.baseTexture.valid) return false;
            if (line && !line.texture.baseTexture.valid) return false;
        }

        return true;
    }

    /**
     * Offset the indices so that it works with the batcher.
     *
     * @protected
     */
     packBatches()
    {
        this.batchDirty++;
        const batches = this.batches;

        for (let i = 0, l = batches.length; i < l; i++)
        {
            const batch = batches[i];

            for (let j = 0; j < batch.size; j++)
            {
                const index = batch.start + j;

                this.indicesUint16[index] = this.indicesUint16[index] - batch.attribStart;
            }
        }
    }

     isBatchable()
    {
        return false;

        // prevent heavy mesh batching
        // if (this.points.length > 0xffff * 2) {
        //     return false;
        // }
        //
        // const batches = this.batches;
        //
        // for (let i = 0; i < batches.length; i++) {
        //     if ((batches[i].style as LineStyle).native) {
        //         return false;
        //     }
        // }
        //
        // return (this.points.length < SmoothGraphicsGeometry.BATCHABLE_SIZE * 2);
    }

    /**
     * Converts intermediate batches data to drawCalls.
     *
     * @protected
     */
     buildDrawCalls(shaderSettings)
    {
        for (let i = 0; i < this.drawCalls.length; i++)
        {
            this.drawCalls[i].clear();
            DRAW_CALL_POOL.push(this.drawCalls[i]);
        }

        this.drawCalls.length = 0;

        let currentGroup = DRAW_CALL_POOL.pop() || new BatchDrawCall();

        currentGroup.begin(shaderSettings, null);

        let index = 0;

        this.drawCalls.push(currentGroup);

        for (let i = 0; i < this.batches.length; i++)
        {
            const batchData = this.batches[i];
            const style = batchData.style ;

            if (batchData.attribSize === 0)
            {
                // I don't know how why do we have size=0 sometimes
                continue;
            }

            let styleId = -1;
            const mat = style.getTextureMatrix();

            if (currentGroup.check(style.shader))
            {
                styleId = currentGroup.add(style.texture, mat,
                    style.width, style.alignment || 0, style.packLineScale());
            }
            if (styleId < 0)
            {
                currentGroup = DRAW_CALL_POOL.pop() || new BatchDrawCall();
                this.drawCalls.push(currentGroup);
                currentGroup.begin(shaderSettings, style.shader);
                currentGroup.start = index;
                styleId = currentGroup.add(style.texture, mat,
                    style.width, style.alignment || 0, style.packLineScale());
            }
            currentGroup.size += batchData.size;
            index += batchData.size;

            const { color, alpha } = style;
            const rgb = (color >> 16) + (color & 0xff00) + ((color & 0xff) << 16);

            batchData.rgba = utils.premultiplyTint(rgb, alpha);
            batchData.styleId = styleId;
        }
    }

     processHoles(holes)
    {
        for (let i = 0; i < holes.length; i++)
        {
            const hole = holes[i];
            const command = FILL_COMMANDS[hole.type];

            hole.clearPath();

            command.path(hole, this.buildData);

            if (hole.matrix)
            {
                this.transformPoints(hole.points, hole.matrix);
            }
        }
    }

    /**
     * Update the local bounds of the object. Expensive to use performance-wise.
     *
     * @protected
     */
     calculateBounds()
    {
        const bounds = this._bounds;
        const sequenceBounds = tmpBounds;
        let curMatrix = math.Matrix.IDENTITY;

        this._bounds.clear();
        sequenceBounds.clear();

        for (let i = 0; i < this.graphicsData.length; i++)
        {
            const data = this.graphicsData[i];
            const shape = data.shape;
            const type = data.type;
            const lineStyle = data.lineStyle;
            const nextMatrix = data.matrix || math.Matrix.IDENTITY;
            let lineWidth = 0.0;

            if (lineStyle && lineStyle.visible)
            {
                lineWidth = lineStyle.width;

                if (type !== math.SHAPES.POLY || data.fillStyle.visible)
                {
                    lineWidth *= Math.max(0, lineStyle.alignment);
                }
                else
                {
                    lineWidth *= Math.max(lineStyle.alignment, 1 - lineStyle.alignment);
                }
            }

            if (curMatrix !== nextMatrix)
            {
                if (!sequenceBounds.isEmpty())
                {
                    bounds.addBoundsMatrix(sequenceBounds, curMatrix);
                    sequenceBounds.clear();
                }
                curMatrix = nextMatrix;
            }

            if (type === math.SHAPES.RECT || type === math.SHAPES.RREC)
            {
                const rect = shape ;

                sequenceBounds.addFramePad(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height,
                    lineWidth, lineWidth);
            }
            else if (type === math.SHAPES.CIRC)
            {
                const circle = shape ;

                sequenceBounds.addFramePad(circle.x, circle.y, circle.x, circle.y,
                    circle.radius + lineWidth, circle.radius + lineWidth);
            }
            else if (type === math.SHAPES.ELIP)
            {
                const ellipse = shape ;

                sequenceBounds.addFramePad(ellipse.x, ellipse.y, ellipse.x, ellipse.y,
                    ellipse.width + lineWidth, ellipse.height + lineWidth);
            }
            else
            {
                const poly = shape ;
                // adding directly to the bounds

                bounds.addVerticesMatrix(curMatrix, (poly.points ), 0, poly.points.length, lineWidth, lineWidth);
            }
        }

        if (!sequenceBounds.isEmpty())
        {
            bounds.addBoundsMatrix(sequenceBounds, curMatrix);
        }

        bounds.pad(this.boundsPadding, this.boundsPadding);
    }

    /**
     * Transform points using matrix.
     *
     * @protected
     * @param {number[]} points - Points to transform
     * @param {PIXI.Matrix} matrix - Transform matrix
     */
     transformPoints(points, matrix)
    {
        for (let i = 0; i < points.length / 2; i++)
        {
            const x = points[(i * 2)];
            const y = points[(i * 2) + 1];

            points[(i * 2)] = (matrix.a * x) + (matrix.c * y) + matrix.tx;
            points[(i * 2) + 1] = (matrix.b * x) + (matrix.d * y) + matrix.ty;
        }
    }
} SmoothGraphicsGeometry.__initStatic();

const smoothVert = `#version 100
precision highp float;
const float FILL = 1.0;
const float BEVEL = 4.0;
const float MITER = 8.0;
const float ROUND = 12.0;
const float JOINT_CAP_BUTT = 16.0;
const float JOINT_CAP_SQUARE = 18.0;
const float JOINT_CAP_ROUND = 20.0;

const float FILL_EXPAND = 24.0;

const float CAP_BUTT = 1.0;
const float CAP_SQUARE = 2.0;
const float CAP_ROUND = 3.0;
const float CAP_BUTT2 = 4.0;

const float MITER_LIMIT = 10.0;

// === geom ===
attribute vec2 aPrev;
attribute vec2 aPoint1;
attribute vec2 aPoint2;
attribute vec2 aNext;
attribute float aVertexJoint;
attribute float aTravel;

uniform mat3 projectionMatrix;
uniform mat3 translationMatrix;
uniform vec4 tint;

varying vec4 vLine1;
varying vec4 vLine2;
varying vec4 vArc;
varying float vType;

uniform float resolution;
uniform float expand;

// === style ===
attribute float aStyleId;
attribute vec4 aColor;

varying float vTextureId;
varying vec4 vColor;
varying vec2 vTextureCoord;
varying vec2 vTravel;

uniform vec2 styleLine[%MAX_STYLES%];
uniform vec3 styleMatrix[2 * %MAX_STYLES%];
uniform float styleTextureId[%MAX_STYLES%];
uniform vec2 samplerSize[%MAX_TEXTURES%];

vec2 doBisect(vec2 norm, float len, vec2 norm2, float len2,
    float dy, float inner) {
    vec2 bisect = (norm + norm2) / 2.0;
    bisect /= dot(norm, bisect);
    vec2 shift = dy * bisect;
    if (inner > 0.5) {
        if (len < len2) {
            if (abs(dy * (bisect.x * norm.y - bisect.y * norm.x)) > len) {
                return dy * norm;
            }
        } else {
            if (abs(dy * (bisect.x * norm2.y - bisect.y * norm2.x)) > len2) {
                return dy * norm;
            }
        }
    }
    return dy * bisect;
}

void main(void){
    vec2 pointA = (translationMatrix * vec3(aPoint1, 1.0)).xy;
    vec2 pointB = (translationMatrix * vec3(aPoint2, 1.0)).xy;

    vec2 xBasis = pointB - pointA;
    float len = length(xBasis);
    vec2 forward = xBasis / len;
    vec2 norm = vec2(forward.y, -forward.x);

    float type = floor(aVertexJoint / 16.0);
    float vertexNum = aVertexJoint - type * 16.0;
    float dx = 0.0, dy = 1.0;

    float capType = floor(type / 32.0);
    type -= capType * 32.0;

    int styleId = int(aStyleId + 0.5);
    float lineWidth = styleLine[styleId].x;
    vTextureId = floor(styleTextureId[styleId] / 4.0);
    float scaleMode = styleTextureId[styleId] - vTextureId * 4.0;
    float avgScale = 1.0;
    if (scaleMode > 2.5) {
        avgScale = length(translationMatrix * vec3(1.0, 0.0, 0.0));
    } else if (scaleMode > 1.5) {
        avgScale = length(translationMatrix * vec3(0.0, 1.0, 0.0));
    } else if (scaleMode > 0.5) {
        vec2 avgDiag = (translationMatrix * vec3(1.0, 1.0, 0.0)).xy;
        avgScale = sqrt(dot(avgDiag, avgDiag) * 0.5);
    }
    lineWidth *= 0.5 * avgScale;
    float lineAlignment = 2.0 * styleLine[styleId].y - 1.0;
    vTextureCoord = vec2(0.0);

    vec2 pos;

    if (capType == CAP_ROUND) {
        vertexNum += 4.0;
        type = JOINT_CAP_ROUND;
        capType = 0.0;
        lineAlignment = -lineAlignment;
    }

    vLine1 = vec4(0.0, 10.0, 1.0, 0.0);
    vLine2 = vec4(0.0, 10.0, 1.0, 0.0);
    vArc = vec4(0.0);
    if (type == FILL) {
        pos = pointA;
        vType = 0.0;
        vLine2 = vec4(-2.0, -2.0, -2.0, 0.0);
        vec2 vTexturePixel;
        vTexturePixel.x = dot(vec3(aPoint1, 1.0), styleMatrix[styleId * 2]);
        vTexturePixel.y = dot(vec3(aPoint1, 1.0), styleMatrix[styleId * 2 + 1]);
        vTextureCoord = vTexturePixel / samplerSize[int(vTextureId)];
    } else if (type >= FILL_EXPAND && type < FILL_EXPAND + 7.5) {
        // expand vertices
        float flags = type - FILL_EXPAND;
        float flag3 = floor(flags / 4.0);
        float flag2 = floor((flags - flag3 * 4.0) / 2.0);
        float flag1 = flags - flag3 * 4.0 - flag2 * 2.0;

        vec2 prev = (translationMatrix * vec3(aPrev, 1.0)).xy;

        if (vertexNum < 0.5) {
            pos = prev;
        } else if (vertexNum < 1.5) {
            pos = pointA;
        } else {
            pos = pointB;
        }
        float len2 = length(aNext);
        vec2 bisect = (translationMatrix * vec3(aNext, 0.0)).xy;
        if (len2 > 0.01) {
            bisect = normalize(bisect) * len2;
        }

        vec2 n1 = normalize(vec2(pointA.y - prev.y, -(pointA.x - prev.x)));
        vec2 n2 = normalize(vec2(pointB.y - pointA.y, -(pointB.x - pointA.x)));
        vec2 n3 = normalize(vec2(prev.y - pointB.y, -(prev.x - pointB.x)));

        if (n1.x * n2.y - n1.y * n2.x < 0.0) {
            n1 = -n1;
            n2 = -n2;
            n3 = -n3;
        }
        pos += bisect * expand;

        vLine1 = vec4(16.0, 16.0, 16.0, -1.0);
        if (flag1 > 0.5) {
            vLine1.x = -dot(pos - prev, n1);
        }
        if (flag2 > 0.5) {
            vLine1.y = -dot(pos - pointA, n2);
        }
        if (flag3 > 0.5) {
            vLine1.z = -dot(pos - pointB, n3);
        }
        vLine1.xyz *= resolution;
        vType = 2.0;
    } else if (type >= BEVEL) {
        float dy = lineWidth + expand;
        float shift = lineWidth * lineAlignment;
        float inner = 0.0;
        if (vertexNum >= 1.5) {
            dy = -dy;
            inner = 1.0;
        }

        vec2 base, next, xBasis2, bisect;
        float flag = 0.0;
        float side2 = 1.0;
        if (vertexNum < 0.5 || vertexNum > 2.5 && vertexNum < 3.5) {
            next = (translationMatrix * vec3(aPrev, 1.0)).xy;
            base = pointA;
            flag = type - floor(type / 2.0) * 2.0;
            side2 = -1.0;
        } else {
            next = (translationMatrix * vec3(aNext, 1.0)).xy;
            base = pointB;
            if (type >= MITER && type < MITER + 3.5) {
                flag = step(MITER + 1.5, type);
                // check miter limit here?
            }
        }
        xBasis2 = next - base;
        float len2 = length(xBasis2);
        vec2 norm2 = vec2(xBasis2.y, -xBasis2.x) / len2;
        float D = norm.x * norm2.y - norm.y * norm2.x;
        if (D < 0.0) {
            inner = 1.0 - inner;
        }

        norm2 *= side2;

        float collinear = step(0.0, dot(norm, norm2));

        vType = 0.0;
        float dy2 = -1000.0;

        if (abs(D) < 0.01 && collinear < 0.5) {
            if (type >= ROUND && type < ROUND + 1.5) {
                type = JOINT_CAP_ROUND;
            }
            //TODO: BUTT here too
        }

        vLine1 = vec4(0.0, lineWidth, max(abs(norm.x), abs(norm.y)), min(abs(norm.x), abs(norm.y)));
        vLine2 = vec4(0.0, lineWidth, max(abs(norm2.x), abs(norm2.y)), min(abs(norm2.x), abs(norm2.y)));

        if (vertexNum < 3.5) {
            if (abs(D) < 0.01 && collinear < 0.5) {
                pos = (shift + dy) * norm;
            } else {
                if (flag < 0.5 && inner < 0.5) {
                    pos = (shift + dy) * norm;
                } else {
                    pos = doBisect(norm, len, norm2, len2, shift + dy, inner);
                }
            }
            vLine2.y = -1000.0;
            if (capType >= CAP_BUTT && capType < CAP_ROUND) {
                float extra = step(CAP_SQUARE, capType) * lineWidth;
                vec2 back = -forward;
                if (vertexNum < 0.5 || vertexNum > 2.5) {
                    pos += back * (expand + extra);
                    dy2 = expand;
                } else {
                    dy2 = dot(pos + base - pointA, back) - extra;
                }
            }
            if (type >= JOINT_CAP_BUTT && type < JOINT_CAP_SQUARE + 0.5) {
                float extra = step(JOINT_CAP_SQUARE, type) * lineWidth;
                if (vertexNum < 0.5 || vertexNum > 2.5) {
                    vLine2.y = dot(pos + base - pointB, forward) - extra;
                } else {
                    pos += forward * (expand + extra);
                    vLine2.y = expand;
                    if (capType >= CAP_BUTT) {
                        dy2 -= expand + extra;
                    }
                }
            }
        } else if (type >= JOINT_CAP_ROUND && type < JOINT_CAP_ROUND + 1.5) {
            base += shift * norm;
            if (inner > 0.5) {
                dy = -dy;
                inner = 0.0;
            }
            vec2 d2 = abs(dy) * forward;
            if (vertexNum < 4.5) {
                dy = -dy;
                pos = dy * norm;
            } else if (vertexNum < 5.5) {
                pos = dy * norm;
            } else if (vertexNum < 6.5) {
                pos = dy * norm + d2;
                vArc.x = abs(dy);
            } else {
                dy = -dy;
                pos = dy * norm + d2;
                vArc.x = abs(dy);
            }
            vLine2 = vec4(0.0, lineWidth * 2.0 + 10.0, 1.0  , 0.0); // forget about line2 with type=3
            vArc.y = dy;
            vArc.z = 0.0;
            vArc.w = lineWidth;
            vType = 3.0;
        } else if (abs(D) < 0.01 && collinear < 0.5) {
            pos = dy * norm;
        } else {
            if (inner > 0.5) {
                dy = -dy;
                inner = 0.0;
            }
            float side = sign(dy);
            vec2 norm3 = normalize(norm + norm2);

            if (type >= MITER && type < MITER + 3.5) {
                vec2 farVertex = doBisect(norm, len, norm2, len2, shift + dy, 0.0);
                if (length(farVertex) > abs(shift + dy) * MITER_LIMIT) {
                    type = BEVEL;
                }
            }

            if (vertexNum < 4.5) {
                pos = doBisect(norm, len, norm2, len2, shift - dy, 1.0);
            } else if (vertexNum < 5.5) {
                pos = (shift + dy) * norm;
            } else if (vertexNum > 7.5) {
                pos = (shift + dy) * norm2;
            } else {
                if (type >= ROUND && type < ROUND + 1.5) {
                    pos = doBisect(norm, len, norm2, len2, shift + dy, 0.0);
                    float d2 = abs(shift + dy);
                    if (length(pos) > abs(shift + dy) * 1.5) {
                        if (vertexNum < 6.5) {
                            pos.x = (shift + dy) * norm.x - d2 * norm.y;
                            pos.y = (shift + dy) * norm.y + d2 * norm.x;
                        } else {
                            pos.x = (shift + dy) * norm2.x + d2 * norm2.y;
                            pos.y = (shift + dy) * norm2.y - d2 * norm2.x;
                        }
                    }
                } else if (type >= MITER && type < MITER + 3.5) {
                    pos = doBisect(norm, len, norm2, len2, shift + dy, 0.0); //farVertex
                } else if (type >= BEVEL && type < BEVEL + 1.5) {
                    float d2 = side / resolution;
                    if (vertexNum < 6.5) {
                        pos = (shift + dy) * norm + d2 * norm3;
                    } else {
                        pos = (shift + dy) * norm2 + d2 * norm3;
                    }
                }
            }

            if (type >= ROUND && type < ROUND + 1.5) {
                vArc.x = side * dot(pos, norm3);
                vArc.y = pos.x * norm3.y - pos.y * norm3.x;
                vArc.z = dot(norm, norm3) * (lineWidth + side * shift);
                vArc.w = lineWidth + side * shift;
                vType = 3.0;
            } else if (type >= MITER && type < MITER + 3.5) {
                vType = 1.0;
            } else if (type >= BEVEL && type < BEVEL + 1.5) {
                vType = 4.0;
                vArc.z = dot(norm, norm3) * (lineWidth + side * shift) - side * dot(pos, norm3);
            }

            dy = side * (dot(pos, norm) - shift);
            dy2 = side * (dot(pos, norm2) - shift);
        }

        pos += base;
        vLine1.xy = vec2(dy, vLine1.y) * resolution;
        vLine2.xy = vec2(dy2, vLine2.y) * resolution;
        vArc = vArc * resolution;
        vTravel = vec2(aTravel * avgScale + dot(pos - pointA, vec2(-norm.y, norm.x)), avgScale);
    }

    gl_Position = vec4((projectionMatrix * vec3(pos, 1.0)).xy, 0.0, 1.0);

    vColor = aColor * tint;
}`;

const precision = `#version 100
#ifdef GL_FRAGMENT_PRECISION_HIGH
  precision highp float;
#else
  precision mediump float;
#endif
`;

const smoothFrag = `%PRECISION%
varying vec4 vColor;
varying vec4 vLine1;
varying vec4 vLine2;
varying vec4 vArc;
varying float vType;
varying float vTextureId;
varying vec2 vTextureCoord;
varying vec2 vTravel;
uniform sampler2D uSamplers[%MAX_TEXTURES%];

%PIXEL_LINE%

void main(void){
    %PIXEL_COVERAGE%

    vec4 texColor;
    float textureId = floor(vTextureId+0.5);
    %FOR_LOOP%

    gl_FragColor = vColor * texColor * alpha;
}
`;

const pixelLineFunc = [`
float pixelLine(float x, float A, float B) {
    return clamp(x + 0.5, 0.0, 1.0);
}
`, `
float pixelLine(float x, float A, float B) {
    float y = abs(x), s = sign(x);
    if (y * 2.0 < A - B) {
        return 0.5 + s * y / A;
    }
    y -= (A - B) * 0.5;
    y = max(1.0 - y / B, 0.0);
    return (1.0 + s * (1.0 - y * y)) * 0.5;
    //return clamp(x + 0.5, 0.0, 1.0);
}
`];

const pixelCoverage = `float alpha = 1.0;
if (vType < 0.5) {
    float left = pixelLine(-vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float right = pixelLine(vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float near = vLine2.x - 0.5;
    float far = min(vLine2.x + 0.5, 0.0);
    float top = vLine2.y - 0.5;
    float bottom = min(vLine2.y + 0.5, 0.0);
    alpha = (right - left) * max(bottom - top, 0.0) * max(far - near, 0.0);
} else if (vType < 1.5) {
    float a1 = pixelLine(- vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float a2 = pixelLine(vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float b1 = pixelLine(- vLine2.y - vLine2.x, vLine2.z, vLine2.w);
    float b2 = pixelLine(vLine2.y - vLine2.x, vLine2.z, vLine2.w);
    alpha = a2 * b2 - a1 * b1;
} else if (vType < 2.5) {
    alpha *= max(min(vLine1.x + 0.5, 1.0), 0.0);
    alpha *= max(min(vLine1.y + 0.5, 1.0), 0.0);
    alpha *= max(min(vLine1.z + 0.5, 1.0), 0.0);
} else if (vType < 3.5) {
    float a1 = pixelLine(- vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float a2 = pixelLine(vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float b1 = pixelLine(- vLine2.y - vLine2.x, vLine2.z, vLine2.w);
    float b2 = pixelLine(vLine2.y - vLine2.x, vLine2.z, vLine2.w);
    float alpha_miter = a2 * b2 - a1 * b1;
    float alpha_plane = clamp(vArc.z - vArc.x + 0.5, 0.0, 1.0);
    float d = length(vArc.xy);
    float circle_hor = max(min(vArc.w, d + 0.5) - max(-vArc.w, d - 0.5), 0.0);
    float circle_vert = min(vArc.w * 2.0, 1.0);
    float alpha_circle = circle_hor * circle_vert;
    alpha = min(alpha_miter, max(alpha_circle, alpha_plane));
} else {
    float a1 = pixelLine(- vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float a2 = pixelLine(vLine1.y - vLine1.x, vLine1.z, vLine1.w);
    float b1 = pixelLine(- vLine2.y - vLine2.x, vLine2.z, vLine2.w);
    float b2 = pixelLine(vLine2.y - vLine2.x, vLine2.z, vLine2.w);
    alpha = a2 * b2 - a1 * b1;
    alpha *= clamp(vArc.z + 0.5, 0.0, 1.0);
}
`;

class SmoothGraphicsShader extends core.Shader
{
    

    constructor(settings,
        vert = smoothVert,
        frag = smoothFrag,
        uniforms = {})
    {
        vert = SmoothGraphicsShader.generateVertexSrc(settings, vert);
        frag = SmoothGraphicsShader.generateFragmentSrc(settings, frag);

        const { maxStyles, maxTextures } = settings;
        const sampleValues = new Int32Array(maxTextures);

        for (let i = 0; i < maxTextures; i++)
        {
            sampleValues[i] = i;
        }
        super(core.Program.from(vert, frag), (Object ).assign(uniforms, {
            styleMatrix: new Float32Array(6 * maxStyles),
            styleTextureId: new Float32Array(maxStyles),
            styleLine: new Float32Array(2 * maxStyles),
            samplerSize: new Float32Array(2 * maxTextures),
            uSamplers: sampleValues,
            tint: new Float32Array([1, 1, 1, 1]),
            resolution: 1,
            expand: 1,
        }));
        this.settings = settings;
    }

    static generateVertexSrc(settings, vertexSrc = smoothVert)
    {
        const { maxStyles, maxTextures } = settings;

        vertexSrc = vertexSrc.replace(/%MAX_TEXTURES%/gi, `${maxTextures}`)
            .replace(/%MAX_STYLES%/gi, `${maxStyles}`);

        return vertexSrc;
    }

    static generateFragmentSrc(settings, fragmentSrc = smoothFrag)
    {
        const { maxTextures, pixelLine } = settings;

        fragmentSrc = fragmentSrc.replace(/%PRECISION%/gi, precision)
            .replace(/%PIXEL_LINE%/gi, pixelLineFunc[pixelLine])
            .replace(/%PIXEL_COVERAGE%/gi, pixelCoverage)
            .replace(/%MAX_TEXTURES%/gi, `${maxTextures}`)
            .replace(/%FOR_LOOP%/gi, this.generateSampleSrc(maxTextures));

        return fragmentSrc;
    }

    static generateSampleSrc(maxTextures)
    {
        let src = '';

        src += '\n';
        src += '\n';

        for (let i = 0; i < maxTextures; i++)
        {
            if (i > 0)
            {
                src += '\nelse ';
            }

            if (i < maxTextures - 1)
            {
                src += `if(textureId < ${i}.5)`;
            }

            src += '\n{';
            src += `\n\ttexColor = texture2D(uSamplers[${i}], vTextureCoord);`;
            src += '\n}';
        }

        src += '\n';
        src += '\n';

        return src;
    }
}

const settings = {
    LINE_SCALE_MODE: exports.LINE_SCALE_MODE.NORMAL,
    SHADER_MAX_STYLES: 24,
    SHADER_MAX_TEXTURES: 4,
    PIXEL_LINE: 0,
};

const UnsmoothGraphics = graphics.Graphics;
const { BezierUtils, QuadraticUtils, ArcUtils } = graphics.graphicsUtils;

const temp = new Float32Array(3);
// a default shaders map used by graphics..
const DEFAULT_SHADERS = {};



















class SmoothGraphics extends display.Container
{
     static get nextRoundedRectBehavior() {
        return (UnsmoothGraphics ).nextRoundedRectBehavior;
    }

     static set nextRoundedRectBehavior(value) {
        (UnsmoothGraphics ).nextRoundedRectBehavior = value;
    }

    static __initStatic() {this._TEMP_POINT = new math.Point();}

    
    
    
    

    
    
    
    

    
    
    
    
    
    

    
    

     get geometry()
    {
        return this._geometry;
    }

    constructor(geometry = null)
    {
        super();

        this._geometry = geometry || new SmoothGraphicsGeometry();
        this._geometry.refCount++;

        this.shader = null;

        this.shaderSettings = {
            maxStyles: settings.SHADER_MAX_STYLES,
            maxTextures: settings.SHADER_MAX_TEXTURES,
            pixelLine: settings.PIXEL_LINE,
        };

        this.state = core.State.for2d();

        this._fillStyle = new FillStyle();

        this._lineStyle = new LineStyle();

        this._matrix = null;

        this._holeMode = false;

        this.currentPath = null;

        this.batches = [];

        this.batchTint = -1;

        this.batchDirty = -1;

        this.vertexData = null;

        this.pluginName = 'smooth';

        this._transformID = -1;

        // Set default
        this.tint = 0xFFFFFF;
        this.blendMode = constants.BLEND_MODES.NORMAL;
    }

     clone()
    {
        this.finishPoly();

        return new SmoothGraphics(this._geometry);
    }

     set blendMode(value)
    {
        this.state.blendMode = value;
    }

     get blendMode()
    {
        return this.state.blendMode;
    }

     get tint()
    {
        return this._tint;
    }

     set tint(value)
    {
        this._tint = value;
    }

     get fill()
    {
        return this._fillStyle;
    }

     get line()
    {
        return this._lineStyle;
    }

    



     lineStyle(options = null,
        color = 0x0, alpha = 1, alignment = 0.5, scaleMode = settings.LINE_SCALE_MODE)
    {
        // Support non-object params: (width, color, alpha, alignment, native)
        if (typeof options === 'number')
        {
            if (typeof scaleMode === 'boolean')
            {
                scaleMode = scaleMode ? exports.LINE_SCALE_MODE.NONE : exports.LINE_SCALE_MODE.NORMAL;
            }
            options = { width: options, color, alpha, alignment, scaleMode } ;
        }
        else
        {
            const native = (options ).native;

            if (native !== undefined)
            {
                options.scaleMode = native ? exports.LINE_SCALE_MODE.NONE : exports.LINE_SCALE_MODE.NORMAL;
            }
        }

        return this.lineTextureStyle(options);
    }

     lineTextureStyle(options)
    {
        // Apply defaults
        options = Object.assign({
            width: 0,
            texture: core.Texture.WHITE,
            color: (options && options.texture) ? 0xFFFFFF : 0x0,
            alpha: 1,
            matrix: null,
            alignment: 0.5,
            native: false,
            cap: graphics.LINE_CAP.BUTT,
            join: graphics.LINE_JOIN.MITER,
            miterLimit: 10,
            shader: null,
            scaleMode: settings.LINE_SCALE_MODE,
        }, options);

        if (this.currentPath)
        {
            this.startPoly();
        }

        const visible = options.width > 0 && options.alpha > 0;

        if (!visible)
        {
            this._lineStyle.reset();
        }
        else
        {
            if (options.matrix)
            {
                options.matrix = options.matrix.clone();
                options.matrix.invert();
            }

            Object.assign(this._lineStyle, { visible }, options);
        }

        return this;
    }

     startPoly()
    {
        if (this.currentPath)
        {
            const points = this.currentPath.points;
            const len = this.currentPath.points.length;

            if (len > 2)
            {
                this.drawShape(this.currentPath);
                this.currentPath = new math.Polygon();
                this.currentPath.closeStroke = false;
                this.currentPath.points.push(points[len - 2], points[len - 1]);
            }
        }
        else
        {
            this.currentPath = new math.Polygon();
            this.currentPath.closeStroke = false;
        }
    }

    finishPoly()
    {
        if (this.currentPath)
        {
            if (this.currentPath.points.length > 2)
            {
                this.drawShape(this.currentPath);
                this.currentPath = null;
            }
            else
            {
                this.currentPath.points.length = 0;
            }
        }
    }

     moveTo(x, y)
    {
        this.startPoly();
        this.currentPath.points[0] = x;
        this.currentPath.points[1] = y;

        return this;
    }

     lineTo(x, y)
    {
        if (!this.currentPath)
        {
            this.moveTo(0, 0);
        }

        // remove duplicates..
        const points = this.currentPath.points;
        const fromX = points[points.length - 2];
        const fromY = points[points.length - 1];

        if (fromX !== x || fromY !== y)
        {
            points.push(x, y);
        }

        return this;
    }

     _initCurve(x = 0, y = 0)
    {
        if (this.currentPath)
        {
            if (this.currentPath.points.length === 0)
            {
                this.currentPath.points = [x, y];
            }
        }
        else
        {
            this.moveTo(x, y);
        }
    }

     quadraticCurveTo(cpX, cpY, toX, toY)
    {
        this._initCurve();

        const points = this.currentPath.points;

        if (points.length === 0)
        {
            this.moveTo(0, 0);
        }

        QuadraticUtils.curveTo(cpX, cpY, toX, toY, points);

        return this;
    }

     bezierCurveTo(cpX, cpY, cpX2, cpY2, toX, toY)
    {
        this._initCurve();

        BezierUtils.curveTo(cpX, cpY, cpX2, cpY2, toX, toY, this.currentPath.points);

        return this;
    }

     arcTo(x1, y1, x2, y2, radius)
    {
        this._initCurve(x1, y1);

        const points = this.currentPath.points;

        const result = ArcUtils.curveTo(x1, y1, x2, y2, radius, points);

        if (result)
        {
            const { cx, cy, radius, startAngle, endAngle, anticlockwise } = result;

            this.arc(cx, cy, radius, startAngle, endAngle, anticlockwise);
        }

        return this;
    }

     arc(cx, cy, radius, startAngle, endAngle, anticlockwise = false)
    {
        if (startAngle === endAngle)
        {
            return this;
        }

        if (!anticlockwise && endAngle <= startAngle)
        {
            endAngle += math.PI_2;
        }
        else if (anticlockwise && startAngle <= endAngle)
        {
            startAngle += math.PI_2;
        }

        const sweep = endAngle - startAngle;

        if (sweep === 0)
        {
            return this;
        }

        const startX = cx + (Math.cos(startAngle) * radius);
        const startY = cy + (Math.sin(startAngle) * radius);
        const eps = this._geometry.closePointEps;

        // If the currentPath exists, take its points. Otherwise call `moveTo` to start a path.
        let points = this.currentPath ? this.currentPath.points : null;

        if (points)
        {
            // TODO: make a better fix.

            // We check how far our start is from the last existing point
            const xDiff = Math.abs(points[points.length - 2] - startX);
            const yDiff = Math.abs(points[points.length - 1] - startY);

            if (xDiff < eps && yDiff < eps)
            ;
            else
            {
                points.push(startX, startY);
            }
        }
        else
        {
            this.moveTo(startX, startY);
            points = this.currentPath.points;
        }

        ArcUtils.arc(startX, startY, cx, cy, radius, startAngle, endAngle, anticlockwise, points);

        return this;
    }

     beginFill(color = 0, alpha = 1, smooth = false)
    {
        return this.beginTextureFill({ texture: core.Texture.WHITE, color, alpha, smooth });
    }

    beginTextureFill(options)
    {
        // Apply defaults
        options = Object.assign({
            texture: core.Texture.WHITE,
            color: 0xFFFFFF,
            alpha: 1,
            matrix: null,
            smooth: false,
        }, options) ;

        if (this.currentPath)
        {
            this.startPoly();
        }

        const visible = options.alpha > 0;

        if (!visible)
        {
            this._fillStyle.reset();
        }
        else
        {
            if (options.matrix)
            {
                options.matrix = options.matrix.clone();
                options.matrix.invert();
            }

            Object.assign(this._fillStyle, { visible }, options);
        }

        return this;
    }

     endFill()
    {
        this.finishPoly();

        this._fillStyle.reset();

        return this;
    }

     drawRect(x, y, width, height)
    {
        return this.drawShape(new math.Rectangle(x, y, width, height));
    }

     drawRoundedRect(x, y, width, height, radius)
    {
        return this.drawShape(new math.RoundedRectangle(x, y, width, height, radius));
    }

     drawCircle(x, y, radius)
    {
        return this.drawShape(new math.Circle(x, y, radius));
    }

     drawEllipse(x, y, width, height)
    {
        return this.drawShape(new math.Ellipse(x, y, width, height));
    }

    


     drawPolygon(...path)
    {
        let points;
        let closeStroke = true;// !!this._fillStyle;

        const poly = path[0] ;

        // check if data has points..
        if (poly.points)
        {
            closeStroke = poly.closeStroke;
            points = poly.points;
        }
        else if (Array.isArray(path[0]))
        {
            points = path[0];
        }
        else
        {
            points = path;
        }

        const shape = new math.Polygon(points);

        shape.closeStroke = closeStroke;

        this.drawShape(shape);

        return this;
    }

     drawShape(shape)
    {
        if (!this._holeMode)
        {
            this._geometry.drawShape(
                shape,
                this._fillStyle.clone(),
                this._lineStyle.clone(),
                this._matrix
            );
        }
        else
        {
            this._geometry.drawHole(shape, this._matrix);
        }

        return this;
    }

     clear()
    {
        this._geometry.clear();
        this._lineStyle.reset();
        this._fillStyle.reset();

        this._boundsID++;
        this._matrix = null;
        this._holeMode = false;
        this.currentPath = null;

        return this;
    }

     isFastRect()
    {
        const data = this._geometry.graphicsData;

        return data.length === 1
            && data[0].shape.type === math.SHAPES.RECT
            && !data[0].matrix
            && !data[0].holes.length
            && !(data[0].lineStyle.visible && data[0].lineStyle.width);
    }

     _renderCanvas(renderer)
    {
        (UnsmoothGraphics.prototype )._renderCanvas.call(this, renderer);
    }

     _render(renderer)
    {
        this.finishPoly();

        const geometry = this._geometry;
        const hasuint32 = renderer.context.supports.uint32Indices;
        // batch part..
        // batch it!

        geometry.checkInstancing(renderer.geometry.hasInstance, hasuint32);

        geometry.updateBatches(this.shaderSettings);

        if (geometry.batchable)
        {
            if (this.batchDirty !== geometry.batchDirty)
            {
                this._populateBatches();
            }

            this._renderBatched(renderer);
        }
        else
        {
            // no batching...
            renderer.batch.flush();

            this._renderDirect(renderer);
        }
    }

     _populateBatches()
    {
        const geometry = this._geometry;
        const blendMode = this.blendMode;
        const len = geometry.batches.length;

        this.batchTint = -1;
        this._transformID = -1;
        this.batchDirty = geometry.batchDirty;
        this.batches.length = len;

        this.vertexData = new Float32Array(geometry.points);

        for (let i = 0; i < len; i++)
        {
            const gI = geometry.batches[i];
            const color = gI.style.color;
            const vertexData = new Float32Array(this.vertexData.buffer,
                gI.attribStart * 4 * 2,
                gI.attribSize * 2);

            // const uvs = new Float32Array(geometry.uvsFloat32.buffer,
            //     gI.attribStart * 4 * 2,
            //     gI.attribSize * 2);

            // const indices = new Uint16Array(geometry.indicesUint16.buffer,
            //     gI.start * 2,
            //     gI.size);

            const batch = {
                vertexData,
                blendMode,
                // indices,
                // uvs,
                _batchRGB: utils.hex2rgb(color) ,
                _tintRGB: color,
                _texture: gI.style.texture,
                alpha: gI.style.alpha,
                worldAlpha: 1
            };

            this.batches[i] = batch;
        }
    }

     _renderBatched(renderer)
    {
        if (!this.batches.length)
        {
            return;
        }

        renderer.batch.setObjectRenderer(renderer.plugins[this.pluginName]);

        this.calculateVertices();
        this.calculateTints();

        for (let i = 0, l = this.batches.length; i < l; i++)
        {
            const batch = this.batches[i];

            batch.worldAlpha = this.worldAlpha * batch.alpha;

            renderer.plugins[this.pluginName].render(batch);
        }
    }

     _renderDirect(renderer)
    {
        const directShader = this._resolveDirectShader(renderer);
        let shader = directShader;

        const geometry = this._geometry;
        const tint = this.tint;
        const worldAlpha = this.worldAlpha;
        const uniforms = shader.uniforms;
        const drawCalls = geometry.drawCalls;

        // lets set the transfomr
        uniforms.translationMatrix = this.transform.worldTransform;

        // and then lets set the tint..
        uniforms.tint[0] = (((tint >> 16) & 0xFF) / 255) * worldAlpha;
        uniforms.tint[1] = (((tint >> 8) & 0xFF) / 255) * worldAlpha;
        uniforms.tint[2] = ((tint & 0xFF) / 255) * worldAlpha;
        uniforms.tint[3] = worldAlpha;

        uniforms.resolution = renderer.renderTexture.current
            ? renderer.renderTexture.current.resolution : renderer.resolution;

        const projTrans = renderer.projection.transform;

        if (projTrans)
        {
            // only uniform scale is supported!
            const scale = Math.sqrt(projTrans.a * projTrans.a + projTrans.b * projTrans.b);

            uniforms.resolution *= scale;
        }

        uniforms.expand = (renderer.options.antialias ? 2 : 1) / uniforms.resolution;

        // the first draw call, we can set the uniforms of the shader directly here.

        // this means that we can tack advantage of the sync function of pixi!
        // bind and sync uniforms..
        // there is a way to optimise this..
        renderer.shader.bind(shader);
        renderer.geometry.bind(geometry, shader);

        // set state..
        renderer.state.set(this.state);

        shader = null;
        // then render the rest of them...
        for (let i = 0, l = drawCalls.length; i < l; i++)
        {
            // TODO: refactor it to another class, that fills uniforms of this shader
            const drawCall = geometry.drawCalls[i];

            const shaderChange = shader !== drawCall.shader;

            if (shaderChange)
            {
                shader = drawCall.shader;
                if (shader)
                {
                    shader.uniforms.translationMatrix = this.transform.worldTransform;
                    if (shader.uniforms.tint)
                    {
                        shader.uniforms.tint[0] = uniforms.tint[0];
                        shader.uniforms.tint[1] = uniforms.tint[1];
                        shader.uniforms.tint[2] = uniforms.tint[2];
                        shader.uniforms.tint[3] = uniforms.tint[3];
                    }
                }
            }

            const { texArray, styleArray, size, start } = drawCall;
            const groupTextureCount = texArray.count;
            const shaderHere = shader || directShader;

            const texs = shaderHere.uniforms.styleTextureId;
            const mats = shaderHere.uniforms.styleMatrix;
            const lines = shaderHere.uniforms.styleLine;

            for (let i = 0; i < styleArray.count; i++)
            {
                texs[i] = styleArray.textureIds[i];
                lines[i * 2] = styleArray.lines[i * 2];
                lines[(i * 2) + 1] = styleArray.lines[(i * 2) + 1];
                const m = styleArray.matrices[i];

                mats[i * 6] = m.a;
                mats[(i * 6) + 1] = m.c;
                mats[(i * 6) + 2] = m.tx;
                mats[(i * 6) + 3] = m.b;
                mats[(i * 6) + 4] = m.d;
                mats[(i * 6) + 5] = m.ty;
            }
            const sizes = shaderHere.uniforms.samplerSize;

            for (let i = 0; i < groupTextureCount; i++)
            {
                sizes[i * 2] = texArray.elements[i].width;
                sizes[(i * 2) + 1] = texArray.elements[i].height;
            }

            renderer.shader.bind(shaderHere);
            if (shaderChange)
            {
                renderer.geometry.bind(geometry);
            }

            // TODO: bind styles!
            for (let j = 0; j < groupTextureCount; j++)
            {
                renderer.texture.bind(texArray.elements[j], j);
            }

            // bind the geometry...
            renderer.geometry.draw(constants.DRAW_MODES.TRIANGLES, size, start);
        }
    }

     _resolveDirectShader(_renderer)
    {
        let shader = this.shader;

        const pluginName = this.pluginName;

        if (!shader)
        {
            if (!DEFAULT_SHADERS[pluginName])
            {
                DEFAULT_SHADERS[pluginName] = new SmoothGraphicsShader(this.shaderSettings);
            }
            shader = DEFAULT_SHADERS[pluginName];
        }

        return shader;
    }

     _calculateBounds()
    {
        this.finishPoly();

        const geometry = this._geometry;

        // skipping when graphics is empty, like a container
        if (!geometry.graphicsData.length)
        {
            return;
        }

        const { minX, minY, maxX, maxY } = geometry.bounds;

        this._bounds.addFrame(this.transform, minX, minY, maxX, maxY);
    }

     containsPoint(point)
    {
        this.worldTransform.applyInverse(point, SmoothGraphics._TEMP_POINT);

        return this._geometry.containsPoint(SmoothGraphics._TEMP_POINT);
    }

     calculateTints()
    {
        if (this.batchTint !== this.tint)
        {
            this.batchTint = this.tint;

            const tintRGB = utils.hex2rgb(this.tint, temp);

            for (let i = 0; i < this.batches.length; i++)
            {
                const batch = this.batches[i];

                const batchTint = batch._batchRGB;

                const r = (tintRGB[0] * batchTint[0]) * 255;
                const g = (tintRGB[1] * batchTint[1]) * 255;
                const b = (tintRGB[2] * batchTint[2]) * 255;

                // TODO Ivan, can this be done in one go?
                const color = (r << 16) + (g << 8) + (b | 0);

                batch._tintRGB = (color >> 16)
                    + (color & 0xff00)
                    + ((color & 0xff) << 16);
            }
        }
    }

     calculateVertices()
    {
        const wtID = this.transform._worldID;

        if (this._transformID === wtID)
        {
            return;
        }

        this._transformID = wtID;

        const wt = this.transform.worldTransform;
        const a = wt.a;
        const b = wt.b;
        const c = wt.c;
        const d = wt.d;
        const tx = wt.tx;
        const ty = wt.ty;

        const data = this._geometry.points;// batch.vertexDataOriginal;
        const vertexData = this.vertexData;

        let count = 0;

        for (let i = 0; i < data.length; i += 2)
        {
            const x = data[i];
            const y = data[i + 1];

            vertexData[count++] = (a * x) + (c * y) + tx;
            vertexData[count++] = (d * y) + (b * x) + ty;
        }
    }

     closePath()
    {
        const currentPath = this.currentPath;

        if (currentPath)
        {
            // we don't need to add extra point in the end because buildLine will take care of that
            currentPath.closeStroke = true;
        }

        return this;
    }

     setMatrix(matrix)
    {
        this._matrix = matrix;

        return this;
    }

     beginHole()
    {
        this.finishPoly();
        this._holeMode = true;

        return this;
    }

     endHole()
    {
        this.finishPoly();
        this._holeMode = false;

        return this;
    }

     destroy(options)
    {
        this._geometry.refCount--;
        if (this._geometry.refCount === 0)
        {
            this._geometry.dispose();
        }

        this._matrix = null;
        this.currentPath = null;
        this._lineStyle.destroy();
        this._lineStyle = null;
        this._fillStyle.destroy();
        this._fillStyle = null;
        this._geometry = null;
        this.shader = null;
        this.vertexData = null;
        this.batches.length = 0;
        this.batches = null;

        super.destroy(options);
    }
} SmoothGraphics.__initStatic();

const dashFrag = `%PRECISION%
varying vec4 vColor;
varying vec4 vLine1;
varying vec4 vLine2;
varying vec4 vArc;
varying float vType;
varying float vTextureId;
varying vec2 vTextureCoord;
varying vec2 vTravel;
uniform sampler2D uSamplers[%MAX_TEXTURES%];
uniform float dash;
uniform float gap;

%PIXEL_LINE%

void main(void){
    %PIXEL_COVERAGE%

    float d = dash * vTravel.y;
    if (d > 0.0) {
        float g = gap * vTravel.y;
        if (g > 0.0) {
            float t = mod(vTravel.x, d + g);
            alpha *= mix(
                min(0.5 * d + 0.5 - abs(t - 0.5 * d), 1.0),
                max(abs(t - 0.5 * g - d) - 0.5 * g + 0.5, 0.0),
                step(d, t)
            );
        }
    } else {
        alpha = 0.0;
    }

    vec4 texColor;
    float textureId = floor(vTextureId+0.5);
    %FOR_LOOP%

    gl_FragColor = vColor * texColor * alpha;
}
`;






class DashLineShader extends SmoothGraphicsShader
{
    constructor(dashParams)
    {
        const settings = { maxStyles: 16, maxTextures: 1, pixelLine: 1 };

        super(settings, undefined, dashFrag,
            dashParams || {
                dash: 8.0,
                gap: 5.0
            });
    }
}

exports.BATCH_POOL = BATCH_POOL;
exports.BatchDrawCall = BatchDrawCall;
exports.BatchPart = BatchPart;
exports.BatchStyleArray = BatchStyleArray;
exports.BuildData = BuildData;
exports.CircleBuilder = CircleBuilder;
exports.DRAW_CALL_POOL = DRAW_CALL_POOL;
exports.DashLineShader = DashLineShader;
exports.FILL_COMMANDS = FILL_COMMANDS;
exports.FillStyle = FillStyle;
exports.LineStyle = LineStyle;
exports.PolyBuilder = PolyBuilder;
exports.RectangleBuilder = RectangleBuilder;
exports.RoundedRectangleBuilder = RoundedRectangleBuilder;
exports.SegmentPacker = SegmentPacker;
exports.SmoothGraphics = SmoothGraphics;
exports.SmoothGraphicsData = SmoothGraphicsData;
exports.SmoothGraphicsGeometry = SmoothGraphicsGeometry;
exports.SmoothGraphicsShader = SmoothGraphicsShader;
exports.matrixEquals = matrixEquals;
exports.settings = settings;
//# sourceMappingURL=pixi-graphics-smooth.js.map
