import cookie from"cookie";import{randomString,testPassword,getSalt}from"./core/auth.mjs";import{USER_ROLES}from"../common/constants.mjs";class ClientSessions{constructor(){this.sessions=new Map}static COOKIE_MAX_AGE=864e5;assign(s,e){s.cookie("session",e.id,{maxAge:this.constructor.COOKIE_MAX_AGE,sameSite:"strict"})}expire(s,e){const t=this.get(s,e);global.logger.info(`Expiring client session ${t.id}`),this.sessions.delete(t.id),e.clearCookie("session")}get(s,e){const t=s.headers.cookie?cookie.parse(s.headers.cookie):null;if(!t||!t.session)return null;const i=this.sessions.get(t.session);if(!i)return null;return Date.now()>i.expires?(this.expire(s,e),null):i}getOrCreate(s,e){if(s.session)return s.session;let t=this.get(s,e);return t||(t=this._create(),this.assign(e,t),global.logger.info(`Created client session ${t.id}`)),s.session=t}_create({world:s=null,user:e=null,admin:t=!1}={}){const i=randomString(24),o=new Date,r=o.setDate(o.getDate()+1),n={};s&&e&&(n[s]=e);const a={id:i,admin:t,expires:r,worlds:n,messages:[]};this.sessions.set(i,a);for(let s of global.startupMessages)["error","warn"].includes(s.level)&&a.messages.push({type:s.level,message:s.message,options:{permanent:!0}});return a}async authenticateUser(s,e){const{game:t}=global;if(!t.ready||!t.world)throw new Error("You cannot log until a game World is ready for play.");const i=this.getOrCreate(s,e),{userid:o,password:r}=s.body,n=await db.User.get(o);if(null===n)return e.status(401),e.send("JOIN.ErrorUserDoesNotExist"),{request:"join",status:"failed"};let a;try{a=testPassword(r,n.password,n.passwordSalt)}catch(s){a=!1}return a?n.role===USER_ROLES.NONE?(e.status(401),e.send("JOIN.ErrorBanned"),{request:"join",status:"failed"}):(i.worlds[t.world.id]=n.id,logger.info(`User authentication successful for user ${n.name}`,{session:i.id,ip:s.ip}),{request:"join",status:"success",message:"JOIN.LoginSuccess",redirect:s.baseUrl+"/game"}):(logger.warn(`User authentication failed for user ${n.name}; invalid password`,{status:401,session:i.id,ip:s.ip}),e.status(401),e.send("JOIN.ErrorInvalidPassword"),{request:"join",status:"failed"})}authenticateAdmin(s,e){const{logger:t}=config,i=this.getOrCreate(s,e),o=config.adminPassword;if(i.admin||!o)return{success:!0,session:i};let r=!1;return s.body?.hasOwnProperty("adminPassword")&&(r=testPassword(s.body.adminPassword,o,getSalt(config.passwordSalt)),r?(t.info(`Administrator authentication successful for session ${i.id}`),i.messages.push({type:"info",message:"Admin authentication successful"})):(e.status(403),t.warn(`Administrator authentication failed for session ${i.id}; invalid password`,{status:403,ip:s.ip}),i.messages.push({type:"error",message:"ERROR.InvalidAdminKey",options:{permanent:!0}}))),i.admin=r,{success:r,session:i}}getMessages(s){if(!s.session)return null;const e=s.session.messages;return s.session.messages=[],e.length?JSON.stringify(e):null}setMessage(s,e,t,i){const o=this.get(s,e);o&&o.messages.push({type:t,message:i})}logoutAdmin(s,e){const t=this.get(s,e);t&&(t.admin=!1,global.logger.info(`Revoked admin access for session ${t.id}`))}logoutWorld(s,e){const{game:t,logger:i}=globalThis;if(!t.active)return;const o=this.get(s,e);if(!o)return;const r=o.worlds[t.world.id];if(delete o.worlds[t.world.id],r){t.activity.deactivateUser(r)&&i.info(`Logged user ${r} out of active World`)}}deactivateUserSession(s){for(let e of this.getUserSessions(s))global.logger.info(`Deactivating session ${e.id} for User ${s}`),this.sessions.delete(e.id)}getUserSessions(s){const e=[];for(let t of this.sessions.values())t.worlds[game.world.id]===s&&e.push(t);return e}}export default new ClientSessions;