import{isNewerVersion}from"../../common/utils/helpers.mjs";import{PACKAGE_AVAILABILITY_CODES}from"../../common/constants.mjs";import{World,System,Module,PACKAGE_TYPE_MAPPING}from"./_module.mjs";import path from"path";export async function getPackages({type:e="system"}={}){const r=PACKAGE_TYPE_MAPPING[e];if(!r)throw new Error(`Invalid package type ${e} requested`);const{packages:t,owned:a}=await r.getRepositoryPackages();return{packages:Array.from(t.values()).map((e=>e.vend())),owned:a}}export async function getPackageFromRemoteManifest({type:e="module",manifest:r=""}={}){const t=PACKAGE_TYPE_MAPPING[e];return await t.fromRemoteManifest(r)}export async function checkPackage({type:e,id:r,manifest:t}={}){const a=PACKAGE_TYPE_MAPPING[e];if(!a)throw new Error(`Invalid package type ${e} requested`);const o=a.get(r,{strict:!t});if(!t){if(!o.manifest)throw new Error(`The ${e} ${r} has no manifest URL provided`);t=o.manifest}const n=await a.check(t,o),i=n.remote;let s;if(o&&(s=await a.fromRepository(r),!s||i&&!isNewerVersion(s.version,i.version)||(n.trackChange=o.suggestTrackChange(s))),n.trackChange||!i)return n;if(n.isUpgrade||n.isDowngrade)return n;if(o&&!o.protected){o.sidegrade(i,s)&&(n.hasSidegraded=!0)}return n}export async function installPackage({type:e,id:r,manifest:t}){const{logger:a,express:o}=config,n=PACKAGE_TYPE_MAPPING[e];if(!n)throw new Error(`Invalid package type ${e} requested`);if(!t)throw new Error("A manifest URL must be provided");const i=await checkPackage({type:e,id:r,manifest:t}),s=i.remote;if(!s){let r=[`Unable to load valid ${e} manifest data from "${t}"`,i.error].filterJoin("\n");throw new Error(r)}if(r=s.id,i.isDowngrade)throw new Error(`You are currently using a more recent version of ${e} ${s.title} and may not downgrade to an older version`);const c=s.availability,l=PACKAGE_AVAILABILITY_CODES;if(c===l.REQUIRES_CORE_DOWNGRADE)throw new Error(`${e} ${r} version ${s.version} requires an older version of the Foundry Virtual Tabletop software: ${s.compatibility.maximum} or older`);if([l.REQUIRES_CORE_UPGRADE_STABLE,l.REQUIRES_CORE_UPGRADE_UNSTABLE].includes(c))throw new Error(`${e} ${r} version ${s.version} requires a more modern version of the Foundry Virtual Tabletop software: ${s.compatibility.minimum} or newer`);let d,m=s.download;if(s.protected){if(d=await n.getProtectedDownloadURL({type:e,id:r,version:s.version}),"error"===d.status)throw new Error(d.message);m=d.download}if(!m)throw new Error(`The ${s.title} ${e} does not provide a download URL that can be installed`);const p={};!1==!i.compatibility?p.warning=`${s.title} version ${s.version} may not be compatible with Foundry VTT versions newer than ${s.compatibility.verified}`:null===i.compatibility&&(p.warning=`${s.title} version ${s.version} does not specify compatibility and may not work with Foundry VTT version ${config.release.version}`);const g=(t,n,i={})=>{let s;switch(t){case"Downloading":s="Downloading Package";break;case"Installing":s="Installing package";break;case"Cleanup":s="Cleaning Up Artifacts";break;case"Complete":s="Installation Complete";break;case"Package":s="Vending Package";break;case"Error":s=i.error}a.info(`${s} - ${n}%`),o.io.emit("progress",{action:"installPackage",type:e,id:r,pct:n,step:t,...i})};return new Promise((async(e,t)=>{try{const a=await n.install(r,m,d,{onFetched:()=>e(p),onProgress:g,onError:(e,r)=>{if("Downloading"===e)return t(r);const a={error:r.message,stack:r.stack};g("Error",100,a)}});if(!a)return g("Error",100,{error:"PACKAGE.InstallFailed",packageWarnings:{[r]:packages.warnings.toJSON()[r]}});const o={pkg:a.vend()};g("Package",100,o)}catch(e){t(e)}}))}export async function resetPackages(){return Module.resetPackages(),System.resetPackages(),World.resetPackages(),{message:"Reset package cache for all package types"}}export async function uninstallPackage({type:e,id:r}){const t=PACKAGE_TYPE_MAPPING[e];if(!t)throw new Error(`Invalid package type ${e} requested`);const a=t.uninstall(r);return a.uninstalled=!0,a}export async function lockPackage({type:e,id:r,shouldLock:t}){const a=PACKAGE_TYPE_MAPPING[e];if(!a)throw new Error(`Invalid package type ${e} requested`);return a.get(r,{strict:!0}).lock(t),{message:`Locked package ${r}`}}export async function migratePackageManifest({type:e,id:r,v9Compatible:t}){const a=PACKAGE_TYPE_MAPPING[e];if(!a)throw new Error(`Invalid package type ${e} requested`);const o=a.get(r,{strict:!0});let n={};return t&&(n.name=o.id,o.compatibility.minimum&&(n.minimumCoreVersion=o.compatibility.minimum)),o.save(n),{message:`Wrote package ${r} migration`,path:path.join(o.path,o.constructor.manifestFile)}}