import crypto from"crypto";import fs from"fs";import path from"path";import{PACKAGE_AVAILABILITY_CODES,TIMEOUTS}from"../../common/constants.mjs";import{isNewerVersion,isEmpty,fetchJsonWithTimeout,mergeObject}from"../../common/utils/module.mjs";import*as fields from"../../common/data/fields.mjs";import{cleanHTML,stripTags}from"../database/validators.mjs";import{handleCustomSocket}from"../server/sockets.mjs";import Files from"../files/files.mjs";import PackageInstaller from"./installer.mjs";import FileDownloader from"../files/downloader.mjs";class PackageAssetField extends fields.StringField{constructor(e={}){super(e)}static get _defaults(){return mergeObject(super._defaults,{required:!0,blank:!1,mustExist:!0,allowHTTP:!0,relativeToPackage:!0,allowedPublicDir:null})}_cast(e){return this.allowHTTP&&URL.parseSafe(e)?e:Files.standardizePath(e)}initialize(e,t,i={}){if(!t.installed||!e)return e;if(this.allowHTTP&&URL.parseSafe(e))return e;const s=t._source.id,a=global.paths,r=this.relativeToPackage?path.join(t.constructor.collection,s):"",o=[{root:a.data,directory:r}];this.allowedPublicDir&&o.push({root:a.public,directory:this.allowedPublicDir});const n=Files.resolveClientPaths(e,o,{allowHTTP:this.allowHTTP});if(!n.some((({exists:e})=>e))&&this.mustExist)throw new Error(`The file "${e}" included by ${t.constructor.type} ${s} does not exist`);return n.find((({exists:e})=>e))?.clientPath??n[0]?.clientPath}}class PackageCompendiumPacks extends fields.SetField{initialize(e,t,i={}){const s=new Set,a=t._source.id;for(let r of e)try{const e=this.element.initialize(r,t,i);e.packageType=t.constructor.type,e.packageName=a,e.id=`${"world"===t.constructor.type?"world":a}.${e.name}`,e.absPath=path.join(global.paths.data,e.path),s.add(e)}catch(e){logger.warn(e.message)}return s}}const ServerPackageMixin=e=>{const t=class extends e{constructor(e={},i={}){super(e,i),this.availability=this._testAvailability(),this.locked=t.#e(this.path,this.id)}static name="ServerPackageMixin";static defineSchema(){const e=super.defineSchema();e.scripts.element=new PackageAssetField({allowedPublicDir:"scripts"}),e.esmodules.element=new PackageAssetField({allowedPublicDir:"scripts"}),e.styles.element=new PackageAssetField,e.languages.element.fields.path=new PackageAssetField;const t=e.packs.element;return t.fields.path=new PackageAssetField({allowHTTP:!1,mustExist:!1}),e.packs=new PackageCompendiumPacks(t),e}static manifestMetadataFields=["title","author","authors","url","license","readme","bugs","changelog","manifest","download","compatibility"];installed=this.installed;get path(){return path.join(this.constructor.baseDir,this.id)}get incompatibleWithCoreVersion(){const e=PACKAGE_AVAILABILITY_CODES;return[e.REQUIRES_CORE_DOWNGRADE,e.REQUIRES_CORE_UPGRADE_UNSTABLE,e.REQUIRES_CORE_UPGRADE_STABLE].includes(this.availability)}static get baseDir(){return path.join(global.paths.data,this.collection)}static get manifestFile(){return`${this.type}.json`}static cleanData(e={},t={}){const i=super.cleanData(e,t);return"title"in i&&(i.title=stripTags(i.title)),"description"in i&&(i.description=cleanHTML(i.description)),i}_configure({installed:e=!0,...t}={}){this.installed=e,super._configure(t)}static#e(e,t){const i=path.join(e,`${t}.lock`);return fs.existsSync(i)}_testAvailability(){const e=globalThis.release,t=PACKAGE_AVAILABILITY_CODES,{minimum:i,maximum:s,verified:a}=this.compatibility;function r(e){return Number.isInteger(Number(e))}if(i&&isNewerVersion(i,e.version)){return Number(i.split(".").shift())<=e.maxStableGeneration?t.REQUIRES_CORE_UPGRADE_STABLE:t.REQUIRES_CORE_UPGRADE_UNSTABLE}if(s){if(!(r(s)?e.generation<=Number(s):!isNewerVersion(e.version,s)))return t.REQUIRES_CORE_DOWNGRADE}if(a){return(r(a)?Number(a)>=e.generation:!isNewerVersion(e.version,a))?t.AVAILABLE:t.REQUIRES_UPDATE}return t.UNKNOWN}vend(){const e=super.toObject(!1);return e.availability=this.availability,e.unavailable=this.unavailable,e.locked=this.locked,e.exclusive=this.exclusive,e.owned=this.owned,e.tags=this.tags,e}static packages;static get(e,{strict:t=!1}={}){this.packages||this.getPackages();const i=this.packages.find((t=>t.id===e));if(!i){if(t)throw new Error(`The requested ${this.type} ${e} does not exist!`);return null}if(i.unavailable&&t)throw new Error(`The requested package ${e} is not available for use! Make sure your core software and game system are fully updated.`);return i}static getPackages({enforceCompatibility:e=!1}={}){if(this.packages)return this.packages;const t=config.files.storages.data.getDirectories(this.baseDir).reduce(((e,t)=>{const i=path.join(t,this.manifestFile);return fs.existsSync(i)&&e.push(i),e}),[]);return this.packages=t.reduce(((t,i)=>{const s=this.fromManifestPath(i);return s?(e&&s.incompatibleWithCoreVersion||t.push(s),t):t}),[])}static fromManifestPath(e){const i=config.logger;let s;try{const t=this.loadLocalManifest(e);e=t.manifestPath,s=t.manifestData}catch(t){const s=`Error loading package "${e}": ${t.message}`;return packages.warnings.add(e,"error",s),i.error(new Error(s)),null}const a=path.basename(path.dirname(e));if(s.id!==a){const e=`Invalid ${this.type} "${s.id}" detected in directory "${a}"`;return packages.warnings.add(s.id,"error",e),i.error(e),null}if(s.protected){const a=path.join(path.dirname(e),"signature.json");if(!t.#t(a,s.version)){const e=`Invalid signature for protected ${this.type} "${s.id}"`;return packages.warnings.add(s.id,"error",e),i.error(e),null}}try{return new this(s)}catch(e){e.message=`Metadata validation failed for ${this.type} "${s.id}": ${e.message}`,packages.warnings.add(s.id,"error",e.message),i.error(e)}return null}static loadLocalManifest(e){const t=JSON.parse(fs.readFileSync(e,"utf-8"));return t.id||(t.id=t.name),{manifestPath:e,manifestData:t}}static async fromRemoteManifest(e,{strict:t=!0}={}){let i;try{const t={timeoutMs:TIMEOUTS.PACKAGE_REPOSITORY};i=await fetchJsonWithTimeout(e,{referrerPolicy:"no-referrer"},t)}catch(t){throw new Error(`The requested manifest at "${e}" did not provide ${this.type} manifest data.`)}return new this(i,{installed:!1,strict:t})}static async fromRepository(e){const{packages:t}=await this.getRepositoryPackages();return t.get(e)||null}static fromRepositoryData(e,t){return new this(this._convertRepositoryDataToPackageData(e,t),{installed:!1})}static _convertRepositoryDataToPackageData(e,t){return{id:e.name,title:e.title,version:e.version.version,description:e.description,authors:[{name:e.author}],url:e.url,manifest:e.version.manifest,protected:e.is_protected,compatibility:{minimum:e.version.required_core_version,verified:e.version.compatible_core_version,maximum:e.version.maximum_core_version},relationships:{requires:e.requires.map((e=>({id:e,type:"system"})))},tags:e.tags??[],exclusive:e.is_exclusive,owned:e.is_protected&&t.includes(e.id)}}static async install(e,i,s,{onError:a,onProgress:r,onFetched:o}={}){const n=await t.#i(e,i,{onError:a,onProgress:r,onFetched:o}),c=await t.#s(e,n,s,{onError:a,onProgress:r});return globalThis.packages.warnings.delete(e),this._addInstalledPackageToCache(e,c),this.get(c.id)}static async#i(e,t,{onError:i,onProgress:s,onFetched:a}={}){const r=path.join(this.baseDir,`${e}.zip`),o=new FileDownloader(t,r);return i&&o.on("error",(e=>i("Downloading",e))),s&&o.on("progress",(e=>s("Downloading",e))),a&&o.on("fetched",a),await o.download(),r}static async#s(e,t,i,{onError:s,onProgress:a}={}){const r=new PackageInstaller(this.type,this.baseDir,e,t,i);s&&r.on("error",(e=>s("Installing",e))),a&&r.on("progress",a);const o=await r.install();return globalThis.logger.info(`${vtt} | Installed ${this.type} ${e}`),o}static _addInstalledPackageToCache(e,t){if(!this.packages)return;const i=this.get(e);if(i)i.updateSource(t),i.availability=i._testAvailability();else{const t=path.join(this.baseDir,e,this.manifestFile),i=this.fromManifestPath(t);i&&this.packages.push(i)}}static async check(e,t){let i,s={remote:null,isUpgrade:!1,isDowngrade:!1,availability:PACKAGE_AVAILABILITY_CODES.UNKNOWN};try{i=await this.fromRemoteManifest(e),s.remote=i}catch(e){return globalThis.logger.warn(e.message),s.error=e.message,s}return s.isUpgrade=!t||isNewerVersion(i.version,t.version),s.isDowngrade=!!t&&isNewerVersion(t.version,i.version),s.availability=i.availability,s}suggestTrackChange(e){return e&&e.manifest&&e.version?e.manifest===this.manifest?null:isNewerVersion(e.version,this.version)?{manifest:e.manifest,version:e.version}:null:null}sidegrade(e,t){let i={};const s=(e,t,i)=>{const s=(e,t,i,s)=>{e[t]||(e[t]=s),isNewerVersion(i.minimum,s.minimum)&&(e[t].minimum=s.minimum),isNewerVersion(s.verified,i.verified)&&(e[t].verified=s.verified),isNewerVersion(s.maximum,i.maximum)&&(e[t].maximum=s.maximum)};for(const a of t){const t=e[a],r=this._source[a];switch(a){case"authors":t.map((e=>e.name)).equals(r.map((e=>e.name)))||(i[a]=t);break;case"minimumCoreVersion":isNewerVersion(r,t)&&(i[a]=t);break;case"compatibleCoreVersion":isNewerVersion(t,r)&&(i[a]=t);break;case"compatibility":case"systemCompatibility":s(i,a,r,t);break;default:r!==t&&(i[a]=t)}}};if(s(e.toObject(),this.constructor.manifestMetadataFields,i),t){const e=["compatibility"];s(t.toObject(),e,i)}const a=this.updateSource(i);return isEmpty(a)?null:(this.save(),globalThis.logger.info(`${vtt} | Applied sidegrade metadata updates to ${this.type} ${this.id}`),a)}static async uninstall(e){const t=this.get(e);if(!t)throw new Error(`The package ${e} does not exist to uninstall!`);return await Files.rmdir(t.path),this.packages&&this.packages.findSplice((t=>t.id===e)),globalThis.logger.info(`${vtt} | Uninstalled ${this.type} ${e}`),globalThis.packages.warnings.delete(e),t.toObject()}static resetPackages(){this.packages=null}async lock(e){const t=path.join(this.path,`${this.id}.lock`);fs.existsSync(t)?(e||fs.unlinkSync(t),globalThis.logger.info(`${vtt} | Unlocked ${this.type} ${this.id}`)):(e&&fs.writeFileSync(t,"🔒"),globalThis.logger.info(`${vtt} | Locked ${this.type} ${this.id}`)),this.locked=e}save(e={}){const t=foundry.utils.mergeObject(this.toObject(),e),i=this.constructor.cleanData(),s=foundry.utils.diffObject(i,t),a=path.join(this.path,this.constructor.manifestFile);return Files.writeFileSyncSafe(a,JSON.stringify(s,null,2)),this}registerCustomSocket(e){if(!this.socket)return;const t=`${this.constructor.type}.${this.id}`;e.on(t,handleCustomSocket.bind(e,t))}static#a="https://foundryvtt.com/_api/packages/get";static#r="https://foundryvtt.com/_api/packages/auth";static#o=3e5;static#n={packages:new Map,owned:[],lastUpdated:0,request:void 0};static async getRepositoryPackages(){const e=t.#n;if(e.request)return await e.request,e;return Date.now()-e.lastUpdated>=t.#o?(e.packages.clear(),e.owned=[],e.request=new Promise((async i=>{const s=fetchJsonWithTimeout(t.#a,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({type:this.type,version:config.release.version,license:config.license.data})},{timeoutMs:TIMEOUTS.FOUNDRY_WEBSITE});let a,r;try{a=await s,(a.error||"error"===a.status)&&(r=a.error.message)}catch(e){r=`Could not get Repository Packages - ${e}`}if(r)return logger.error(r),e.packages=new Map,e.owned=[],i();const{packages:o,owned:n}=a;for(const t of o){const i=this.fromRepositoryData(t,n);e.packages.set(i.id,i),i.owned&&e.owned.push(i.id)}return e.lastUpdated=Date.now(),i()})),await e.request,e.request=void 0,e):e}static async getProtectedDownloadURL({type:e,id:i,version:s}={}){return await fetchJsonWithTimeout(t.#r,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({type:e,name:i,version:s,license:config.license.data})})}static#t(e,t){if(!fs.existsSync(e))return!1;const i=JSON.parse(fs.readFileSync(e,"utf-8")),s=global.config.license,a="package"in i?{license:s.data.license,key:i.key,package:i.package,version:t}:{license:s.data.license,key:i.key,version:t},r=crypto.createVerify("SHA256");r.write(JSON.stringify(a));const o=crypto.createPublicKey(s.constructor.PUBLIC_KEY);return r.verify(o,i.signature,"base64")}};return t};export default ServerPackageMixin;export{PackageAssetField,ServerPackageMixin};