import fs from"fs";import mkdirp from"mkdirp";import path from"path";import rimraf from"rimraf";import yauzl from"yauzl";import LocalFileStorage from"./local.mjs";import S3FileStorage from"./s3.mjs";import{HTML_FILE_EXTENSIONS,MEDIA_MIME_TYPES,UPLOADABLE_FILE_EXTENSIONS}from"../../common/constants.mjs";import{getProperty,mergeObject,parseS3URL}from"../../common/utils/helpers.mjs";export default class Files{constructor(t){this.storages={public:new LocalFileStorage("public",paths.public),data:new LocalFileStorage("data",paths.data),s3:S3FileStorage.fromConfig("s3",t.awsConfig)},this.configuration=this._loadConfig()}static STORAGE_CONFIGURATION_FILENAME="storage.json";_loadConfig(){const t=path.join(paths.config,Files.STORAGE_CONFIGURATION_FILENAME);return fs.existsSync(t)?JSON.parse(fs.readFileSync(t,"utf8")):{}}get clientConfig(){const t=this.storages.s3;return{storages:this.availableStorageNames,s3:t?{endpoint:t.client.endpoint,buckets:t.buckets}:null}}get availableStorageNames(){return Object.entries(this.storages).reduce(((t,e)=>(e[1]&&t.push(e[0]),t)),[])}static async copyDirectory(t,e,{onProgress:r=null,ignore:s=[],_root:a=!0}={}){a&&(s=s.map((e=>path.join(t,e)))),this.mkdir(e);const o=fs.readdirSync(t);for(let a of o){let o=path.join(t,a),i=path.join(e,a);s.includes(o)||(fs.lstatSync(o).isDirectory()?await this.copyDirectory(o,i,{onProgress:r,ignore:s,_root:!1}):(await fs.promises.copyFile(o,i),r instanceof Function&&r(o,i)))}}static async processArchive(t,e,r=null){const s=process;return new Promise(((a,o)=>{s.noAsar=!0,yauzl.open(t,{lazyEntries:!0},((t,i)=>{t&&o(t);const n=i.entryCount;let c=0;i.on("entry",(async t=>{c++;let s=Math.round(100*c/n);await e(i,t,c,n,o),r&&await r(t.fileName,c,n,s),i.readEntry()})).once("error",o).once("close",(()=>{s.noAsar=!1,a(n)})),i.readEntry()}))}))}static async extractArchive(t,e,{onProgress:r=null,removeRoot:s}={}){return this.processArchive(t,(async(t,r,a,o,i)=>{let n=r.fileName;s&&(n=n.replace(s,"")),""===n||n.endsWith("/")||await this._extractEntry(t,e,r,n,i)}),r)}static async summarizeArchive(t,{manifestPath:e=null}={}){const r={contents:[],manifest:null};return await this.processArchive(t,(async(t,s,a,o,i)=>{let n=s.fileName;r.contents.push(n),n===e&&(r.manifest=await this._readEntry(t,s,i))})),r}static _readEntry(t,e,r){return new Promise((s=>{t.openReadStream(e,((t,e)=>{t&&r(t);let a="";e.on("data",(t=>a+=t.toString())),e.on("end",(()=>s(a)))}))}))}static _extractEntry(t,e,r,s,a){let o=path.join(e,s);return Files.mkdir(path.dirname(o)),new Promise((e=>{const s=fs.createWriteStream(o).on("finish",e).on("error",a);t.openReadStream(r,((t,e)=>{t&&a(t),e.pipe(s)}))}))}static resolveClientPaths(t,e){return e.map((e=>{const r=path.join(e.root,e.directory),s=path.join(r,t),a=fs.existsSync(s);return this.isPathContained(s,r)?{exists:a,clientPath:LocalFileStorage.toClientPath(s,e.root)}:{exists:!1,clientPath:null}}))}static standardizePath(t){return path.normalize(t).split(path.sep).join(path.posix.sep)}static isPathContained(t,e){const r=path.relative(e,t);return!(r&&(r.startsWith("..")||path.isAbsolute(r)))}static mkdir(t){return fs.existsSync(t)||mkdirp.sync(t),t}static async rmdir(t){return new Promise(((e,r)=>{try{rimraf(t,e)}catch(t){r(t)}}))}static writeFileSyncSafe(t,e,r={}){const s=`${t}~`,a=fs.openSync(s,"w");fs.writeFileSync(a,e,r),fs.fsyncSync(a),fs.closeSync(a),fs.renameSync(s,t);const o=fs.openSync(t,"r+");return fs.fsyncSync(o),fs.closeSync(o),o}static copyLargeFile(t,e,{encoding:r="utf8",mode:s=420}={}){return new Promise(((a,o)=>{const i=fs.createReadStream(t,{encoding:r}),n=fs.createWriteStream(e,{encoding:r,mode:s});i.on("error",o),n.on("error",o),n.on("finish",a),i.pipe(n)}))}static loadTemplate(t){const e=t.startsWith("templates")?paths.root:paths.data;if(t=path.join(e,t),!this.isPathContained(t,e))throw new Error("You are not allowed to load template files outside of the application or user data locations");if(!HTML_FILE_EXTENSIONS.includes(path.extname(t).slice(1)))throw new Error(`You are only allowed to load template files with an extension in [${HTML_FILE_EXTENSIONS}]`);try{return{html:fs.readFileSync(t,{encoding:"utf8"}),success:!0}}catch(t){return{html:"",success:!1,error:t.message}}}static parseWildcardPath(t){let e="data";const r={wildcard:!0};if(/\.s3\.[^/]+\//.test(t)){e="s3";const{bucket:s,keyPrefix:a}=parseS3URL(t);s&&(r.bucket=s,t=a)}else t.startsWith("icons/")&&(e="public");return{source:e,pattern:t,browseOptions:r}}static async upload(t,e,r={}){if(!e)throw new Error("No file was uploaded");if(!["data","s3"].includes(t))throw new Error("You may not upload to this location");const s=path.extname(e.name).slice(1).toLowerCase(),a=UPLOADABLE_FILE_EXTENSIONS[s];if(r.contentType=a,!a)throw new Error("You are attempting to upload a file with a disallowed file extension.");const o=MEDIA_MIME_TYPES.includes(a),i=["module.json","system.json","world.json","template.json"].includes(e.name.toLowerCase());r.overwrite=o&&!i;return config.files.storages[t].upload(e,r)}static socketListeners(t){t.on("manageFiles",((e,r,s)=>{this._onManageFiles(t,e,r,s)})),t.on("template",((t,e)=>{try{e(this.loadTemplate(t))}catch(t){e({error:t.message})}}))}static _onManageFiles(t,e,r,s){const a=!game.active&&!config.adminPassword||t.session.admin;if(!(t.user?t.user.hasPermission("FILES_BROWSE"):a))return s({error:"You do not have permission to browse the host file system!"});r.isAdmin=a||game.active&&t.user.hasRole("ASSISTANT");const o="user"===e.storage?"data":e.storage,i=config.files.storages[o];if(!i)return s({error:`The requested file storage ${e.storage} does not exist!`});switch(e.action){case"browseFiles":this._handleGetFiles(i,e,r,s);break;case"createDirectory":this._handleCreateDirectory(i,e,r,s);break;case"configurePath":this._handleConfigurePath(i,e,r,s)}}static _handleCreateDirectory(t,e,r,s){t.createDirectory(e.target,r).then((t=>s(t))).catch((t=>s({error:t.message})))}static _handleGetFiles(t,e,r,s){const a=mergeObject(r,{target:e.target});t.getFiles(a).then((t=>s(t))).catch((t=>s({error:t.message})))}static _handleConfigurePath(t,e,r,s){let a=t.configuration;r.bucket&&(a=a[r.bucket]=a[r.bucket]||{});const o=e.target,i=getProperty(a,o)||{};mergeObject(i,{private:r.private,gridSize:r.gridSize}),i.private||i.gridSize?a[o]=i:delete a[o];const n=path.join(paths.config,Files.STORAGE_CONFIGURATION_FILENAME);fs.writeFileSync(n,JSON.stringify(config.files.configuration)),s(i)}}