import NeDB from"nedb";import{debounce}from"../../../common/utils/helpers.mjs";import Semaphore from"../../../common/utils/semaphore.mjs";export default class Datastore extends NeDB{constructor(e,...t){super(...t),this.tableName=e,this.connected=!1,this._ops=0,this.semaphore=new Semaphore(1),this._compactDebounce=debounce((()=>this._compactImmediate()),2e3)}static MIN_COMPACTION_OPERATIONS=50;static MAX_COMPACTION_OPERATIONS=250;static datastores=new Map;static async connect(e,t){return new Promise(((s,i)=>{game.active||i("You cannot connect to a DataStore until a game World is active");let o=new this(e,{filename:t,compareStrings:this.compareStrings});o.loadDatabase((t=>(t&&i(t),Datastore.datastores.set(e,o),o.connected=!0,s(o))))}))}static compareStrings(e,t){return e.localeCompare(t)}async disconnect(){this.connected=!1,this.persistence.stopAutocompaction(),await new Promise((e=>{this.once("compaction.done",e),this.persistence.compactDatafile()})),Datastore.datastores.delete(this.tableName)}deleteOne(e){return new Promise(((t,s)=>this._executeDelete(e,{},t,s)))}deleteMany(e={}){return new Promise(((t,s)=>this._executeDelete(e,{multi:!0},t,s)))}findMany(e={},{limit:t,project:s,sort:i,skip:o}={}){return new Promise(((r,n)=>{let a=this.find(e);s&&(a=a.projection(s)),i&&(a=a.sort(i)),o&&(a=a.skip(o)),t&&(a=a.limit(t)),a.exec(((e,t)=>e?n(e):r(t)))}))}findOne(e){return new Promise(((t,s)=>super.findOne(e,((e,i)=>e?s(e):t(i=i??null)))))}insertOne(e){return e._id||delete e._id,new Promise(((t,s)=>this._executeInsert(e,t,s)))}insertMany(e){for(let t of e)t._id||delete t._id;return new Promise(((t,s)=>this._executeInsert(e,t,s)))}updateOne(e,t){let s={upsert:!1,returnUpdatedDocs:!0,multi:!1};return new Promise(((i,o)=>this._executeUpdate(e,t,s,i,o)))}updateMany(e,t){let s={upsert:!1,returnUpdatedDocs:!0,multi:!0};return new Promise(((i,o)=>this._executeUpdate(e,t,s,i,o)))}_executeInsert(e,t,s){this.insert(e,((e,i)=>{if(e)return s(e);t(i),this._onOperation()}))}_executeUpdate(e,t,s,i,o){this.update(e,t,s,((e,t,s)=>{if(e)return o(e);i(s),this._onOperation()}))}_executeDelete(e,t,s,i){this.remove(e,t,((e,t)=>{if(e)return i(e);s(t),this._onOperation()}))}_onOperation(){return this._ops+=1,this._ops>=Datastore.MAX_COMPACTION_OPERATIONS?this._compactImmediate():this._ops>=Datastore.MIN_COMPACTION_OPERATIONS?this._compactDebounce():void 0}_compactImmediate(){this._ops=0,this.persistence.compactDatafile(),logger.info(`Compacted database file for ${this.tableName}`)}}