import fs from"fs";import os from"os";import path from"path";import{spawn}from"child_process";import url from"url";import License from"./license.mjs";import Files from"../files/files.mjs";import{SOFTWARE_UPDATE_CHANNELS,TIMEOUTS}from"../../common/constants.mjs";import{fetchJsonWithTimeout}from"../../common/utils/http.mjs";import{ReleaseData}from"../../common/config.mjs";import FileDownloader from"../files/downloader.mjs";export default class Updater{constructor(e){this.appDir=e.root,this.updateDir=path.join(e.root,"_update"),this.platform=this._getPlatform(),this.target=null,this.availability={hasUpdate:!1,couldReachWebsite:!1,slowResponse:!1,version:null,channel:null,willDisableModules:!1},this._throttlePct=null,this._updateCheckTime=0}_getPlatform(){let e=os.platform();return"win32"===e?"win":"darwin"===e?"mac":"linux"}get file(){if(!this.target?.download)throw new Error("No target download URL has yet been identified!");const e=url.parse(this.target.download).pathname;return e?path.parse(e).base:null}get localDest(){return`${this.updateDir}/${this.file}`}async check({updateChannel:e="stable",forceUpdate:t}={}){if(t=["true",!0].includes(t),this.target=null,this.availability.version=null,this.availability.channel=null,this.availability.couldReachWebsite=!0,!((e={alpha:"prototype",beta:"testing",release:"stable"}[e]||e)in SOFTWARE_UPDATE_CHANNELS))throw new Error(`${e} is not a valid software update channel to check.`);e!==config.options.updateChannel&&(config.options.updateSource({updateChannel:e}),config.options.save());const a=Date.now();let i;try{i=await this._getLatestAvailableUpdate(e)}catch(e){return 403!==e.code&&(logger.warn("The Foundry Virtual Tabletop website could not be reached to check for core software updates"),this.availability.couldReachWebsite=!1),null}finally{this.availability.slowResponse=Date.now()-a>2e3}if(this.availability.maxStableGeneration=i.max_stable_generation,!1===i.valid_key)throw config.license.expire(),new Error("SETUP.UpdateLicenseInvalid");if(config.options.noupdate)throw new Error("SETUP.UpdateNoUpdateMode");if("error"===i.status)throw new Error(i.message);const s=new ReleaseData(i.latest_release);this.availability.hasUpdate=s.isNewer(config.release);const o=t||this.availability.hasUpdate;return o&&(logger.info(`Core software ${s.channel} update ${s.version} is available!`),this.target=s,this.availability.version=s.version,this.availability.channel=s.channel),this.availability.willDisableModules=o&&s.isGenerationalChange(config.release),this.target}async _getLatestAvailableUpdate(e){return fetchJsonWithTimeout(License.SOFTWARE_UPDATE_URL,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({updateChannel:e,license:config.license.data,versions:{foundry:config.release.version,node:process.versions.node,electron:process.versions.electron}})},{timeoutMs:TIMEOUTS.PACKAGE_REPOSITORY})}update(){if(config.options.noupdate)throw new Error("You are not allowed to update this instance of Foundry Virtual Tabletop because it was launched in --noupdate mode.");return new Promise((async(e,t)=>{try{await this.download({onFetched:()=>e({})});await this.install()&&this.restart()}catch(e){t(e)}}))}async download({onFetched:e}={}){if(!this.target)throw new Error("No update target has been identified");try{fs.accessSync(paths.root,fs.constants.W_OK),await Files.rmdir(this.updateDir),await Files.mkdir(this.updateDir)}catch(e){throw console.error(e),new Error("You do not have permission to write files in your Foundry Virtual Tabletop installation \n      location. You may need to run the application as an Administrator to perform an update.")}const t=this.target.download=await this._getDownloadURL(this.target),a=new FileDownloader(t,this.localDest);return a.on("error",(e=>this.progress({step:"Error",message:e.message,pct:100}))),a.on("progress",(e=>{this.progress({step:"SETUP.UpdateDownloadingS",message:"Downloading software update",pct:Math.min(e,99)})})),e&&a.on("fetched",e),await a.download(),this.progress({step:"SETUP.UpdateDownloadingC",message:"Update download complete",pct:100}),this.localDest}async _getDownloadURL(e){return(await fetchJsonWithTimeout(License.SOFTWARE_DOWNLOAD_URL,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({generation:e.generation,build:e.build,license:config.license.data})})).download}async install(){if(!fs.existsSync(this.localDest))return this.progress({step:"Error",message:"SETUP.UpdateNoArchive",pct:100}),!1;const e=config.options.debug,t=e?path.join(this.appDir,"_testInstall"):this.appDir;e&&await Files.rmdir(t);const a=await Files.extractArchive(this.localDest,this.updateDir,{onProgress:(e,t,a,i)=>{this.progress({step:"SETUP.UpdateExtractingS",message:"Extracting downloaded update files",pct:Math.min(i,99)})}});this.progress({step:"SETUP.UpdateExtractingC",message:"Update extraction complete",pct:100}),fs.unlinkSync(this.localDest),this.progress({step:"SETUP.UpdateCleaningS",message:"Cleaning existing folder content",pct:25});const i=e?[]:["dist","public","templates"];for(let[e,t]of i.entries()){await Files.rmdir(t);const a=Math.min(Math.round(e+2/t.length+1),99);this.progress({step:"SETUP.UpdateCleaningS",message:"Cleaning existing folder content",pct:a})}this.progress({step:"SETUP.UpdateCleaningC",message:"Folder cleaning complete",pct:100});let s=0;return await Files.copyDirectory(this.updateDir,t,{onProgress:()=>{s++;let e=Math.clamped(Math.round(s/a*100),0,99);this.progress({step:"SETUP.UpdateInstallingS",message:"Installing update files",pct:e})},ignore:["package.json"]}),await fs.promises.copyFile(path.join(this.updateDir,"package.json"),path.join(t,"package.json")),this.progress({step:"SETUP.UpdateInstallingC",message:"Update installation complete",pct:100}),await Files.rmdir(this.updateDir),e&&await Files.rmdir(t),!0}async restart(e={}){const{options:t}=config;if(!t.isElectron)return setTimeout(process.exit,50),void this.progress({step:"SETUP.UpdateCompleteManual",message:"Update Complete",type:"SHUTDOWN",pct:100});let a=process.argv[0],i=process.argv.slice(1)||[];e.restart=1,setTimeout((()=>{spawn(a,i,{detached:!0,cwd:this.appDir,stdio:"inherit",env:e}).unref(),process.exit()}),50),this.progress({step:"SETUP.UpdateCompleteAuto",message:"Update Complete",next:"RESTART",pct:100})}progress({step:e,message:t,pct:a=0}={}){if(a===this._throttlePct)return;this._throttlePct=100===a?null:a;const{logger:i,express:s}=global.config;i.info(a?`${t} - ${a}%`:t),s.io.emit("progress",{action:"updateCore",type:"core",name:"FoundryVTT",step:e,message:t,pct:a})}async checkCoreUpdateAvailability(){const e=global.config,t=Date.now();if(t-this._updateCheckTime<864e5)return this.availability;this._updateCheckTime=t;try{await this.check({updateChannel:e.options.updateChannel})}catch{}return this.availability}}