/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.platform.MwA;
import com.bitwig.base.platform.NativeMemoryBlock;
import com.bitwig.base.platform.wEG;

class Win32DIBSectionMemoryBlock
extends MwA {
    private static final wEG XHT = new wEG("Windows DIB");
    private long hAB;
    private NativeMemoryBlock lTJ;

    private Win32DIBSectionMemoryBlock(long l2, long l3, int n4, int n5, NativeMemoryBlock nativeMemoryBlock) {
        super(nativeMemoryBlock.DVW());
        this.hAB = l2;
        this.lTJ = nativeMemoryBlock;
    }

    public static Win32DIBSectionMemoryBlock DVW(long l2, int n4, int n5) {
        int n6 = Win32DIBSectionMemoryBlock.DVW(n4, n5);
        long[] lArray = Win32DIBSectionMemoryBlock.gBO(l2, n4, n5);
        assert (brm.gBO(lArray.length == 2));
        long l3 = lArray[0];
        long l4 = lArray[1];
        NativeMemoryBlock nativeMemoryBlock = XHT.DVW(l4, n6);
        return new Win32DIBSectionMemoryBlock(l3, l2, n4, n5, nativeMemoryBlock);
    }

    @Override
    public void XHT() {
        assert (brm.DVW(!this.gBO()));
        if (this.lTJ != null) {
            this.lTJ.XHT();
            this.lTJ = null;
            Win32DIBSectionMemoryBlock.releaseNative(this.hAB);
            super.XHT();
            this.hAB = 0L;
            assert (brm.DVW(this.lTJ == null));
        }
        assert (brm.DVW(this.hAB == 0L));
    }

    public NativeMemoryBlock hAB() {
        assert (brm.gBO(this.lTJ != null));
        return this.lTJ;
    }

    private static int DVW(int n4, int n5) {
        return n4 * n5 * 4;
    }

    private static long[] gBO(long l2, int n4, int n5) {
        long[] lArray = Win32DIBSectionMemoryBlock.createNative(l2, n4, n5);
        if (lArray == null) {
            throw new OutOfMemoryError("Could not allocate native memory block");
        }
        assert (brm.gBO(lArray.length == 2));
        return lArray;
    }

    public long lTJ() {
        return this.hAB;
    }

    private static native long[] createNative(long var0, int var2, int var3);

    private static native void releaseNative(long var0);
}

