/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class StringValueProxy
extends ValueProxy
implements FhX,
StringValue {
    private juj mValue;
    private final juj mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createControlSurfaceStringValue(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return BDv.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n4) {
        this.atLeast(n4, 1, "maxLength");
        this.checkCanGet();
        assert (bqP.XHT(n4 >= 1));
        return this.mValue.getLimited(n4);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(juj2 -> stringValueChangedCallback.valueChanged(juj2.get()));
    }

    public void addValueObserver(int n4, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(juj2 -> {
            if (juj2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(juj2.getLimited(n4));
            }
        });
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(BDv bDv2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(bDv2 != null));
        if (bDv2.isObservable()) {
            bDv2.removeListener(this);
        }
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(BDv bDv2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(bDv2 != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isActiveOnDocumentThread()));
        if (bDv2.isObservable()) {
            bDv2.addListener(this);
        }
        this.updateValue();
    }

    public juj getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(sqC sqC2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(Objects.equals(sqC2.DVW(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        String string = (String)((BDv)this.getTarget()).getValue();
        assert (bqP.XHT(string != null));
        juj juj2 = this.createControlSurfaceStringValue(string);
        assert (bqP.XHT(juj2 != null));
        this.queueNotifyObservers(juj2);
    }

    private void queueNotifyObservers(juj juj2) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(juj2));
    }

    protected juj createControlSurfaceStringValue(String string) {
        assert (bqP.XHT(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return juj.EMPTY;
        }
        return new uJP(string);
    }

    private void notifyObservers(juj juj2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        if (!juj2.equals(this.mValue)) {
            this.mValue = juj2;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(juj2);
                }
            }
        }
    }
}

