/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ObjectValueChangedCallback;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Arrays;
import java.util.Objects;

public class StringArrayValueProxy
extends ValueProxy
implements FhX,
StringArrayValue {
    private final String[] mDefaultValue;
    private String[] mValue;

    public StringArrayValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray) {
        super(controlSurfaceObject);
        this.mDefaultValue = stringArray;
        this.mValue = stringArray;
    }

    @Override
    public Class getTargetType() {
        return tpR.class;
    }

    @Override
    public String[] get() {
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(ObjectValueChangedCallback objectValueChangedCallback) {
        this.doAddValueObserver(objectValueChangedCallback);
    }

    protected void sendDefaultValue(ObjectValueChangedCallback objectValueChangedCallback) {
        objectValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void connectToTarget(tpR tpR2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(tpR2 != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isActiveOnDocumentThread()));
        tpR2.addListener(this);
        this.queueNotifyObservers((String[])tpR2.getValue());
    }

    protected void disconnectFromTarget(tpR tpR2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(tpR2 != null));
        tpR2.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    public void eventOccurred(sqC sqC2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(Objects.equals(sqC2.DVW(), this.getTarget())));
        String[] stringArray = (String[])((tpR)this.getTarget()).getValue();
        this.queueNotifyObservers(stringArray);
    }

    private void queueNotifyObservers(String[] stringArray) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(stringArray));
    }

    private void notifyObservers(String[] stringArray) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        if (!Arrays.equals(stringArray, this.mValue)) {
            this.mValue = stringArray;
            if (this.mObservers != null) {
                for (ObjectValueChangedCallback objectValueChangedCallback : this.mObservers) {
                    objectValueChangedCallback.valueChanged(stringArray);
                }
            }
        }
    }
}

