/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SignalProxy;
import com.bitwig.ramona.core.z;

public class SignalSetting
extends SignalProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final String mAction;
    private hBV mIsEnabled;
    private hBV mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private z mSetting;

    public SignalSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new FVt("Error: label for setting can't be empty.");
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mAction = string3;
    }

    public void connectToSetting(zWl zWl2) {
        assert (bqP.lTJ(this.mSetting == null));
        this.mSetting = zWl2;
        this.setTarget(zWl2.pxg());
        this.connectEnableAndVisibleValues(zWl2.RXU(), zWl2.qnY());
    }

    public void disconnectFromSetting(zWl zWl2) {
        assert (bqP.lTJ(this.mSetting == zWl2));
        this.disconnectEnableAndVisibleValues(zWl2.RXU(), zWl2.qnY());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(YtB ytB) {
        assert (bqP.lTJ(this.mSetting == null));
        this.mSetting = ytB;
        this.setTarget(ytB.lTJ());
        this.connectEnableAndVisibleValues(ytB.fJ1(), ytB.pxg());
    }

    public void disconnectFromSetting(YtB ytB) {
        assert (bqP.lTJ(this.mSetting == ytB));
        this.disconnectEnableAndVisibleValues(ytB.fJ1(), ytB.pxg());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = hBV2;
        this.mIsVisible = hBV3;
    }

    private void disconnectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public String getAction() {
        return this.mAction;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public z getSetting() {
        return this.mSetting;
    }
}

