/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.AbsoluteHardwareControl;
import com.bitwig.extension.controller.api.AbsoluteHardwareControlBinding;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlToRangedValueBinding;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy;
import com.bitwig.flt.control_surface.values.DocumentNumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.NumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.PreferencesNumberSettingRangedValueTarget;
import com.bitwig.ramona.core.z;

public class NumberSetting
extends AbstractRangedValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final double mMinValue;
    private final double mMaxValue;
    private final double mStepResolution;
    private final String mUnit;
    private final double mDefaultValue;
    private hBV mIsEnabled;
    private hBV mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private z mSetting;

    public NumberSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, double d3, double d4, double d5, String string3, double d6) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new FVt("Error: label for setting can't be empty.");
        }
        if (string3 == null) {
            string3 = "";
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mMinValue = d3;
        this.mMaxValue = d4;
        this.mStepResolution = d5;
        this.mUnit = string3;
        this.mDefaultValue = d6;
        this.setKey("Setting/" + string2 + "/" + string);
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    @Override
    public Class getTargetType() {
        return NumberSettingRangedValueTarget.class;
    }

    public void connectToSetting(NfJ nfJ) {
        assert (bqP.lTJ(this.mSetting == null));
        this.mSetting = nfJ;
        this.setTarget(new PreferencesNumberSettingRangedValueTarget(nfJ));
        this.connectEnableAndVisibleValues(nfJ.RXU(), nfJ.qnY());
    }

    public void disconnectFromSetting(NfJ nfJ) {
        assert (bqP.lTJ(this.mSetting == nfJ));
        this.disconnectEnableAndVisibleValues(nfJ.RXU(), nfJ.qnY());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(yVp yVp2) {
        assert (bqP.lTJ(this.mSetting == null));
        this.mSetting = yVp2;
        this.setTarget(new DocumentNumberSettingRangedValueTarget(yVp2));
        this.connectEnableAndVisibleValues(yVp2.fJ1(), yVp2.pxg());
    }

    public void disconnectFromSetting(yVp yVp2) {
        assert (bqP.lTJ(this.mSetting == yVp2));
        this.disconnectEnableAndVisibleValues(yVp2.fJ1(), yVp2.pxg());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = hBV2;
        this.mIsVisible = hBV3;
    }

    private void disconnectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    protected double getCurrentValue() {
        double d3 = super.getCurrentValue();
        int n4 = (int)Math.round(d3 / this.mStepResolution);
        return this.mStepResolution * (double)n4;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public double getStepResolution() {
        return this.mStepResolution;
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public z getSetting() {
        return this.mSetting;
    }

    @Override
    public AbsoluteHardwareControlBinding addBindingWithRange(AbsoluteHardwareControl absoluteHardwareControl, double d3, double d4) {
        throw new FVt("Not supported");
    }

    @Override
    public RelativeHardwareControlToRangedValueBinding addBindingWithRangeAndSensitivity(RelativeHardwareControl relativeHardwareControl, double d3, double d4, double d5) {
        throw new FVt("Not supported");
    }
}

