/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.ManuallyMappedRangedValueTarget;
import java.util.ArrayList;
import java.util.List;

class MultiManuallyMappedRangedValueTarget
extends ManuallyMappedRangedValueTarget
implements BAN {
    private final List mManualMappings;
    private final xz3 mEventSource = new xz3(false);

    public MultiManuallyMappedRangedValueTarget(List list) {
        assert (bqP.XHT(list != null));
        assert (bqP.XHT(list.size() >= 2));
        this.mManualMappings = new ArrayList(list);
    }

    @Override
    public void connected() {
        super.connected();
        for (LDB lDB : this.mManualMappings) {
            lDB.DVW(this);
        }
    }

    @Override
    public void disconnected() {
        super.disconnected();
        for (LDB lDB : this.mManualMappings) {
            lDB.gBO(this);
        }
    }

    public int getManualMappingCount() {
        return this.mManualMappings.size();
    }

    public LDB getManualMappingAt(int n4) {
        return (LDB)this.mManualMappings.get(n4);
    }

    @Override
    public String getName() {
        return "*Multi*";
    }

    @Override
    public OMs getValueChangedEventSource() {
        return this.mEventSource;
    }

    @Override
    public double getCurrentValue() {
        double d3 = 1.0;
        for (LDB lDB : this.mManualMappings) {
            double d4 = lDB.jpF();
            d3 = Math.min(d3, d4);
        }
        return d3;
    }

    @Override
    public boolean isSettable() {
        return true;
    }

    @Override
    public void setCurrentValue(double d3) {
        assert (bqP.XHT(d3 >= 0.0 && d3 <= 1.0));
        for (LDB lDB : this.mManualMappings) {
            lDB.gBO(d3);
        }
    }

    @Override
    public void incrementNormalized(double d3) {
        for (LDB lDB : this.mManualMappings) {
            lDB.lTJ(d3);
        }
    }

    @Override
    public double valueToNormalizedValue(double d3) {
        return d3;
    }

    @Override
    public double normalizedValueToValue(double d3) {
        return d3;
    }

    @Override
    public juj createTruncatableStringForValue(double d3) {
        assert (bqP.XHT(d3 >= 0.0 && d3 <= 1.0));
        int n4 = (int)Math.round(d3 * 100.0);
        return new EY2(n4);
    }

    @Override
    public void eventOccurred(Object object) {
        this.mEventSource.setBoolValue(!this.mEventSource.getBoolValue());
    }

    @Override
    public boolean isContinuous() {
        return true;
    }
}

