/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;

public class ListValueLengthProxy
extends ValueProxy
implements CO,
IntegerValue {
    private List mUnassignedObservers;
    private boolean mHasScheduledUpdateCount;
    private int mValue;

    public ListValueLengthProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public Class getTargetType() {
        return dIf.class;
    }

    @Override
    public int get() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n4) {
        if (n4 == 0) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n4));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(0);
    }

    protected void connectToTarget(dIf dIf2) {
        dIf2.DVW(this);
    }

    protected void disconnectFromTarget(dIf dIf2) {
        dIf2.gBO(this);
    }

    @Override
    public void addedAsListenerTo(dIf dIf2) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(dIf dIf2) {
        this.scheduleUpdateCount();
    }

    @Override
    public void insertedItems(dIf dIf2, int n4, int n5) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToRemoveItems(dIf dIf2, int n4, int n5) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToChangeItems(dIf dIf2, int n4, int n5) {
        this.scheduleUpdateCount();
    }

    @Override
    public void changedItems(dIf dIf2, int n4, int n5) {
    }

    private void scheduleUpdateCount() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateCount) {
            this.mHasScheduledUpdateCount = true;
            this.runAtEndOfEvent(this::updateCount);
        }
    }

    private void updateCount() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.mHasScheduledUpdateCount));
        this.mHasScheduledUpdateCount = false;
        dIf dIf2 = (dIf)this.getTarget();
        if (dIf2 != null) {
            this.queueNotifyObservers(dIf2.gBO());
        } else {
            this.queueNotifyObserversUnassigned();
        }
    }

    private void queueNotifyObserversUnassigned() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(0, false));
    }

    private void queueNotifyObservers(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(n4, true));
    }

    private void notifyObservers(int n4, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(!bl2 ? n4 == 0 : true));
        if (n4 != this.mValue) {
            this.mValue = n4;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n4);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n4);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

