/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IntegerValueProxy
extends ValueProxy
implements FhX,
IntegerValue {
    private int mValue;
    private final int mDefaultValue;
    private List mUnassignedObservers;

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject, int n4) {
        super(controlSurfaceObject);
        this.mValue = n4;
        this.mDefaultValue = n4;
    }

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0);
    }

    @Override
    public Class getTargetType() {
        return txN.class;
    }

    @Override
    public int get() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public int getControlSurfaceValue() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n4) {
        if (n4 == this.mDefaultValue) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n4));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(txN txN2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(txN2 != null));
        txN2.removeListener(this);
        this.queueNotifyObserversUnassigned();
    }

    protected void connectToTarget(txN txN2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(txN2 != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isActiveOnDocumentThread()));
        txN2.addListener(this);
        this.queueNotifyObservers(txN2.getIntegerValue());
    }

    public int getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(sqC sqC2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(Objects.equals(sqC2.DVW(), this.getTarget())));
        int n4 = ((txN)this.getTarget()).getIntegerValue();
        this.queueNotifyObservers(n4);
    }

    private void queueNotifyObserversUnassigned() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(this.mDefaultValue, false));
    }

    private void queueNotifyObservers(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(n4, true));
    }

    private void notifyObservers(int n4, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(!bl2 ? n4 == this.mDefaultValue : true));
        if (n4 != this.mValue) {
            this.mValue = n4;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n4);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n4);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

