/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.EnumValueChangedCallback;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class EnumValueProxy
extends ValueProxy
implements FhX,
SettableEnumValue {
    private String mValue;
    private final String mInitialValue;
    private final String[] mOptions;

    public EnumValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray, String string) {
        super(controlSurfaceObject);
        assert (bqP.XHT(stringArray != null));
        assert (bqP.lTJ(stringArray.length > 0));
        this.mOptions = stringArray;
        this.mInitialValue = string;
        this.mValue = string;
    }

    @Override
    public Class getTargetType() {
        return BDv.class;
    }

    public void addValueObserver(EnumValueChangedCallback enumValueChangedCallback) {
        this.doAddValueObserver(enumValueChangedCallback);
    }

    protected void sendDefaultValue(EnumValueChangedCallback enumValueChangedCallback) {
        enumValueChangedCallback.valueChanged(this.mInitialValue);
    }

    @Override
    public void set(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (string == null) {
            throw new FVt("value cannot be null");
        }
        this.exec(() -> this.doSet(string));
    }

    private void doSet(String string) {
        assert (bqP.XHT(this.isDocumentThread()));
        BDv bDv2 = (BDv)this.getTarget();
        if (bDv2 != null) {
            bDv2.setValue(string);
        }
    }

    protected void disconnectFromTarget(BDv bDv2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(bDv2 != null));
        bDv2.removeListener(this);
        this.queueNotifyObservers(this.mInitialValue);
    }

    protected void connectToTarget(BDv bDv2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(bDv2 != null));
        bDv2.addListener(this);
        this.queueNotifyObservers((String)bDv2.getValue());
    }

    public String[] getOptions() {
        return this.mOptions;
    }

    public String getDefaultValue() {
        return this.mInitialValue;
    }

    public void eventOccurred(sqC sqC2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(Objects.equals(sqC2.DVW(), this.getTarget())));
        String string = (String)((BDv)this.getTarget()).getValue();
        this.queueNotifyObservers(string);
    }

    private void queueNotifyObservers(String string) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(string));
    }

    private void notifyObservers(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        if (!string.equals(this.mValue)) {
            this.mValue = string;
            if (this.mObservers != null) {
                for (EnumValueChangedCallback enumValueChangedCallback : this.mObservers) {
                    enumValueChangedCallback.valueChanged(string);
                }
            }
        }
    }

    @Override
    public String get() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }
}

