/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumValueProxy;
import com.bitwig.ramona.core.z;

public class EnumSetting
extends EnumValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private hBV mIsEnabled;
    private hBV mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private z mSetting;

    public EnumSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String[] stringArray, String string3) {
        super(controlSurfaceObject, stringArray, string3);
        if (string == null || string.isEmpty()) {
            throw new FVt("Error: label for setting can't be empty.");
        }
        if (stringArray.length < 2) {
            throw new FVt("Enum settings should have at least two options.");
        }
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(lsR lsR2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(lsR2 != null));
        assert (bqP.lTJ(this.mSetting == null));
        this.mSetting = lsR2;
        this.setTarget(lsR2.fJ1());
        this.connectEnableAndVisibleValues(lsR2.RXU(), lsR2.qnY());
    }

    public void disconnectFromSetting(lsR lsR2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(lsR2 != null));
        assert (bqP.lTJ(this.mSetting == lsR2));
        this.disconnectEnableAndVisibleValues(lsR2.RXU(), lsR2.qnY());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(SPP sPP) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.lTJ(this.mSetting == null));
        assert (bqP.XHT(sPP != null));
        this.mSetting = sPP;
        this.setTarget(sPP.gBO());
        this.connectEnableAndVisibleValues(sPP.fJ1(), sPP.pxg());
    }

    public void disconnectFromSetting(SPP sPP) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(sPP != null));
        assert (bqP.lTJ(this.mSetting == sPP));
        this.disconnectEnableAndVisibleValues(sPP.fJ1(), sPP.pxg());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = hBV2;
        this.mIsVisible = hBV3;
    }

    private void disconnectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public z getSetting() {
        return this.mSetting;
    }
}

