/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class DoubleValueProxy
extends ValueProxy
implements FhX,
DoubleValue {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d3) {
        super(controlSurfaceObject);
        this.mValue = d3;
        this.mDefaultValue = d3;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return In3.class;
    }

    @Override
    public double get() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(In3 in3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(in3 != null));
        in3.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(In3 in3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(in3 != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isActiveOnDocumentThread()));
        in3.addListener(this);
        this.queueNotifyObservers(in3.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(sqC sqC2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(Objects.equals(sqC2.DVW(), this.getTarget())));
        double d3 = ((In3)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d3);
    }

    private void queueNotifyObservers(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d3));
    }

    private void notifyObservers(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        if (d3 != this.mValue) {
            this.mValue = d3;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d3);
                }
            }
        }
    }
}

