/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;

public class ComputedStringValue
extends ComputedValue
implements StringValue {
    private juj mValue;
    private juj mDocumentValue;
    private final juj mDefaultValue;

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject, juj juj2) {
        super(controlSurfaceObject);
        assert (bqP.XHT(juj2 != null));
        this.mValue = juj2;
        this.mDocumentValue = juj2;
        this.mDefaultValue = juj2;
    }

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, juj.EMPTY);
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n4) {
        this.atLeast(n4, 1, "maxLength");
        this.checkCanGet();
        return this.mValue.getLimited(n4);
    }

    public String getValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        return this.mDocumentValue.get();
    }

    public void setValue(juj juj2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(juj2 != null));
        if (!juj2.equals(this.mDocumentValue)) {
            this.mDocumentValue = juj2;
            if (this.isInterested()) {
                this.queueNotifyObservers(juj2);
            }
        }
    }

    public final void setValue(String string) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(string != null));
        this.setValue(this.createControlSurfaceStringValue(string));
    }

    public void unassign() {
        assert (bqP.XHT(this.isDocumentThread()));
        this.setValue(this.mDefaultValue);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(juj2 -> stringValueChangedCallback.valueChanged(juj2.get()));
    }

    public void addValueObserver(int n4, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(juj2 -> {
            if (juj2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(juj2.getLimited(n4));
            }
        });
    }

    protected void sendInitialValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        controlSurfaceStringValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(juj juj2) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(juj2));
    }

    private void notifyObservers(juj juj2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        if (!juj2.equals(this.mValue)) {
            this.mValue = juj2;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(juj2);
                }
            }
        }
    }

    protected juj createControlSurfaceStringValue(String string) {
        assert (bqP.XHT(this.isDocumentThread() || this.isInitializingDriver()));
        assert (bqP.XHT(string != null));
        if (string.isEmpty()) {
            return juj.EMPTY;
        }
        return new uJP(string);
    }

    protected juj getControlSurfaceString() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.mValue != null));
        return this.mValue;
    }
}

