/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import java.util.ArrayList;
import java.util.List;

public class ComputedIntegerValue
extends ComputedValue
implements IntegerValue {
    private int mValue;
    private int mDocumentValue;
    private final int mDefaultValue;
    private List mUnassignedObservers;

    public ComputedIntegerValue(ControlSurfaceObject controlSurfaceObject, int n4) {
        super(controlSurfaceObject);
        this.mDefaultValue = n4;
        this.mValue = n4;
        this.mDocumentValue = n4;
    }

    @Override
    public int get() {
        this.checkCanGet();
        return this.mValue;
    }

    public int getControlSurfaceValue() {
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return this.mValue;
    }

    public int getValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setIntegerValue(int n4) {
        this.setIntegerValue(n4, true);
    }

    public void unassigned() {
        this.setIntegerValue(this.mDefaultValue, false);
    }

    private void setIntegerValue(int n4, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(!bl2 ? n4 == this.mDefaultValue : true));
        if (n4 != this.mDocumentValue) {
            this.mDocumentValue = n4;
            if (this.isInterested()) {
                this.queueNotifyObservers(n4, bl2);
            }
        } else if (!bl2 && this.mUnassignedObservers != null) {
            this.queueNotifyObservers(n4, false);
        }
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n4) {
        if (n4 == this.mDefaultValue) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n4));
        }
    }

    protected void sendInitialValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(int n4, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(n4, bl2));
    }

    private void notifyObservers(int n4, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(!bl2 ? n4 == this.mDefaultValue : true));
        if (n4 != this.mValue) {
            this.mValue = n4;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n4);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n4);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

