/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedDoubleValue
extends ComputedValue
implements DoubleValue {
    private double mValue;
    private final double mDefaultValue;
    private final Msw mDocumentValue;
    private final boolean mCanBeReduced;

    public ComputedDoubleValue(ControlSurfaceObject controlSurfaceObject, double d3, boolean bl2) {
        super(controlSurfaceObject);
        this.mDefaultValue = d3;
        this.mValue = d3;
        this.mDocumentValue = new Msw(d3);
        this.mCanBeReduced = bl2;
    }

    public ComputedDoubleValue(ControlSurfaceObject controlSurfaceObject, double d3) {
        this(controlSurfaceObject, d3, true);
    }

    @Override
    public double get() {
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return this.mValue;
    }

    public In3 getDocumentValue() {
        return this.mDocumentValue;
    }

    public double getValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        return this.mDocumentValue.getDoubleValue();
    }

    public void setDoubleValue(double d3) {
        this.setDoubleValue(d3, true);
    }

    public void unassigned() {
        this.setDoubleValue(this.mDefaultValue, false);
    }

    private void setDoubleValue(double d3, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(!bl2 ? d3 == this.mDefaultValue : true));
        if (d3 != this.mDocumentValue.getDoubleValue()) {
            this.mDocumentValue.setDoubleValue(d3);
            if (this.isInterested()) {
                this.queueNotifyObservers(d3, bl2);
            }
        }
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendInitialValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(double d3, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mCanBeReduced) {
            this.queueCallback(this, () -> this.notifyObservers(d3, bl2));
        } else {
            this.queueCallback(() -> this.notifyObservers(d3, bl2));
        }
    }

    private void notifyObservers(double d3, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(!bl2 ? d3 == this.mDefaultValue : true));
        if (d3 != this.mValue) {
            this.mValue = d3;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d3);
                }
            }
        }
    }
}

