/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.controller.api.ColorValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedColorValue
extends ComputedValue
implements ColorValue {
    private bIC mValue;
    private bIC mDocumentValue;

    public ComputedColorValue(ControlSurfaceObject controlSurfaceObject, bIC bIC2) {
        super(controlSurfaceObject);
        this.mValue = bIC2;
        this.mDocumentValue = bIC2;
    }

    @Override
    public float red() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        return this.mValue.qhn();
    }

    @Override
    public float green() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        return this.mValue.nrS();
    }

    @Override
    public float blue() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        return this.mValue.jpF();
    }

    @Override
    public float alpha() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(5);
        return this.mValue.jJc();
    }

    public bIC getValue() {
        assert (bqP.DVW(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setValue(bIC bIC2) {
        assert (bqP.DVW(this.isDocumentThread()));
        if (!bIC2.DVW(this.mDocumentValue)) {
            this.mDocumentValue = bIC2;
            if (this.isInterested()) {
                this.queueNotifyObservers(bIC2);
            }
        }
    }

    public void addValueObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.doAddValueObserver(colorValueChangedCallback);
    }

    protected void sendInitialValue(ColorValueChangedCallback colorValueChangedCallback) {
        colorValueChangedCallback.valueChanged(this.mValue.qhn(), this.mValue.nrS(), this.mValue.jpF());
    }

    private void queueNotifyObservers(bIC bIC2) {
        assert (bqP.DVW(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(bIC2));
    }

    private void notifyObservers(bIC bIC2) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        assert (bqP.DVW(this.isInterested()));
        if (!bIC2.DVW(this.mValue)) {
            this.mValue = bIC2;
            if (this.mObservers != null) {
                for (ColorValueChangedCallback colorValueChangedCallback : this.mObservers) {
                    colorValueChangedCallback.valueChanged(bIC2.qhn(), bIC2.nrS(), bIC2.jpF());
                }
            }
        }
    }
}

