/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.controller.api.ColorValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class ColorValueProxy
extends ValueProxy
implements FhX,
ColorValue {
    private final bIC mDefaultColor;
    private float mRed;
    private float mGreen;
    private float mBlue;
    private float mAlpha;

    public ColorValueProxy(ControlSurfaceObject controlSurfaceObject, float f2, float f3, float f4, float f5) {
        super(controlSurfaceObject);
        this.mDefaultColor = new bIC(f2, f3, f4, f5);
        this.mRed = f2;
        this.mGreen = f3;
        this.mBlue = f4;
        this.mAlpha = f5;
    }

    public ColorValueProxy(ControlSurfaceObject controlSurfaceObject, float f2, float f3, float f4) {
        this(controlSurfaceObject, f2, f3, f4, 1.0f);
    }

    public ColorValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public Class getTargetType() {
        return HBA.class;
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    public void eventOccurred(sqC sqC2) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(this.isInterested()));
        assert (bqP.DVW(this.getTarget() != null));
        assert (bqP.DVW(Objects.equals(sqC2.DVW(), this.getTarget())));
        bIC bIC2 = (bIC)sqC2.gBO();
        this.queueNotifyObservers(bIC2.qhn(), bIC2.nrS(), bIC2.jpF(), bIC2.jJc());
    }

    @Override
    public float red() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRed;
    }

    @Override
    public float green() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mGreen;
    }

    @Override
    public float blue() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mBlue;
    }

    @Override
    public float alpha() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(5);
        this.checkCanGet();
        return this.mAlpha;
    }

    public void addValueObserver(ColorValueChangedCallback colorValueChangedCallback) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.doAddValueObserver(colorValueChangedCallback);
    }

    protected void sendDefaultValue(ColorValueChangedCallback colorValueChangedCallback) {
        colorValueChangedCallback.valueChanged(this.mDefaultColor.qhn(), this.mDefaultColor.nrS(), this.mDefaultColor.jpF());
    }

    protected void connectToTarget(HBA hBA) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(hBA != null));
        assert (bqP.DVW(this.isInterested()));
        assert (bqP.DVW(this.isActiveOnDocumentThread()));
        hBA.addListener(this);
        bIC bIC2 = (bIC)hBA.getValue();
        this.queueNotifyObservers(bIC2.qhn(), bIC2.nrS(), bIC2.jpF(), bIC2.jJc());
    }

    protected void disconnectFromTarget(HBA hBA) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(hBA != null));
        hBA.removeListener(this);
        this.queueNotifyObservers(this.mDefaultColor.qhn(), this.mDefaultColor.nrS(), this.mDefaultColor.jpF(), this.mDefaultColor.jJc());
    }

    private void queueNotifyObservers(float f2, float f3, float f4, float f5) {
        assert (bqP.DVW(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(f2, f3, f4, f5));
    }

    private void notifyObservers(float f2, float f3, float f4, float f5) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        assert (bqP.DVW(this.isInterested()));
        if (this.mRed != f2 || this.mGreen != f3 || this.mBlue != f4 || this.mAlpha != f5) {
            this.mRed = f2;
            this.mGreen = f3;
            this.mBlue = f4;
            this.mAlpha = f5;
            if (this.mObservers != null) {
                for (ColorValueChangedCallback colorValueChangedCallback : this.mObservers) {
                    colorValueChangedCallback.valueChanged(f2, f3, f4);
                }
            }
        }
    }

    public bIC getDefaultColor() {
        return this.mDefaultColor;
    }
}

