/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.prefs.Q3T;
import com.bitwig.ramona.core.z;

public class ColorSetting
extends SettableColorValueProxy
implements Setting {
    private final String mLabel;
    private final String mCategory;
    private hBV mIsEnabled;
    private hBV mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private z mSetting;

    public ColorSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, Color color) {
        super(controlSurfaceObject, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(VaF vaF) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(vaF != null));
        assert (bqP.DVW(this.mSetting == null));
        this.mSetting = vaF;
        this.setTarget(vaF.gBO());
        this.connectEnableAndVisibleValues(vaF.fJ1(), vaF.pxg());
    }

    public void disconnectFromSetting(VaF vaF) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(vaF != null));
        assert (bqP.DVW(this.mSetting == vaF));
        this.disconnectEnableAndVisibleValues(vaF.fJ1(), vaF.pxg());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(DwF dwF) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(dwF != null));
        assert (bqP.DVW(this.mSetting == null));
        this.mSetting = dwF;
        this.setTarget(dwF.fJ1());
        this.connectEnableAndVisibleValues(dwF.RXU(), dwF.qnY());
    }

    public void disconnectFromSetting(Q3T q3T) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(q3T != null));
        assert (bqP.DVW(this.mSetting == q3T));
        this.disconnectEnableAndVisibleValues(q3T.RXU(), q3T.qnY());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = hBV2;
        this.mIsVisible = hBV3;
    }

    private void disconnectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bqP.DVW(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public z getSetting() {
        return this.mSetting;
    }
}

