/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.prefs.JvR;
import com.bitwig.ramona.core.z;

public class BooleanSetting
extends SettableBooleanValueProxy
implements Setting {
    private final String mLabel;
    private final String mCategory;
    private hBV mIsEnabled;
    private hBV mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private z mSetting;

    public BooleanSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, boolean bl2) {
        super(controlSurfaceObject, bl2);
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(pKy pKy2) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(pKy2 != null));
        assert (bqP.DVW(this.mSetting == null));
        this.mSetting = pKy2;
        this.setTarget(pKy2.gBO());
        this.connectEnableAndVisibleValues(pKy2.fJ1(), pKy2.pxg());
    }

    public void disconnectFromSetting(pKy pKy2) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(pKy2 != null));
        assert (bqP.DVW(this.mSetting == pKy2));
        this.disconnectEnableAndVisibleValues(pKy2.fJ1(), pKy2.pxg());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(a3U a3U2) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(a3U2 != null));
        assert (bqP.DVW(this.mSetting == null));
        this.mSetting = a3U2;
        this.setTarget(a3U2.fJ1());
        this.connectEnableAndVisibleValues(a3U2.RXU(), a3U2.qnY());
    }

    public void disconnectFromSetting(JvR jvR) {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(jvR != null));
        assert (bqP.DVW(this.mSetting == jvR));
        this.disconnectEnableAndVisibleValues(jvR.RXU(), jvR.qnY());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = hBV2;
        this.mIsVisible = hBV3;
    }

    private void disconnectEnableAndVisibleValues(hBV hBV2, hBV hBV3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bqP.DVW(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public z getSetting() {
        return this.mSetting;
    }
}

