/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BeatTimeFormatter;
import com.bitwig.extension.controller.api.RelativeHardwarControlBindable;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlBinding;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableDoubleValueProxy;

public abstract class BeatTimeProxy
extends SettableDoubleValueProxy
implements VLU,
SettableBeatTimeValue {
    protected BeatTimeProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    public abstract boolean isBeatTimeAbsolute();

    @Override
    public RelativeHardwareControlBinding addBindingWithSensitivity(RelativeHardwareControl relativeHardwareControl, double d3) {
        return new BU2((aVi)relativeHardwareControl, this, d3);
    }

    @Override
    public RelativeHardwarControlBindable beatStepper() {
        return cPe.DVW(() -> this.doInc(1.0), () -> this.doInc(-1.0));
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.deprecated(1, 2, "Use addValueObserver instead");
        this.addValueObserver(doubleValueChangedCallback);
    }

    @Override
    public String getFormatted() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        BeatTimeFormatter beatTimeFormatter = this.getHost().defaultBeatTimeFormatter();
        assert (bqP.XHT(beatTimeFormatter != null));
        double d3 = this.get();
        return this.getFormattedValue(d3, beatTimeFormatter);
    }

    @Override
    public String getFormatted(BeatTimeFormatter beatTimeFormatter) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(beatTimeFormatter, "formatter");
        double d3 = this.get();
        return this.getFormattedValue(d3, beatTimeFormatter);
    }

    private String getFormattedValue(double d3, BeatTimeFormatter beatTimeFormatter) {
        BitwigStudioHost bitwigStudioHost = this.getHost();
        int n4 = bitwigStudioHost.getTimeSignatureNumerator().getControlSurfaceValue();
        int n5 = bitwigStudioHost.getTimeSignatureDenominator().getControlSurfaceValue();
        int n6 = bitwigStudioHost.getTimeSignatureTickRate().getControlSurfaceValue();
        String string = beatTimeFormatter.formatBeatTime(d3, this.isBeatTimeAbsolute(), n4, n5, n6);
        return string;
    }

    @Override
    public void addTimeObserver(String string, int n4, int n5, int n6, int n7, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use getFormatted() instead");
        this.checkIsInitializingDriver();
        this.notNull(stringValueChangedCallback, "callback");
        this.doMarkInterested();
        ysw ysw2 = new ysw(string, n4, n6, n5, n7);
        this.doAddValueObserver(d3 -> {
            String string = this.getFormattedValue(d3, ysw2);
            stringValueChangedCallback.valueChanged(string);
        });
    }
}

