/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy$IntegerScaledValueObserver;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.flt.control_surface.values.ValueProxy;
import com.bitwig.flt.prefs.ilP;
import com.bitwig.ramona.core.UMx;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;

public abstract class AbstractRangedValueProxy
extends ValueProxy
implements BAN,
SettableRangedValue {
    public static double TAKEOVER_THRESHOLD = 0.05;
    private double mRawValue;
    private double mNormalizedValue;
    private List mRawValueCallbacks;
    private List mIntegerScaledValueObservers;
    protected final ComputedStringValue mDisplayedValue = this.createDisplayedValue();
    private boolean mHasBeenCaught;
    private boolean mIsSettingValue;
    private double mLastSetNormalizedValue = -1.0;
    private OMs mValueChangedEventSource;
    private double mLastSetControllerValue = -1.0;
    private DoubleConsumer mNormalizedValueChangedListener;

    protected AbstractRangedValueProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public double getRaw() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRawValue;
    }

    @Override
    public double get() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mNormalizedValue;
    }

    @Override
    public StringValue displayedValue() {
        this.newSince(2);
        return this.mDisplayedValue;
    }

    public ComputedStringValue getDisplayedValue() {
        return this.mDisplayedValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (bqP.XHT(false));
        assert (bqP.XHT(this.isControlSurfaceThread()));
    }

    @Override
    public void addValueObserver(int n4, IntegerValueChangedCallback integerValueChangedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (n4 <= 1) {
            throw new FVt("Range must be > 1");
        }
        this.doMarkInterested();
        if (this.mIntegerScaledValueObservers == null) {
            this.mIntegerScaledValueObservers = new ArrayList(2);
        }
        this.mIntegerScaledValueObservers.add(new AbstractRangedValueProxy$IntegerScaledValueObserver(n4, integerValueChangedCallback));
    }

    @Override
    public final void set(Number number, Number number2) {
        double d3;
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (number == null || number2 == null) {
            throw new FVt("Cannot provide null for value or resolution");
        }
        double d4 = number.doubleValue();
        if (d4 > (d3 = number2.doubleValue()) - 1.0) {
            this.getControlSurface().gBO("Value must be <= range - 1. Setting value to range - 1");
        }
        if (d4 < 0.0) {
            this.getControlSurface().gBO("Value must be >= 0. Setting value to 0");
        }
        d4 = S1V.gBO(d4, 0.0, d3 - 1.0);
        assert (bqP.XHT(number != null));
        assert (bqP.XHT(number2 != null));
        double d5 = d3 >= 2.0 ? 1.0 / (d3 - 1.0) : 1.0;
        double d6 = d4 * d5;
        assert (bqP.XHT(d6 >= 0.0 && d6 <= 1.0));
        this.setNormalizedValue(d6, this.shouldSetImmediately());
    }

    @Override
    public final void set(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.inRange(d3, 0.0, 1.0, "value");
        this.setNormalizedValue(d3, this.shouldSetImmediately());
    }

    void updateHasBeenCaughtFromCurrentDistance() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.getTarget() != null) {
            this.mHasBeenCaught = this.mLastSetControllerValue == -1.0 ? false : AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(this.mLastSetControllerValue, this.getCurrentValue());
        }
    }

    private boolean shouldSetImmediately() {
        Y3Y y3Y = this.getControlSurface();
        if (y3Y.WCJ().MzI()) {
            return !y3Y.KAx().qnY();
        }
        return false;
    }

    @Override
    public void setImmediately(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.newSince(4);
        this.inRange(d3, 0.0, 1.0, "value");
        this.setNormalizedValue(d3, true);
    }

    private void setNormalizedValue(double d3, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(d3 >= 0.0 && d3 <= 1.0));
        this.postEvent(new hAw(this, d3, bl2, this.getTouchId()));
    }

    protected int getTouchId() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return 0;
    }

    public void doSetNormalizedValueWithTakeOver(double d3, ilP ilP2, cRY cRY2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(d3 >= 0.0 && d3 <= 1.0));
        assert (bqP.XHT(ilP2 != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            boolean bl2;
            boolean bl3 = this.mLastSetControllerValue != -1.0;
            double d4 = d3 - this.mLastSetControllerValue;
            this.mLastSetControllerValue = d3;
            boolean bl4 = bl2 = !rangedValueTarget.isContinuous();
            if (this.mHasBeenCaught || ilP2 == ilP.DVW || bl2) {
                this.doSetNormalizedValueImmediately(d3);
            } else if (ilP2 == ilP.XHT) {
                assert (bqP.gBO(!this.mHasBeenCaught));
                double d5 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                if (AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d5)) {
                    this.doSetNormalizedValueImmediately(d3);
                    return;
                }
                if (bl3) {
                    boolean bl5 = d4 > 0.0;
                    double d6 = bl5 ? 1.0 : 0.0;
                    double d7 = d3 - d6;
                    double d8 = d5 - d6;
                    if (Math.abs(d7) > 0.01) {
                        double d9 = d8 / d7;
                        this.doIncNormalized(d4 * d9);
                    }
                }
                if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            } else {
                assert (bqP.XHT(!this.mHasBeenCaught));
                assert (bqP.XHT(ilP2 != ilP.DVW));
                double d10 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                boolean bl6 = false;
                if (this.mLastSetNormalizedValue != -1.0) {
                    double d11 = cRY2 != null ? cRY2.fJ1(0) : d3;
                    bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(this.mLastSetNormalizedValue, d11, d10, ilP2);
                }
                if (!bl6 && cRY2 != null) {
                    for (int i2 = 0; !bl6 && i2 < cRY2.size() - 1; ++i2) {
                        double d12 = cRY2.fJ1(i2);
                        double d13 = cRY2.fJ1(i2 + 1);
                        bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d12, d13, d10, ilP2);
                    }
                    if (!bl6) {
                        double d14 = cRY2.fJ1(cRY2.size() - 1);
                        bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d14, d3, d10, ilP2);
                    }
                }
                if (!bl6 && cRY2 == null) {
                    bl6 = AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d10);
                }
                if (bl6) {
                    this.doSetNormalizedValueImmediately(d3);
                } else if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            }
        }
    }

    private static boolean shouldBeCaughtByMovement(double d3, double d4, double d5, ilP ilP2) {
        assert (bqP.XHT(d3 >= 0.0 && d3 <= 1.0));
        assert (bqP.XHT(d4 >= 0.0 && d4 <= 1.0));
        assert (bqP.XHT(d5 >= 0.0 && d5 <= 1.0));
        assert (bqP.XHT(ilP2 != null));
        double d6 = Math.min(d3, d4);
        double d7 = Math.max(d3, d4);
        if (d5 >= d6 && d5 <= d7) {
            return true;
        }
        return S1V.XHT(d5, Math.min(d3, d4), Math.max(d3, d4)) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d5) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d4, d5);
    }

    private static boolean isValueCloseEnoughForTakeOver(double d3, double d4) {
        return Math.abs(d3 - d4) <= TAKEOVER_THRESHOLD;
    }

    public void doSetNormalizedValueImmediately(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(d3 >= 0.0 && d3 <= 1.0));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            double d4 = this.normalizedValueToValue(d3);
            this.setCurrentValue(d4);
            this.mLastSetNormalizedValue = d3;
            this.mLastSetControllerValue = d3;
            this.mHasBeenCaught = true;
        }
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    @Override
    public final void inc(Number number, Number number2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (number == null) {
            throw new FVt("increment cannot be null");
        }
        if (number2 == null) {
            throw new FVt("range cannot be null");
        }
        if (number2.doubleValue() <= 1.0) {
            throw new FVt("range must be > 1");
        }
        double d3 = number.doubleValue() / (number2.doubleValue() - 1.0);
        this.incNormalized(d3);
    }

    @Override
    public void inc(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.inRange(d3, -1.0, 1.0, "increment");
        this.newSince(2);
        this.incNormalized(d3);
    }

    public void incNormalized(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(d3 >= -1.0 && d3 <= 1.0));
        this.postEvent(new hAw(this, d3, this.getTouchId()));
    }

    public boolean isMappable() {
        return false;
    }

    public boolean addManualMapping(mfT mfT2, boolean bl2, UMx uMx, AY3 aY3, String string) {
        assert (bqP.XHT(this.isMappable()));
        return false;
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(doubleValueChangedCallback, "callback");
        this.checkIsInitializingDriver();
        this.doMarkInterested();
        if (this.mRawValueCallbacks == null) {
            this.mRawValueCallbacks = new ArrayList(2);
        }
        this.mRawValueCallbacks.add(doubleValueChangedCallback);
    }

    @Override
    public void setRaw(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetRaw(d3));
    }

    private void doSetRaw(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(d3));
        }
    }

    @Override
    public void incRaw(double d3) {
        this.exec(() -> this.doIncRaw(d3));
    }

    private void doIncRaw(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(this.getCurrentValue() + d3));
        }
    }

    protected double validateRawValue(double d3) {
        return d3;
    }

    protected void connectToTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(rangedValueTarget != null));
        assert (bqP.XHT(this.mValueChangedEventSource == null));
        super.connectToTargetAlways(rangedValueTarget);
        this.mValueChangedEventSource = rangedValueTarget.getValueChangedEventSource();
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.addListener(this);
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void connectToTarget(RangedValueTarget rangedValueTarget) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(rangedValueTarget != null));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(this.isActiveOnDocumentThread()));
        rangedValueTarget.connected();
        this.targetValueChanged();
    }

    protected void disconnectFromTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(rangedValueTarget != null));
        super.disconnectFromTargetAlways(rangedValueTarget);
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.removeListener(this);
            this.mValueChangedEventSource = null;
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void disconnectFromTarget(RangedValueTarget rangedValueTarget) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(rangedValueTarget != null));
        rangedValueTarget.disconnected();
        this.queueNotifyObservers(0.0, 0.0);
        if (this.mDisplayedValue.isInterested()) {
            this.mDisplayedValue.unassign();
        }
    }

    @Override
    public void eventOccurred(Object object) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        this.targetValueChanged();
        if (!this.mIsSettingValue) {
            this.updateHasBeenCaughtFromCurrentDistance();
        }
    }

    private void targetValueChanged() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        double d3 = this.getCurrentValue();
        double d4 = this.valueToNormalizedValue(d3);
        if (this.isInterested()) {
            this.queueNotifyObserversRaw(d3, d4);
        }
        if (this.mDisplayedValue.isInterested()) {
            juj juj2 = this.createTruncatableString(d3);
            assert (bqP.XHT(juj2 != null));
            this.mDisplayedValue.setValue(juj2);
        }
        if (this.mNormalizedValueChangedListener != null) {
            this.mNormalizedValueChangedListener.accept(d4);
        }
    }

    protected ComputedStringValue createDisplayedValue() {
        return new ComputedStringValue(this);
    }

    protected juj createTruncatableString(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).createTruncatableStringForValue(d3);
    }

    protected double getCurrentValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).getCurrentValue();
    }

    protected void setCurrentValue(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(((RangedValueTarget)this.getTarget()).isSettable()));
        assert (bqP.XHT(!this.mIsSettingValue));
        this.beginSettingValue();
        ((RangedValueTarget)this.getTarget()).setCurrentValue(d3);
        this.endSettingValue();
    }

    protected double valueToNormalizedValue(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).valueToNormalizedValue(d3);
    }

    protected double normalizedValueToValue(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).normalizedValueToValue(d3);
    }

    public void doIncNormalized(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(!this.mIsSettingValue));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.beginSettingValue();
            rangedValueTarget.incrementNormalized(d3);
            this.endSettingValue();
        }
    }

    private void beginSettingValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(!this.mIsSettingValue));
        this.mIsSettingValue = true;
    }

    private void endSettingValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.mIsSettingValue));
        assert (bqP.XHT(this.getTarget() != null));
        assert (bqP.XHT(((RangedValueTarget)this.getTarget()).isSettable()));
        this.mIsSettingValue = false;
        if (((RangedValueTarget)this.getTarget()).shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    public void showVisualizations() {
        assert (bqP.XHT(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable() && rangedValueTarget.shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    private void doShowVisualizations() {
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(rangedValueTarget != null));
        assert (bqP.XHT(rangedValueTarget.isSettable()));
        assert (bqP.XHT(rangedValueTarget.shouldShowPopupNotifications()));
        this.getControlSurface().DVW(this);
    }

    private final void queueNotifyObserversRaw(double d3, double d4) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.isInterested()));
        this.queueNotifyObservers(d3, d4);
    }

    private void queueNotifyObservers(double d3, double d4) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(d4 >= 0.0 && d4 <= 1.0));
        assert (bqP.XHT(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(d3, d4));
    }

    private void notifyObservers(double d3, double d4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInterested()));
        assert (bqP.XHT(d4 >= 0.0 && d4 <= 1.0));
        double d5 = this.mRawValue;
        double d6 = this.mNormalizedValue;
        this.mRawValue = d3;
        this.mNormalizedValue = d4;
        if (d4 != d6) {
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(d4);
                }
            }
            if (this.mIntegerScaledValueObservers != null) {
                for (Object object : this.mIntegerScaledValueObservers) {
                    IntegerValueChangedCallback integerValueChangedCallback = ((AbstractRangedValueProxy$IntegerScaledValueObserver)object).mCallback;
                    int n4 = ((AbstractRangedValueProxy$IntegerScaledValueObserver)object).mRange;
                    int n5 = S1V.DVW(Math.round((float)d4 * (float)n4 - 0.5f), 0, n4 - 1);
                    integerValueChangedCallback.valueChanged(n5);
                }
            }
        }
        if (d3 != d5 && this.mRawValueCallbacks != null) {
            for (Object object : this.mRawValueCallbacks) {
                object.valueChanged(d3);
            }
        }
    }

    public void doTouch(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
    }

    public boolean hasBeenCaught() {
        assert (bqP.gBO(this.isDocumentThread()));
        return this.mHasBeenCaught;
    }

    public double getLastSetControllerValue() {
        return this.mLastSetControllerValue;
    }

    public void setControllerTakeOverState(double d3, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.mLastSetControllerValue = d3;
        this.mHasBeenCaught = bl2;
    }

    public void setNormalizedValueChangedListener(DoubleConsumer doubleConsumer) {
        assert (bqP.XHT(this.isInitializingDriver()));
        assert (bqP.XHT(doubleConsumer != null));
        assert (bqP.XHT(this.mNormalizedValueChangedListener == null));
        this.mNormalizedValueChangedListener = doubleConsumer;
    }
}

