/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Parameter;
import com.bitwig.extension.controller.api.UserControlBank;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;

public class UserControlBankObject
extends ControlSurfaceObject
implements UserControlBank {
    private final RemappableParameterProxy[] mControllers;

    public UserControlBankObject(ControlSurfaceObject controlSurfaceObject, int n4) {
        super(controlSurfaceObject);
        this.setKey("UserControl");
        if (n4 < 1) {
            throw new FVt("Size of user controls must be >= 1");
        }
        this.mControllers = new RemappableParameterProxy[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = this.getKey() + "/Control" + i2;
            RemappableParameterProxy remappableParameterProxy = new RemappableParameterProxy((ControlSurfaceObject)this, string);
            remappableParameterProxy.setIndexInGroup(i2);
            this.addChild(remappableParameterProxy);
            this.mControllers[i2] = remappableParameterProxy;
        }
    }

    @Override
    public Parameter getControl(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return (Parameter)this.returnArrayItem(this.mControllers, n4);
    }
}

