/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.UsbInterfaceMatcher;
import com.bitwig.extension.controller.api.UsbInterface;
import com.bitwig.extension.controller.api.UsbPipe;
import com.bitwig.flt.control_surface.proxy.UsbBulkInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbBulkOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbDeviceImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbPipeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UsbInterfaceImpl
implements UsbInterface {
    private final UsbDeviceImpl mDevice;
    private bJc mClaimedInterface;
    private final RkD mMatchResult;
    private final List mPipes;

    UsbInterfaceImpl(UsbDeviceImpl usbDeviceImpl, RkD rkD) {
        this.mDevice = usbDeviceImpl;
        this.mMatchResult = rkD;
        this.mPipes = new ArrayList(rkD.XHT().size());
        for (mRq mRq2 : rkD.XHT()) {
            UsbPipeImpl usbPipeImpl = UsbInterfaceImpl.createUsbPipe(usbDeviceImpl, mRq2);
            this.mPipes.add(usbPipeImpl);
        }
    }

    private static UsbPipeImpl createUsbPipe(UsbDeviceImpl usbDeviceImpl, mRq mRq2) {
        bJi bJi2 = mRq2.DVW().XHT();
        boolean bl2 = mRq2.DVW().hAB();
        switch (bJi2) {
            case XHT: {
                return bl2 ? new UsbBulkOutputPipeImpl(usbDeviceImpl, mRq2) : new UsbBulkInputPipeImpl(usbDeviceImpl, mRq2);
            }
            case hAB: {
                return bl2 ? new UsbInterruptOutputPipeImpl(usbDeviceImpl, mRq2) : new UsbInterruptInputPipeImpl(usbDeviceImpl, mRq2);
            }
        }
        throw new IllegalStateException("Unknown matcher transfer type " + bJi2);
    }

    @Override
    public UsbInterfaceMatcher interfaceMatcher() {
        return this.mMatchResult.gBO();
    }

    @Override
    public List pipes() {
        return Collections.unmodifiableList(this.mPipes);
    }

    @Override
    public UsbPipe pipe(int n4) {
        return (UsbPipe)this.mPipes.get(n4);
    }

    @Override
    public int pipeCount() {
        return this.mPipes.size();
    }

    void claim() {
        this.mClaimedInterface = this.mDevice.getDeviceHandle().gBO(this.mMatchResult.DVW().XHT);
    }

    void release() {
        if (this.mClaimedInterface != null) {
            this.mClaimedInterface.DVW();
            this.mClaimedInterface = null;
        }
    }
}

