/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.extension.controller.api.Settings;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.BooleanSetting;
import com.bitwig.flt.control_surface.values.ColorSetting;
import com.bitwig.flt.control_surface.values.EnumSetting;
import com.bitwig.flt.control_surface.values.NumberSetting;
import com.bitwig.flt.control_surface.values.SignalSetting;
import com.bitwig.flt.control_surface.values.StringSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SettingsProxy
extends ControlSurfaceDocumentProxy
implements Settings {
    protected final Map mSettings = new HashMap(32);
    protected final List mCategories = new ArrayList(4);
    private Map mInitialSettingValues;

    public SettingsProxy(ControlSurfaceObject controlSurfaceObject, String string, Map map) {
        super(controlSurfaceObject);
        this.setKey(string);
        this.mInitialSettingValues = map;
    }

    private void addSetting(Setting setting) {
        List<Setting> list;
        assert (bqP.XHT(setting != null));
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkCanAddSetting(setting.getLabel(), setting.getCategory());
        this.addChild((ControlSurfaceObject)((Object)setting));
        String string = setting.getCategory();
        if (!this.mCategories.contains(string)) {
            this.mCategories.add(string);
        }
        if (this.mSettings.containsKey(string)) {
            list = (List)this.mSettings.get(string);
        } else {
            list = new ArrayList(32);
            this.mSettings.put(string, list);
        }
        list.add(setting);
    }

    protected final int getSettingIndex(Setting setting) {
        return this.getSettings(setting.getCategory()).indexOf(setting);
    }

    public List getSettings(String string) {
        return (List)this.mSettings.get(string);
    }

    private void checkCanAddSetting(String string, String string2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (string == null || string.isEmpty()) {
            throw new FVt("Label must be provided for a setting");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new FVt("Category must be provided for a setting");
        }
        if (!this.getControlSurface().nrS()) {
            throw new FVt("Settings can only be added during script initialization");
        }
        List list = (List)this.mSettings.get(string2);
        if (list != null && list.stream().anyMatch(setting -> setting.getLabel().equals(string))) {
            throw new FVt("A setting with name " + string + " in category " + string2 + " has already been added");
        }
    }

    @Override
    public SignalSetting getSignalSetting(String string, String string2, String string3) {
        this.notEmpty(string, "label");
        SignalSetting signalSetting = new SignalSetting(this, string, string2, string3);
        this.addSetting(signalSetting);
        return signalSetting;
    }

    private Object getInitialValue(String string, String string2) {
        if (this.mInitialSettingValues == null) {
            return null;
        }
        Map map = (Map)this.mInitialSettingValues.get(string2);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public void finishedInitializing() {
        this.mInitialSettingValues = null;
    }

    @Override
    public NumberSetting getNumberSetting(String string, String string2, double d3, double d4, double d5, String string3, double d6) {
        double d7;
        this.notEmpty(string, "label");
        double d8 = d6;
        Object object = this.getInitialValue(string, string2);
        if (object instanceof Number && (d7 = ((Number)object).doubleValue()) >= d3 && d7 <= d4) {
            d8 = d7;
        }
        NumberSetting numberSetting = new NumberSetting(this, string, string2, d3, d4, d5, string3, d8);
        this.addSetting(numberSetting);
        return numberSetting;
    }

    @Override
    public EnumSetting getEnumSetting(String string, String string2, String[] stringArray, String string3) {
        this.notEmpty(string, "label");
        Object object = this.getInitialValue(string, string2);
        String string4 = string3;
        if (object instanceof String && Arrays.asList(stringArray).contains(object)) {
            string4 = (String)object;
        }
        EnumSetting enumSetting = new EnumSetting(this, string, string2, stringArray, string4);
        this.addSetting(enumSetting);
        return enumSetting;
    }

    @Override
    public StringSetting getStringSetting(String string, String string2, int n4, String string3) {
        this.notEmpty(string, "label");
        Object object = this.getInitialValue(string, string2);
        String string4 = string3;
        if (object instanceof String) {
            string4 = (String)object;
        }
        StringSetting stringSetting = new StringSetting(this, string, string2, string4);
        this.addSetting(stringSetting);
        return stringSetting;
    }

    @Override
    public SettableColorValue getColorSetting(String string, String string2, Color color) {
        Object object;
        this.newSince(5);
        this.notEmpty(string, "label");
        this.validColor(color, "initialColor");
        Color color2 = color;
        Object object2 = this.getInitialValue(string, string2);
        if (object2 instanceof bIC) {
            object = (bIC)object2;
            color2 = Color.fromRGBA(((bIC)object).qhn(), ((bIC)object).nrS(), ((bIC)object).jpF(), ((bIC)object).jJc());
        }
        object = new ColorSetting((ControlSurfaceObject)this, string, string2, color2);
        this.addSetting((Setting)object);
        return object;
    }

    @Override
    public SettableBooleanValue getBooleanSetting(String string, String string2, boolean bl2) {
        this.newSince(7);
        this.notEmpty(string, "label");
        Object object = this.getInitialValue(string, string2);
        boolean bl3 = bl2;
        if (object instanceof Boolean) {
            bl3 = (Boolean)object;
        }
        BooleanSetting booleanSetting = new BooleanSetting(this, string, string2, bl3);
        this.addSetting(booleanSetting);
        return booleanSetting;
    }
}

