/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.NoteStep$State;
import com.bitwig.flt.control_surface.proxy.ClipProxy;
import java.util.Objects;

final class NoteStep
implements com.bitwig.extension.controller.api.NoteStep {
    private final ClipProxy mClipProxy;
    private final int mX;
    private final int mY;
    private final int mChannel;
    private int mCachedNoteState;
    private boolean mCachedIsSelected;
    private double mCachedPan = 0.0;
    private double mCachedTimbre = 0.0;
    private double mCachedPressure = 0.0;
    private double mCachedGain = 0.0;
    private double mCachedVelocity = 0.0;
    private double mCachedReleaseVelocity = 0.0;
    private double mCachedDuration = 0.0;
    private double mCachedTranspose = 0.0;

    NoteStep(int n4, int n5, int n6, ClipProxy clipProxy) {
        this.mClipProxy = clipProxy;
        this.mX = n4;
        this.mY = n5;
        this.mChannel = n6;
    }

    void clear() {
        this.mCachedNoteState = 0;
        this.mCachedIsSelected = false;
        this.mCachedTranspose = 0.0;
        this.mCachedVelocity = 0.0;
        this.mCachedReleaseVelocity = 0.0;
        this.mCachedGain = 0.0;
        this.mCachedPan = 0.0;
        this.mCachedPressure = 0.0;
        this.mCachedTimbre = 0.0;
        this.mCachedDuration = 0.0;
    }

    void copy(NoteStep noteStep) {
        this.mCachedIsSelected = noteStep.mCachedIsSelected;
        this.mCachedPan = noteStep.mCachedPan;
        this.mCachedTimbre = noteStep.mCachedTimbre;
        this.mCachedPressure = noteStep.mCachedPressure;
        this.mCachedGain = noteStep.mCachedGain;
        this.mCachedVelocity = noteStep.mCachedVelocity;
        this.mCachedReleaseVelocity = noteStep.mCachedReleaseVelocity;
        this.mCachedDuration = noteStep.mCachedDuration;
        this.mCachedTranspose = noteStep.mCachedTranspose;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NoteStep noteStep = (NoteStep)object;
        return this.mX == noteStep.mX && this.mY == noteStep.mY && this.mChannel == noteStep.mChannel && this.mCachedNoteState == noteStep.mCachedNoteState && this.mCachedIsSelected == noteStep.mCachedIsSelected && Double.compare(noteStep.mCachedPan, this.mCachedPan) == 0 && Double.compare(noteStep.mCachedTimbre, this.mCachedTimbre) == 0 && Double.compare(noteStep.mCachedPressure, this.mCachedPressure) == 0 && Double.compare(noteStep.mCachedGain, this.mCachedGain) == 0 && Double.compare(noteStep.mCachedVelocity, this.mCachedVelocity) == 0 && Double.compare(noteStep.mCachedReleaseVelocity, this.mCachedReleaseVelocity) == 0 && Double.compare(noteStep.mCachedDuration, this.mCachedDuration) == 0 && Double.compare(noteStep.mCachedTranspose, this.mCachedTranspose) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.mX, this.mY, this.mChannel);
    }

    void setCachedNoteState(int n4) {
        NoteStep$State noteStep$State = NoteStep.convertState(n4);
        if (noteStep$State == NoteStep$State.Empty) {
            this.clear();
        }
        this.mCachedNoteState = n4;
    }

    void setCachedIsSelected(boolean bl2) {
        if (this.mCachedIsSelected != bl2) {
            this.mCachedIsSelected = bl2;
        }
    }

    void setCachedVelocity(double d3) {
        assert (bqP.DVW(d3 >= 0.0 && d3 <= 1.0));
        this.mCachedVelocity = d3;
    }

    void setCachedReleaseVelocity(double d3) {
        assert (bqP.DVW(d3 >= 0.0 && d3 <= 1.0));
        this.mCachedReleaseVelocity = d3;
    }

    void setCachedDuration(double d3) {
        this.mCachedDuration = d3;
    }

    void setCachedPan(double d3) {
        this.mCachedPan = d3;
    }

    void setCachedTranspose(double d3) {
        this.mCachedTranspose = d3;
    }

    void setCachedTimbre(double d3) {
        this.mCachedTimbre = d3;
    }

    void setCachedPressure(double d3) {
        this.mCachedPressure = d3;
    }

    void setCachedGain(double d3) {
        this.mCachedGain = d3;
    }

    @Override
    public int x() {
        return this.mX;
    }

    @Override
    public int y() {
        return this.mY;
    }

    @Override
    public int channel() {
        return this.mChannel;
    }

    @Override
    public NoteStep$State state() {
        return NoteStep.convertState(this.mCachedNoteState);
    }

    static NoteStep$State convertState(int n4) {
        switch (n4) {
            case 0: {
                return NoteStep$State.Empty;
            }
            case 1: {
                return NoteStep$State.NoteSustain;
            }
            case 2: {
                return NoteStep$State.NoteOn;
            }
        }
        return null;
    }

    @Override
    public double velocity() {
        return this.mCachedVelocity;
    }

    @Override
    public void setVelocity(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedVelocity == d3) {
            return;
        }
        this.mClipProxy.updateStepVelocity(this, d3);
        this.mCachedVelocity = d3;
    }

    @Override
    public double releaseVelocity() {
        return this.mCachedReleaseVelocity;
    }

    @Override
    public void setReleaseVelocity(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedReleaseVelocity == d3) {
            return;
        }
        this.mClipProxy.updateStepReleaseVelocity(this, d3);
        this.mCachedReleaseVelocity = d3;
    }

    @Override
    public double pan() {
        return this.mCachedPan;
    }

    @Override
    public void setPan(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedPan == d3) {
            return;
        }
        this.mClipProxy.updateStepPan(this, d3);
        this.mCachedPan = d3;
    }

    @Override
    public double timbre() {
        return this.mCachedTimbre;
    }

    @Override
    public void setTimbre(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedTimbre == d3) {
            return;
        }
        this.mClipProxy.updateStepTimbre(this, d3);
        this.mCachedTimbre = d3;
    }

    @Override
    public double pressure() {
        return this.mCachedPressure;
    }

    @Override
    public void setPressure(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedPressure == d3) {
            return;
        }
        this.mClipProxy.updateStepPressure(this, d3);
        this.mCachedPressure = d3;
    }

    @Override
    public double gain() {
        return this.mCachedGain;
    }

    @Override
    public void setGain(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedGain == d3) {
            return;
        }
        this.mClipProxy.updateStepGain(this, d3);
        this.mCachedGain = d3;
    }

    @Override
    public double transpose() {
        return this.mCachedTranspose;
    }

    @Override
    public void setTranspose(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedTranspose == d3) {
            return;
        }
        this.mClipProxy.updateStepTranspose(this, d3);
        this.mCachedTranspose = d3;
    }

    @Override
    public double duration() {
        return this.mCachedDuration;
    }

    @Override
    public void setDuration(double d3) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedDuration == d3) {
            return;
        }
        this.mClipProxy.updateStepDuration(this, d3);
        this.mCachedDuration = d3;
    }

    @Override
    public boolean isIsSelected() {
        return this.mCachedIsSelected;
    }

    int noteState() {
        return this.mCachedNoteState;
    }

    boolean checkBounds(int n4, int n5) {
        return this.mX >= 0 && this.mY >= 0 && this.mChannel >= 0 && this.mX < n4 && this.mY < n5 && this.mChannel < 16;
    }
}

