/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.ShortMidiDataReceivedCallback;
import com.bitwig.extension.callback.SysexMidiDataReceivedCallback;
import com.bitwig.extension.controller.api.AbsoluteHardwareValueMatcher;
import com.bitwig.extension.controller.api.HardwareActionMatcher;
import com.bitwig.extension.controller.api.MidiExpressions;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.RelativeHardwareValueMatcher;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import java.io.IOException;

public class MidiInPort
extends ControlSurfaceObject
implements MidiIn {
    private final int mIndex;

    public MidiInPort(ControlSurfaceObject controlSurfaceObject, int n4) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.DRIVER_SETUP);
        this.mIndex = n4;
    }

    @Override
    public void setMidiCallback(ShortMidiDataReceivedCallback shortMidiDataReceivedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.getControlSurface().DVW(this.mIndex, shortMidiDataReceivedCallback);
    }

    @Override
    public void setSysexCallback(SysexMidiDataReceivedCallback sysexMidiDataReceivedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.getControlSurface().DVW(this.mIndex, sysexMidiDataReceivedCallback);
    }

    @Override
    public NoteInput createNoteInput(String string, String ... stringArray) {
        String[] stringArray2 = new String[]{"8?????", "9?????", "B?01??", "B?0B??", "B?40??", "D?????", "E?????"};
        try {
            if (stringArray.length == 0) {
                return this.getControlSurface().DVW(this.getHost(), this.mIndex, string, stringArray2);
            }
            return this.getControlSurface().DVW(this.getHost(), this.mIndex, string, stringArray);
        }
        catch (IOException iOException) {
            throw new tDy("Could not create note input", iOException);
        }
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsolutePitchBendValueMatcher(int n4) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPitchBendExpression(n4), "data2 << 7 | data1", 14);
    }

    @Override
    public AbsoluteHardwareValueMatcher createSequencedValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher2, boolean bl2) {
        this.checkMatcherIsForThisMidiIn("firstValueMatcher", absoluteHardwareValueMatcher);
        this.checkMatcherIsForThisMidiIn("secondValueMatcher", absoluteHardwareValueMatcher2);
        return new wUZ((PyI)((Object)absoluteHardwareValueMatcher), (PyI)((Object)absoluteHardwareValueMatcher2), bl2);
    }

    @Override
    public yYj createAbsoluteValueMatcher(String string, String string2, int n4) {
        return new yYj(this.createActionMatcher(string), this.parseExpression(string2), n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeValueMatcher(String string, double d3) {
        return new dXw(this, this.parseExpression(string), d3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(String string, String string2, int n4, int n5) {
        return this.createRelativeSignedBitValueMatcher(this.createAbsoluteValueMatcher(string, string2, n4), n5);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n4) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new HuH((PyI)((Object)absoluteHardwareValueMatcher), n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(String string, String string2, int n4, int n5) {
        return this.createRelativeSignedBit2ValueMatcher(this.createAbsoluteValueMatcher(string, string2, n4), n5);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n4) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new ya((PyI)((Object)absoluteHardwareValueMatcher), n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(String string, String string2, int n4, int n5) {
        return this.createRelativeBinOffsetValueMatcher(this.createAbsoluteValueMatcher(string, string2, n4), n5);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n4) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new kcm((PyI)((Object)absoluteHardwareValueMatcher), n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(String string, String string2, int n4, int n5) {
        return this.createRelative2sComplementValueMatcher(this.createAbsoluteValueMatcher(string, string2, n4), n5);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n4) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new PGy((PyI)((Object)absoluteHardwareValueMatcher), n4);
    }

    @Override
    public yT3 createActionMatcher(String string) {
        return new yT3(this, this.parseExpression(string));
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n4, int n5, int n6) {
        return this.createActionMatcher(this.midiExpressions().createIsCCValueExpression(n4, n5, n6));
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n4, int n5) {
        return this.createActionMatcher(this.midiExpressions().createIsCCExpression(n4, n5));
    }

    @Override
    public HardwareActionMatcher createNoteOnActionMatcher(int n4, int n5) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOnExpression(n4, n5));
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOnVelocityValueMatcher(int n4, int n5) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOnExpression(n4, n5), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOffVelocityValueMatcher(int n4, int n5) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOffExpression(n4, n5), "data2", 7);
    }

    @Override
    public HardwareActionMatcher createNoteOffActionMatcher(int n4, int n5) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOffExpression(n4, n5));
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n4, int n5) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n4, n5), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createPolyAftertouchValueMatcher(int n4, int n5) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPolyAftertouch(n4, n5), "data2", 7);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitCCValueMatcher(int n4, int n5, int n6) {
        return this.createRelativeSignedBitValueMatcher(this.midiExpressions().createIsCCExpression(n4, n5), "data2", 7, n6);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2CCValueMatcher(int n4, int n5, int n6) {
        return this.createRelativeSignedBit2ValueMatcher(this.midiExpressions().createIsCCExpression(n4, n5), "data2", 7, n6);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetCCValueMatcher(int n4, int n5, int n6) {
        return this.createRelativeBinOffsetValueMatcher(this.midiExpressions().createIsCCExpression(n4, n5), "data2", 7, n6);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementCCValueMatcher(int n4, int n5, int n6) {
        return this.createRelative2sComplementValueMatcher(this.midiExpressions().createIsCCExpression(n4, n5), "data2", 7, n6);
    }

    private kio parseExpression(String string) {
        try {
            return kio.gBO(string);
        }
        catch (wga wga2) {
            throw new FVt("Invalid MIDI event expression", wga2);
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public BOs getMidiReceiver() {
        return (BOs)this.getControlSurface().ypE().get(this.mIndex);
    }

    private MidiExpressions midiExpressions() {
        return this.getHost().midiExpressions();
    }

    private void checkMatcherIsForThisMidiIn(String string, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher) {
        if (!(absoluteHardwareValueMatcher instanceof kpB)) {
            throw new FVt(string + " is not a MIDI value matcher for this MidiIn");
        }
        if (((kpB)absoluteHardwareValueMatcher).hAB() != this) {
            throw new FVt(string + " is not a MIDI value matcher for this MidiIn");
        }
    }
}

