/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

class MIDIEventFilter {
    private int mCheckMask;
    private int mMatchMask;

    MIDIEventFilter(String string) {
        if (string.length() != 6) {
            throw new FVt("Invalid filter");
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = i2 / 2;
            int n5 = i2 & 1;
            int n6 = n4 * 8 + (1 - n5) * 4;
            if (c2 == '?') continue;
            this.mCheckMask |= 15 << n6;
            int n7 = Integer.parseInt(String.valueOf(c2), 16);
            this.mMatchMask |= (n7 & 0xF) << n6;
        }
    }

    public boolean matches(int n4) {
        return ((n4 ^ this.mMatchMask) & this.mCheckMask) == 0;
    }

    int getCheckMask() {
        return this.mCheckMask;
    }

    int getMatchMask() {
        return this.mMatchMask;
    }

    public boolean isMatchAll() {
        return this.mCheckMask == 0;
    }
}

