/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.flt.app.FnS;
import com.bitwig.flt.control_surface.proxy.ListToFixedSizeWindowValue$ChangeListener;
import java.util.ArrayList;
import java.util.List;

public class ListToFixedSizeWindowValue
extends cJK {
    private final ArrayList mSlaves;
    private final xz3 mCanScrollUp;
    private final xz3 mCanScrollDown;
    private final xz3 mCanScrollPageUp;
    private final xz3 mCanScrollPageDown;
    private final jpE mWindowOffset;
    private final jpE mListItemCount;
    private final int mWindowSize;
    private final dIf mList;
    private List mCurrentWindow;
    private final ListToFixedSizeWindowValue$ChangeListener mListener;
    private boolean mHasBeenDisposed;
    private int mPageAlignment;
    private boolean mHasInvalidatedWindow;

    public ListToFixedSizeWindowValue(int n4, dIf dIf2, ListToFixedSizeWindowValue$ChangeListener listToFixedSizeWindowValue$ChangeListener) {
        super(true);
        assert (bqP.gBO(n4 > 0));
        this.mWindowSize = n4;
        this.mList = dIf2;
        this.mListener = listToFixedSizeWindowValue$ChangeListener;
        this.mWindowOffset = new jpE(0);
        this.mListItemCount = new jpE(0);
        this.mSlaves = new ArrayList(3);
        this.mCanScrollUp = new xz3(false);
        this.mCanScrollDown = new xz3(false);
        this.mCanScrollPageUp = new xz3(false);
        this.mCanScrollPageDown = new xz3(false);
        this.addSource(this.mList);
    }

    public void addSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.add(listToFixedSizeWindowValue);
        listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), true, false);
    }

    public void removeSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.remove(listToFixedSizeWindowValue);
    }

    private void invalidateWindow() {
        if (!this.mHasInvalidatedWindow) {
            this.mHasInvalidatedWindow = true;
            FnS.j_().hAB(() -> {
                this.updateWindow();
                this.mHasInvalidatedWindow = false;
            });
        }
    }

    private void updateWindow() {
        int n4;
        int n5;
        if (this.mHasBeenDisposed || this.mWindowSize == 0) {
            return;
        }
        List list = this.mCurrentWindow;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.mWindowSize);
        int n6 = this.mList.gBO();
        for (n5 = 0; n5 < this.mWindowSize; ++n5) {
            n4 = this.mWindowOffset.getValue() + n5;
            if (n4 < n6) {
                arrayList.add(this.mList.gBO(n4));
                continue;
            }
            arrayList.add(null);
        }
        n5 = this.mCurrentWindow == null ? 1 : 0;
        this.mCurrentWindow = arrayList;
        if (n5 != 0) {
            n4 = 0;
            for (Object e2 : arrayList) {
                this.mListener.onAssign(n4++, null, e2);
            }
        } else {
            for (n4 = 0; n4 < this.mWindowSize; ++n4) {
                if (arrayList.get(n4) == list.get(n4)) continue;
                this.mListener.onAssign(n4, list.get(n4), arrayList.get(n4));
            }
        }
        this.mListItemCount.setValue(n6);
        this.updateScrollableStatus();
    }

    public xz3 getCanScrollDown() {
        return this.mCanScrollDown;
    }

    public xz3 getCanScrollUp() {
        return this.mCanScrollUp;
    }

    public xz3 getCanScrollPageDown() {
        return this.mCanScrollPageDown;
    }

    public xz3 getCanScrollPageUp() {
        return this.mCanScrollPageUp;
    }

    private void updateScrollableStatus() {
        int n4 = this.mList.gBO();
        this.mCanScrollUp.DVW(this.mWindowOffset.getValue() > 0);
        this.mCanScrollDown.DVW(this.mWindowOffset.getValue() < n4 - this.mWindowSize);
        this.mCanScrollPageUp.DVW(this.mWindowOffset.getValue() > 0);
        int n5 = (n4 - 1) / this.mWindowSize * this.mWindowSize;
        this.mCanScrollPageDown.DVW(this.mWindowOffset.getValue() < n5);
    }

    public void dispose() {
        assert (bqP.lTJ(!this.mHasBeenDisposed));
        this.removeSource(this.mList);
        this.mHasBeenDisposed = true;
    }

    public void shiftWindow(int n4) {
        this.shiftWindow(n4, false);
    }

    public void shiftWindow(int n4, boolean bl2) {
        this.scrollToOffset(this.mWindowOffset.getValue() + n4, bl2, false);
    }

    public void shiftWindowPage(int n4) {
        int n5 = this.mWindowOffset.getValue() + n4 * this.mWindowSize;
        this.scrollToOffset(n5, true, true);
    }

    public void scrollTo(int n4) {
        this.scrollToOffset(n4, false, true);
    }

    public void scrollToOffset(int n4, boolean bl2, boolean bl3) {
        int n5;
        int n6 = bl3 ? this.quantizePosition(n4) : (n5 = Math.max(0, Math.min(n4, this.mList.gBO() - (bl2 ? 1 : this.mWindowSize))));
        if (this.mWindowOffset.getValue() != n5) {
            this.mWindowOffset.setValue(n5);
            this.updateWindow();
            for (ListToFixedSizeWindowValue listToFixedSizeWindowValue : this.mSlaves) {
                listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), bl2, false);
            }
        }
    }

    protected int quantizePosition(int n4) {
        int n5 = this.mPageAlignment % this.mWindowSize;
        int n6 = (n4 - n5) / this.mWindowSize * this.mWindowSize + n5;
        if (n6 < this.mWindowOffset.getValue() - this.mWindowSize) {
            n6 += this.mWindowSize;
        }
        int n7 = (this.mList.gBO() - 1) / this.mWindowSize * this.mWindowSize;
        return S1V.DVW(n6, 0, n7);
    }

    @Override
    public void changedItems(dIf dIf2, int n4, int n5) {
        this.invalidateWindow();
    }

    @Override
    public void addedAsListenerTo(dIf dIf2) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(dIf dIf2) {
        for (int i2 = 0; i2 < this.mWindowSize; ++i2) {
            if (this.mCurrentWindow == null || this.mCurrentWindow.get(i2) == null) continue;
            this.mListener.onAssign(i2, this.mCurrentWindow.get(i2), null);
        }
        this.mListItemCount.setValue(0);
        this.updateScrollableStatus();
    }

    @Override
    public void insertedItems(dIf dIf2, int n4, int n5) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveItems(dIf dIf2, int n4, int n5) {
        this.invalidateWindow();
    }

    @Override
    protected void insertedItem(dIf dIf2, Object object, int n4) {
        this.invalidateWindow();
    }

    @Override
    protected void aboutToRemoveItem(dIf dIf2, Object object, int n4) {
        this.invalidateWindow();
    }

    public dIf getList() {
        return this.mList;
    }

    public txN getPosition() {
        return this.mWindowOffset;
    }

    public txN getListItemCount() {
        return this.mListItemCount;
    }

    public int getPageAlignment() {
        return this.mPageAlignment;
    }

    public void setPageAlignment(int n4) {
        this.mPageAlignment = n4;
    }
}

