/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.document.core.iface.oTe;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private final boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;
    private final BooleanValueProxy mHasMutedPads;
    private final BooleanValueProxy mHasSoloedPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n4, int n5) {
        super(controlSurfaceObject, "DrumPadBank-" + n4, n4, n5);
        if (n4 < 1) {
            throw new FVt("At least 1 track is required.");
        }
        this.mNumLanes = n4;
        this.mPads = new ArrayList(n4);
        this.mChannelScrollStepSize = 4;
        this.mHasMutedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.mHasSoloedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n5, true);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return e3h.class;
    }

    protected oTe getDocumentFromTarget(e3h e3h2) {
        return e3h2.fpB();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n4, int n5, String string) {
        return new DrumPadProxy(this, string + n5, n5, n4, true);
    }

    protected dIf getChannelsListValueFromTarget(e3h e3h2) {
        return e3h2.lTJ();
    }

    protected void connectToTarget(e3h e3h2) {
        int n4 = Integer.MAX_VALUE;
        int n5 = -1;
        for (NNc nNc : e3h2.iRw()) {
            int n6 = nNc.Fzm().nrS();
            n4 = Math.min(n6, n4);
            n5 = Math.max(n6, n5);
        }
        int n7 = this.mChannelBankUpdater.getScrollPositionValue();
        if (n5 >= 0 && (n7 < n4 || n7 > n5)) {
            int n8 = n4 / 4;
            this.mChannelBankUpdater.doScrollTo(4 * n8, true);
        } else {
            this.mChannelBankUpdater.doScrollTo(36, true);
        }
        this.mHasMutedPads.setTarget(e3h2.zRa());
        this.mHasSoloedPads.setTarget(e3h2.mVN());
    }

    protected void disconnectFromTarget(e3h e3h2) {
        this.mHasMutedPads.clearTarget();
        this.mHasSoloedPads.clearTarget();
    }

    @Override
    public void clearMutedPads() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearMute);
    }

    private void doClearMute() {
        assert (bqP.DVW(this.isDocumentThread()));
        e3h e3h2 = (e3h)this.getTarget();
        if (e3h2 == null) {
            return;
        }
        e3h2.OMN();
    }

    @Override
    public void clearSoloedPads() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearSolo);
    }

    private void doClearSolo() {
        assert (bqP.DVW(this.isDocumentThread()));
        e3h e3h2 = (e3h)this.getTarget();
        if (e3h2 == null) {
            return;
        }
        e3h2.aHh();
    }

    @Override
    public BooleanValue hasMutedPads() {
        this.newSince(10);
        return this.mHasMutedPads;
    }

    @Override
    public BooleanValue hasSoloedPads() {
        this.newSince(10);
        return this.mHasSoloedPads;
    }
}

