/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Arpeggiator;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.NoteInput$NoteExpression;
import com.bitwig.extension.controller.api.NoteLatch;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.flt.control_surface.proxy.ArpeggiatorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.MIDIEventFilter;
import com.bitwig.flt.control_surface.proxy.NoteLatchProxy;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToDisposeOnControlSurfaceThread;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.document.core.iface.oTe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DirectNoteInput
extends ControlSurfaceObject
implements NoteInput,
ObjectThatWantsToDisposeOnControlSurfaceThread {
    private int mEngineNoteInputId;
    private final List mFilters;
    private final String mName;
    private final int mPort;
    private final ArpeggiatorProxy mArpeggiatorProxy;
    private final NoteLatchProxy mNoteLatchProxy;
    private jIH mNoteSource;
    private final SettableBooleanValueProxy mIncludeInAllInputs;

    public DirectNoteInput(ControlSurfaceObject controlSurfaceObject, int n4, String string, String[] stringArray, boolean bl2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.INIT);
        this.mPort = n4;
        this.mName = string;
        this.mEngineNoteInputId = this.getMidiReceiver().DVW(bl2);
        this.mIncludeInAllInputs = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mNoteLatchProxy = new NoteLatchProxy(this);
        this.mArpeggiatorProxy = new ArpeggiatorProxy(this);
        this.mFilters = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            try {
                MIDIEventFilter mIDIEventFilter = new MIDIEventFilter(string2);
                this.mFilters.add(mIDIEventFilter);
            }
            catch (FVt fVt) {
                bqP.DVW.hAB("Could not parse note input mask", fVt);
            }
        }
        this.sendNoteInputMasks();
    }

    public int getEngineNoteInputId() {
        return this.mEngineNoteInputId;
    }

    @Override
    public void disposeOnControlSurfaceThread() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        try {
            assert (bqP.gBO(this.mEngineNoteInputId >= 0));
            this.getMidiReceiver().DVW(this.mEngineNoteInputId);
            this.mEngineNoteInputId = -1;
        }
        catch (IOException iOException) {
            bqP.DVW.DVW(iOException);
        }
    }

    private void sendNoteInputMasks() {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        int n4 = this.mFilters.size();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int n5 = 0;
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            nArray[n5] = mIDIEventFilter.getCheckMask();
            nArray2[n5] = mIDIEventFilter.getMatchMask();
            ++n5;
        }
        this.getMidiReceiver().DVW(this.mEngineNoteInputId, nArray, nArray2);
    }

    private void sendKeyMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (bqP.XHT(byArray.length == 128));
        this.getMidiReceiver().DVW(this.mEngineNoteInputId, byArray);
    }

    private void sendVelocityMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (bqP.XHT(byArray.length == 128));
        this.getMidiReceiver().gBO(this.mEngineNoteInputId, byArray);
    }

    private BOs getMidiReceiver() {
        return (BOs)this.getControlSurface().ypE().get(this.mPort);
    }

    public int getPort() {
        return this.mPort;
    }

    @Override
    public void setShouldConsumeEvents(boolean bl2) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiReceiver().DVW(this.mEngineNoteInputId, bl2);
        }
        catch (IOException iOException) {
            throw new tDy(iOException);
        }
    }

    private byte[] convertJavaScriptArrayToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof Number)) {
                throw new FVt("Object in array not instance of Number");
            }
            Number number = (Number)objectArray[i2];
            if (number.intValue() < -128 || number.intValue() > 127) {
                throw new FVt("Value out of range");
            }
            byArray[i2] = number.byteValue();
        }
        return byArray;
    }

    @Override
    public void setKeyTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new FVt("Map must have a length of 128");
        }
        try {
            this.sendKeyMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new tDy(iOException);
        }
    }

    @Override
    public void setVelocityTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new FVt("Map must have a length of 128");
        }
        try {
            this.sendVelocityMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new tDy(iOException);
        }
    }

    @Override
    public void assignPolyphonicAftertouchToExpression(int n4, NoteInput$NoteExpression noteInput$NoteExpression, int n5) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiReceiver().DVW(this.mEngineNoteInputId, n4, noteInput$NoteExpression, n5);
        }
        catch (IOException iOException) {
            throw new tDy(iOException);
        }
    }

    @Override
    public void setUseExpressiveMidi(boolean bl2, int n4, int n5) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n4 != 0 && n4 != 15) {
            throw new FVt("baseChannel must be either 0 or 15");
        }
        if (n5 < 0 || n5 > 96) {
            throw new FVt("pitchBendRange must be between 0 or 96");
        }
        try {
            this.getMidiReceiver().DVW(this.mEngineNoteInputId, bl2, n4, n5);
        }
        catch (IOException iOException) {
            throw new tDy(iOException);
        }
    }

    @Override
    public void setUseMultidimensionalPolyphonicExpression(boolean bl2, int n4) {
        this.deprecated(1, 2);
        this.setUseExpressiveMidi(bl2, n4, 48);
    }

    @Override
    public void sendRawMidiEvent(int n4, int n5, int n6) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n4 < 128 || n4 > 255) {
            throw new FVt("Status byte out of range");
        }
        if (n5 < 0 || n5 > 127) {
            throw new FVt("data0 byte out of range");
        }
        if (n6 < 0 || n6 > 127) {
            throw new FVt("data1 byte out of range");
        }
        try {
            this.getMidiReceiver().DVW(this.mEngineNoteInputId, n4, n5, n6);
        }
        catch (IOException iOException) {
            throw new tDy(iOException);
        }
    }

    @Override
    public NoteLatch noteLatch() {
        this.newSince(10);
        return this.mNoteLatchProxy;
    }

    public boolean isMatchAll() {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.isMatchAll()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public Arpeggiator arpeggiator() {
        this.newSince(10);
        return this.mArpeggiatorProxy;
    }

    public void connectToDocument(oTe oTe2) {
        assert (bqP.XHT(this.mNoteSource == null));
        this.mNoteSource = oTe2.DVW(this.mEngineNoteInputId);
        this.mIncludeInAllInputs.setTarget(this.mNoteSource.nrS());
        this.mNoteLatchProxy.setTarget(this.mNoteSource.lTJ());
        this.mArpeggiatorProxy.setTarget(this.mNoteSource.iy_());
    }

    public void disconnectFromDocument() {
        assert (bqP.XHT(this.mNoteSource != null));
        this.mNoteLatchProxy.clearTarget();
        this.mArpeggiatorProxy.clearTarget();
        this.mIncludeInAllInputs.clearTarget();
        this.mNoteSource = null;
    }

    jIH getNoteSource() {
        return this.mNoteSource;
    }

    @Override
    public SettableBooleanValue includeInAllInputs() {
        this.newSince(10);
        return this.mIncludeInAllInputs;
    }
}

