/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.CursorDeviceFollowMode;
import com.bitwig.extension.controller.api.CursorNavigationMode;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.PinnableCursorClip;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlBinding;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.flt.control_surface.proxy.ClipProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceTrackCursorProxy;
import com.bitwig.flt.control_surface.proxy.CursorTrackCursorClipProxy;
import com.bitwig.flt.control_surface.proxy.CursorTrackCursorDeviceProxy;
import com.bitwig.flt.control_surface.proxy.DelegatingControlSurfaceObjectProxy;
import com.bitwig.flt.control_surface.proxy.DelegatingTrackProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.document.core.iface.Rfh;
import com.bitwig.flt.document.core.iface.oTe;
import java.util.ArrayList;
import java.util.List;

public class CursorTrackProxy
extends DelegatingTrackProxy
implements CursorTrack {
    private static final String DEFAULT_CURSOR_DEVICE_ID = "DeviceSelection";
    private static final String DEFAULT_CURSOR_DEVICE_NAME = "Main Device";
    private static final String DEFAULT_LAUNCHER_CURSOR_CLIP_ID = "LauncherClip";
    private static final String DEFAULT_LAUNCHER_CURSOR_CLIP_NAME = "Launcher Clip";
    private final String mCursorId;
    private final String mName;
    private final int mNumSends;
    private final int mNumScenes;
    private final boolean mShouldFollowSelection;
    private final ControlSurfaceTrackCursorProxy mCursorProxy;
    private final List mCursorDevices = new ArrayList(2);
    private final List mCursorClips = new ArrayList(2);
    private PinnableCursorDevice mPrimaryDevice;

    protected CursorTrackProxy(ControlSurfaceObject controlSurfaceObject, String string, String string2, int n4, int n5, boolean bl2) {
        super(controlSurfaceObject, new TrackProxy(controlSurfaceObject, string, -1, n4, n5));
        this.mCursorId = string;
        this.mName = string2;
        this.mNumSends = n4;
        this.mNumScenes = n5;
        this.mShouldFollowSelection = bl2;
        this.mCursorProxy = new ControlSurfaceTrackCursorProxy((ControlSurfaceObject)this, string, string2, this.getDelegateProxy());
    }

    public String getCursorId() {
        return this.mCursorId;
    }

    public int getNumSends() {
        return this.mNumSends;
    }

    public int getNumScenes() {
        return this.mNumScenes;
    }

    @Override
    public TrackProxy getDelegateProxy() {
        return (TrackProxy)super.getDelegateProxy();
    }

    public ControlSurfaceTrackCursorProxy getCursorProxy() {
        return this.mCursorProxy;
    }

    @Override
    public Class getTargetType() {
        return oTe.class;
    }

    @Override
    public RelativeHardwareControlBinding addBindingWithSensitivity(RelativeHardwareControl relativeHardwareControl, double d3) {
        return this.mCursorProxy.addBindingWithSensitivity(relativeHardwareControl, d3);
    }

    @Override
    public HardwareActionBindable selectNextAction() {
        return this.mCursorProxy.selectNextAction();
    }

    @Override
    public HardwareActionBindable selectPreviousAction() {
        return this.mCursorProxy.selectPreviousAction();
    }

    @Override
    public SettableBooleanValue isPinned() {
        return this.mCursorProxy.isPinned();
    }

    @Override
    public void selectPrevious() {
        this.mCursorProxy.selectPrevious();
    }

    @Override
    public void selectNext() {
        this.mCursorProxy.selectNext();
    }

    @Override
    public void selectFirst() {
        this.mCursorProxy.selectFirst();
    }

    @Override
    public void selectLast() {
        this.mCursorProxy.selectLast();
    }

    @Override
    public BooleanValue hasNext() {
        return this.mCursorProxy.hasNext();
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mCursorProxy.hasPrevious();
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mCursorProxy.addCanSelectPreviousObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mCursorProxy.addCanSelectNextObserver(booleanValueChangedCallback);
    }

    @Override
    public void selectChannel(Channel channel) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(channel, "channel");
        assert (bqP.XHT(channel instanceof ControlSurfaceProxy));
        this.exec(() -> this.doSelect(channel));
    }

    private void doSelect(Channel channel) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(channel != null));
        assert (bqP.XHT(channel instanceof ControlSurfaceProxy));
        Rfh rfh = (Rfh)((ControlSurfaceProxy)((Object)channel)).getTargetOfType(Rfh.class);
        if (rfh != null) {
            this.mCursorProxy.doSelect(rfh);
        }
    }

    @Override
    public void selectParent() {
        this.mCursorProxy.selectParent();
    }

    @Override
    public void selectFirstChild() {
        this.mCursorProxy.selectFirstChild();
    }

    @Override
    public void setCursorNavigationMode(CursorNavigationMode cursorNavigationMode) {
        this.deprecated(1, 2, "Make a TrackBank follow this cursor instead");
    }

    protected void connectToTarget(oTe oTe2) {
        zx3 zx32 = this.getControlSurfaceState();
        Pvn pvn = zx32.DVW(this.mCursorId, this.mName, this.mShouldFollowSelection);
        assert (bqP.XHT(pvn != null));
        this.mCursorProxy.setTarget(pvn);
        for (DelegatingControlSurfaceObjectProxy delegatingControlSurfaceObjectProxy : this.mCursorDevices) {
            delegatingControlSurfaceObjectProxy.setTarget(pvn);
        }
        for (DelegatingControlSurfaceObjectProxy delegatingControlSurfaceObjectProxy : this.mCursorClips) {
            delegatingControlSurfaceObjectProxy.setTarget(pvn);
        }
    }

    protected void disconnectFromTarget(oTe oTe2) {
        this.mCursorProxy.clearTarget();
        for (DelegatingControlSurfaceObjectProxy delegatingControlSurfaceObjectProxy : this.mCursorDevices) {
            delegatingControlSurfaceObjectProxy.clearTarget();
        }
        for (DelegatingControlSurfaceObjectProxy delegatingControlSurfaceObjectProxy : this.mCursorClips) {
            delegatingControlSurfaceObjectProxy.clearTarget();
        }
    }

    private void oldCursorDeviceAPIUsed() {
        this.checkIsInitializingDriver();
        this.deprecated(1, 2, "Use createCursorDevice and specify follow mode instead");
    }

    @Override
    public Device getPrimaryDevice() {
        if (this.mPrimaryDevice == null) {
            this.oldCursorDeviceAPIUsed();
            this.mPrimaryDevice = this.createCursorDevice(this.mCursorId + " / Primary Device", "Primary Device", this.getDelegateProxy().getNumSends(), CursorDeviceFollowMode.FIRST_INSTRUMENT_OR_DEVICE);
        }
        return this.mPrimaryDevice;
    }

    @Override
    public Device getPrimaryInstrument() {
        return this.getPrimaryDevice();
    }

    @Override
    public PinnableCursorDevice createCursorDevice() {
        return this.createCursorDevice(DEFAULT_CURSOR_DEVICE_ID, DEFAULT_CURSOR_DEVICE_NAME, this.getNumSends(), CursorDeviceFollowMode.FOLLOW_SELECTION);
    }

    @Override
    public PinnableCursorDevice createCursorDevice(String string) {
        return this.createCursorDevice(string, this.getNumSends());
    }

    @Override
    public PinnableCursorDevice createCursorDevice(String string, int n4) {
        this.oldCursorDeviceAPIUsed();
        String string2 = string;
        CursorDeviceFollowMode cursorDeviceFollowMode = CursorDeviceFollowMode.FIRST_INSTRUMENT_OR_DEVICE;
        if (string == null || string.isEmpty()) {
            string = DEFAULT_CURSOR_DEVICE_ID;
            string2 = DEFAULT_CURSOR_DEVICE_NAME;
            cursorDeviceFollowMode = CursorDeviceFollowMode.FOLLOW_SELECTION;
        }
        return this.createCursorDevice(string, string2, n4, cursorDeviceFollowMode);
    }

    @Override
    public PinnableCursorDevice createCursorDevice(String string, String string2, int n4, CursorDeviceFollowMode cursorDeviceFollowMode) {
        this.checkIsInitializingDriver();
        this.notEmpty(string, "id");
        this.notNull(string2, "name");
        this.atLeast(n4, 0, "numSends");
        this.notNull((Object)cursorDeviceFollowMode, "followMode");
        for (CursorTrackCursorDeviceProxy cursorTrackCursorDeviceProxy : this.mCursorDevices) {
            if (!cursorTrackCursorDeviceProxy.getCursorId().equals(string2)) continue;
            if (cursorTrackCursorDeviceProxy.getNumSends() == n4) {
                return cursorTrackCursorDeviceProxy;
            }
            this.deprecated(1, 2, "CursorDevice already created with id " + string + " but with " + cursorTrackCursorDeviceProxy.getNumSends() + " sends and now " + n4 + " sends were requested");
        }
        CursorTrackCursorDeviceProxy cursorTrackCursorDeviceProxy = new CursorTrackCursorDeviceProxy(this, string, string2, n4, cursorDeviceFollowMode);
        this.mCursorDevices.add(cursorTrackCursorDeviceProxy);
        return cursorTrackCursorDeviceProxy;
    }

    @Override
    public PinnableCursorClip createLauncherCursorClip(int n4, int n5) {
        return this.createLauncherCursorClip(DEFAULT_LAUNCHER_CURSOR_CLIP_ID, DEFAULT_LAUNCHER_CURSOR_CLIP_NAME, n4, n5);
    }

    @Override
    public PinnableCursorClip createLauncherCursorClip(String string, String string2, int n4, int n5) {
        this.checkIsInitializingDriver();
        this.newSince(10);
        this.notEmpty(string, "id");
        this.notNull(string2, "name");
        for (CursorTrackCursorClipProxy cursorTrackCursorClipProxy : this.mCursorClips) {
            if (!cursorTrackCursorClipProxy.getCursorId().equals(string2)) continue;
            ClipProxy clipProxy = cursorTrackCursorClipProxy.getDelegateProxy();
            if (clipProxy.getGridWidth() != n4 || clipProxy.getGridHeight() != n5) {
                throw new FVt("Cursor clip already created with id " + string + " and differnt size");
            }
            return cursorTrackCursorClipProxy;
        }
        CursorTrackCursorClipProxy cursorTrackCursorClipProxy = new CursorTrackCursorClipProxy(this, string, string2, n4, n5);
        this.mCursorClips.add(cursorTrackCursorClipProxy);
        return cursorTrackCursorClipProxy;
    }

    @Override
    public TrackBank createSiblingsTrackBank(int n4, int n5, int n6, boolean bl2, boolean bl3) {
        TrackBank trackBank = super.createSiblingsTrackBank(n4, n5, n6, bl2, bl3);
        trackBank.followCursorTrack(this);
        return trackBank;
    }
}

