/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.CursorDeviceFollowMode;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.PrimaryDevice;
import com.bitwig.extension.controller.api.PrimaryDevice$ChainLocation;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlBinding;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDeviceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.CursorTrackProxy;
import com.bitwig.flt.control_surface.proxy.DelegatingDeviceProxy;
import com.bitwig.flt.control_surface.proxy.DeviceOrPreviewDeviceProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.document.core.iface.GXb;

public class CursorTrackCursorDeviceProxy
extends DelegatingDeviceProxy
implements PinnableCursorDevice,
PrimaryDevice {
    private final int mNumSends;
    private final z3N mFollowMode;
    private final Channel mTrackProxy;
    private final ControlSurfaceDeviceCursorProxy mCursorProxy;

    private static z3N getDeviceCursorFollowMode(CursorDeviceFollowMode cursorDeviceFollowMode) {
        assert (bqP.XHT(cursorDeviceFollowMode != null));
        switch (cursorDeviceFollowMode) {
            case FIRST_AUDIO_EFFECT: {
                return z3N.hAB;
            }
            case FIRST_DEVICE: {
                return z3N.gBO;
            }
            case FIRST_INSTRUMENT: {
                return z3N.XHT;
            }
            case FOLLOW_SELECTION: {
                return z3N.DVW;
            }
            case FIRST_INSTRUMENT_OR_DEVICE: {
                return z3N.lTJ;
            }
            case LAST_DEVICE: {
                return z3N.qhn;
            }
        }
        throw new FVt("Unsupported follow mode " + cursorDeviceFollowMode);
    }

    public CursorTrackCursorDeviceProxy(CursorTrackProxy cursorTrackProxy, String string, String string2, int n4, CursorDeviceFollowMode cursorDeviceFollowMode) {
        super((ControlSurfaceObject)cursorTrackProxy, new DeviceOrPreviewDeviceProxy((ControlSurfaceObject)cursorTrackProxy, new DeviceProxy(cursorTrackProxy, string, n4, cursorTrackProxy.getDelegateProxy())));
        this.notNull((Object)cursorDeviceFollowMode, "followMode");
        this.mNumSends = n4;
        this.mTrackProxy = cursorTrackProxy;
        this.mFollowMode = CursorTrackCursorDeviceProxy.getDeviceCursorFollowMode(cursorDeviceFollowMode);
        this.mCursorProxy = new ControlSurfaceDeviceCursorProxy(this, string, string2, this.getDelegateProxy());
    }

    public String getCursorId() {
        return this.mCursorProxy.getCursorId();
    }

    public String getName() {
        return this.mCursorProxy.getName();
    }

    public int getNumSends() {
        return this.mNumSends;
    }

    @Override
    public DeviceOrPreviewDeviceProxy getDelegateProxy() {
        return (DeviceOrPreviewDeviceProxy)super.getDelegateProxy();
    }

    @Override
    public Class getTargetType() {
        return Pvn.class;
    }

    @Override
    public RelativeHardwareControlBinding addBindingWithSensitivity(RelativeHardwareControl relativeHardwareControl, double d3) {
        return this.mCursorProxy.addBindingWithSensitivity(relativeHardwareControl, d3);
    }

    @Override
    public SettableBooleanValue isPinned() {
        return this.mCursorProxy.isPinned();
    }

    @Override
    public HardwareActionBindable selectNextAction() {
        return this.mCursorProxy.selectNextAction();
    }

    @Override
    public HardwareActionBindable selectPreviousAction() {
        return this.mCursorProxy.selectPreviousAction();
    }

    @Override
    public void selectPrevious() {
        this.mCursorProxy.selectPrevious();
    }

    @Override
    public void selectNext() {
        this.mCursorProxy.selectNext();
    }

    @Override
    public void selectFirst() {
        this.mCursorProxy.selectFirst();
    }

    @Override
    public void selectLast() {
        this.mCursorProxy.selectLast();
    }

    @Override
    public BooleanValue hasNext() {
        return this.mCursorProxy.hasNext();
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mCursorProxy.hasPrevious();
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mCursorProxy.hasPrevious().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mCursorProxy.hasNext().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public Channel getChannel() {
        this.deprecated(1, 5, "Use channel() instead.");
        return this.mTrackProxy;
    }

    @Override
    public Channel channel() {
        this.newSince(5);
        return this.mTrackProxy;
    }

    @Override
    public void switchToDevice(PrimaryDevice.DeviceType deviceType, PrimaryDevice$ChainLocation primaryDevice$ChainLocation) {
        this.deprecatedFail(1, 2, "PrimaryDevice interface has been deprecated");
        switch (primaryDevice$ChainLocation) {
            case FIRST: {
                this.selectFirst();
                break;
            }
            case LAST: {
                this.selectLast();
                break;
            }
            case NEXT: {
                this.selectNext();
                break;
            }
            case PREVIOUS: {
                this.selectPrevious();
                break;
            }
        }
    }

    @Override
    public void addCanSwitchToDeviceObserver(PrimaryDevice.DeviceType deviceType, PrimaryDevice$ChainLocation primaryDevice$ChainLocation, BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecatedFail(1, 2, "Use a name cursor device instead of PrimaryDevice interface");
    }

    @Override
    public void selectParent() {
        this.mCursorProxy.selectParent();
    }

    @Override
    public void selectDevice(Device device) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(device, "device");
        assert (bqP.XHT(device instanceof ControlSurfaceProxy));
        this.exec(() -> this.doSelectDevice(device));
    }

    private void doSelectDevice(Device device) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(device != null));
        brV brV2 = (brV)((ControlSurfaceProxy)((Object)device)).getTargetOfType(brV.class);
        if (brV2 != null) {
            this.mCursorProxy.doSelect(brV2);
        }
    }

    @Override
    public void selectFirstInChannel(Channel channel) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(channel, "channel");
        this.exec(() -> this.doSelectFirstInChannel(channel));
    }

    private void doSelectFirstInChannel(Channel channel) {
        brV brV2;
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(channel != null));
        assert (bqP.XHT(channel instanceof ControlSurfaceProxy));
        GXb gXb = (GXb)((ControlSurfaceProxy)((Object)channel)).getTargetOfType(GXb.class);
        if (gXb != null && (brV2 = gXb.ft_().lTJ()) != null) {
            this.mCursorProxy.doSelect(brV2);
        }
    }

    @Override
    public void selectLastInChannel(Channel channel) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(channel, "channel");
        this.exec(() -> this.doSelectLastInChannel(channel));
    }

    private void doSelectLastInChannel(Channel channel) {
        YQ yQ2;
        int n4;
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(channel != null));
        assert (bqP.XHT(channel instanceof ControlSurfaceProxy));
        GXb gXb = (GXb)((ControlSurfaceProxy)((Object)channel)).getTargetOfType(GXb.class);
        if (gXb != null && (n4 = (yQ2 = gXb.ft_()).D2F()) > 0) {
            this.mCursorProxy.doSelect(yQ2.gBO(n4 - 1));
        }
    }

    @Override
    public void selectFirstInSlot(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectFirstInSlot(string);
    }

    @Override
    public void selectLastInSlot(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectLastInSlot(string);
    }

    @Override
    public void selectFirstInKeyPad(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectFirstInKeyPad(n4);
    }

    @Override
    public void selectLastInKeyPad(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectLastInKeyPad(n4);
    }

    @Override
    public void selectFirstInLayer(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectFirstInLayer(n4);
    }

    @Override
    public void selectLastInLayer(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectLastInLayer(n4);
    }

    @Override
    public void selectFirstInLayer(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectFirstInLayer(string);
    }

    @Override
    public void selectLastInLayer(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.mCursorProxy.selectLastInLayer(string);
    }

    protected void connectToTarget(Pvn pvn) {
        assert (bqP.XHT(this.isDocumentThread()));
        QNX qNX = pvn.DVW(this.getCursorId(), this.getName(), this.mFollowMode);
        assert (bqP.XHT(qNX != null));
        this.mCursorProxy.setTarget(qNX);
    }

    protected void disconnectFromTarget(Pvn pvn) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.mCursorProxy.clearTarget();
    }
}

