/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$SelectedPageIndexValue;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.ParameterBankProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlsPageProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.IntegerValueProxy;
import com.bitwig.flt.control_surface.values.SettableIntegerValueProxy;
import com.bitwig.flt.control_surface.values.StringArrayValueProxy;
import com.bitwig.ramona.core.skf;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class CursorRemoteControlsPageProxy
extends ControlSurfaceDocumentObjectProxy
implements bNT,
cPe,
CursorRemoteControlsPage,
ParameterBankProxy {
    private static final String[] NO_PAGE_NAMES = new String[0];
    private final BAN mPagesChangedListener = object -> this.invalidatePages();
    private HardwareControlType mHardwareControlType = HardwareControlType.KNOB;
    private int mHardwareColumns = 8;
    private boolean mHasScheduledUpdateToPages;
    private List mPages;
    private final StringArrayValueProxy mPageNamesValue;
    private final SettableIntegerValueProxy mSelectedPageIndexValue;
    private final znc mPageNames;
    private final jpE mPageCount = new jpE(0);
    private final IntegerValueProxy mPageCountValue;
    private final RemoteControlsPageProxy mSelectedPageProxy;
    private final xz3 mHasPrevParameterPage = new xz3(false);
    private final xz3 mHasNextParameterPage = new xz3(false);
    private final CursorRemoteControlsPageProxy$SelectedPageIndexValue mSelectedPageIndex = new CursorRemoteControlsPageProxy$SelectedPageIndexValue(this, 0);
    private final BooleanValueProxy mHasNextPageValue;
    private final BooleanValueProxy mHasPreviousPageValue;
    private UNZ mPageSelector;
    private boolean mIsChangingPageFromController;
    private final FhX mSelectedPageListener = sqC2 -> this.scheduleUpdateSelectedPage();
    private boolean mHasScheduledUpdateSelectedPage;
    private boolean mWasChangingPageFromControllerWhenScheduling;

    protected CursorRemoteControlsPageProxy(ControlSurfaceObject controlSurfaceObject, String string, int n4) {
        super(controlSurfaceObject);
        assert (bqP.XHT(string != null));
        assert (bqP.XHT(n4 >= 1));
        this.mSelectedPageProxy = new RemoteControlsPageProxy(this, string, n4);
        this.mPageNamesValue = new StringArrayValueProxy((ControlSurfaceObject)this, NO_PAGE_NAMES);
        this.mPageNames = new znc(NO_PAGE_NAMES);
        this.mSelectedPageIndexValue = new SettableIntegerValueProxy((ControlSurfaceObject)this, -1);
        this.mHasNextPageValue = new BooleanValueProxy(this);
        this.mHasPreviousPageValue = new BooleanValueProxy(this);
        this.mPageCountValue = new IntegerValueProxy(this);
    }

    @Override
    public int getParameterCount() {
        return this.mSelectedPageProxy.getParameterCount();
    }

    @Override
    public RemoteControlProxy getParameter(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return this.mSelectedPageProxy.getParameter(n4);
    }

    public RemoteControlsPageProxy getSelectedPage() {
        return this.mSelectedPageProxy;
    }

    @Override
    public StringValue getName() {
        this.newSince(4);
        return this.mSelectedPageProxy.getName();
    }

    @Override
    public SettableIntegerValue selectedPageIndex() {
        return this.mSelectedPageIndexValue;
    }

    @Override
    public IntegerValue pageCount() {
        this.newSince(7);
        return this.mPageCountValue;
    }

    private void doSelectPageAtIndex(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mPageSelector != null && n4 >= 0) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.DVW(n4);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPreviousPage(boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectPreviousPage(bl2));
    }

    private void doSelectPreviousPage(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.gBO(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void doStepBackwards() {
        this.doSelectPreviousPage(false);
    }

    @Override
    public void selectFirst() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doSelectFirst);
    }

    private void doSelectFirst() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.lTJ();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectLast() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doSelectLast);
    }

    private void doSelectLast() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.gF_();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNext() {
        this.selectNextPage(false);
    }

    @Override
    public void selectNextPage(boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectNextPage(bl2));
    }

    private void doSelectNextPage(boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.DVW(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public HardwareActionBindable selectNextAction() {
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doSelectNextPage(false));
    }

    @Override
    public HardwareActionBindable selectPreviousAction() {
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doSelectPreviousPage(false));
    }

    @Override
    public void doStepForwards() {
        this.doSelectNextPage(false);
    }

    @Override
    public void selectNextPageMatching(String string, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (string == null) {
            throw new FVt("expression cannot be null");
        }
        this.exec(() -> this.doSelectNextPageMatching(string, bl2));
    }

    private void doSelectNextPageMatching(String string, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.DVW(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPrevious() {
        this.selectPreviousPage(false);
    }

    @Override
    public void selectPreviousPageMatching(String string, boolean bl2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (string == null) {
            throw new FVt("expression cannot be null");
        }
        this.exec(() -> this.doSelectPreviousPageMatching(string, bl2));
    }

    private void doSelectPreviousPageMatching(String string, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.gBO(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasNextPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasPreviousPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mHasPreviousPageValue;
    }

    @Override
    public BooleanValue hasNext() {
        return this.mHasNextPageValue;
    }

    protected abstract UNZ getPageSelectorForRemoteControls(fHv var1);

    protected void connectToTarget(fHv fHv2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(fHv2 != null));
        assert (bqP.XHT(this.mPageSelector == null));
        this.mPageSelector = this.getPageSelectorForRemoteControls(fHv2);
        this.mPageNamesValue.setTarget(this.mPageNames);
        fHv2.DVW(this.mPagesChangedListener);
        this.mPageSelector.DVW(this.mSelectedPageListener);
        this.mSelectedPageIndexValue.setTarget(this.mSelectedPageIndex);
        this.mHasNextPageValue.setTarget(this.mHasNextParameterPage);
        this.mHasPreviousPageValue.setTarget(this.mHasPrevParameterPage);
        this.mPageCountValue.setTarget(this.mPageCount);
        this.updatePages();
        this.updateSelectedPage();
    }

    protected void disconnectFromTarget(fHv fHv2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(fHv2 != null));
        assert (bqP.XHT(this.mPageSelector != null));
        this.mSelectedPageIndexValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mPageNamesValue.clearTarget();
        this.mPageSelector.gBO(this.mSelectedPageListener);
        fHv2.gBO(this.mPagesChangedListener);
        this.mPageSelector = null;
        this.mSelectedPageProxy.clearTarget();
    }

    private void invalidatePages() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPages) {
            this.mHasScheduledUpdateToPages = true;
            this.runAtEndOfEvent(this::updatePages);
        }
    }

    @Override
    public StringArrayValue pageNames() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return this.mPageNamesValue;
    }

    private void ensurePagesUpdated() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mHasScheduledUpdateToPages) {
            this.updatePages();
        }
    }

    private void updatePages() {
        assert (bqP.XHT(this.isDocumentThread()));
        this.mHasScheduledUpdateToPages = false;
        this.setPages(this.calculatePages());
    }

    private void setPages(List list) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(list != null));
        if (!Objects.equals(this.mPages, list)) {
            int n4;
            MFC mFC;
            this.mPages = list;
            int n5 = this.mPages.size();
            this.mPageCount.setIntegerValue(n5);
            if (this.mPageSelector == null) {
                assert (bqP.XHT(this.mPages.isEmpty()));
                mFC = null;
                n4 = 0;
            } else {
                mFC = this.mPageSelector.nrS();
                n4 = this.mPages.indexOf(mFC);
                assert (bqP.XHT(n5 > 0 ? n4 != -1 : true));
                if (n4 == -1) {
                    n4 = this.mSelectedPageIndex.getIntegerValue();
                    if (n4 < 0 || n4 >= n5) {
                        n4 = n5 > 0 ? n5 - 1 : 0;
                    }
                    mFC = n5 > 0 ? (MFC)this.mPages.get(n4) : null;
                    this.mPageSelector.gBO(this.mSelectedPageListener);
                    this.mPageSelector.DVW(mFC);
                    this.mPageSelector.DVW(this.mSelectedPageListener);
                }
            }
            this.mSelectedPageIndex.doSetValue(n4);
            this.mSelectedPageProxy.setTarget(mFC);
            this.mHasPrevParameterPage.setBoolValue(n4 > 0);
            this.mHasNextParameterPage.setBoolValue(n4 + 1 < n5);
        }
        this.updatePageNames();
    }

    private void updateHasNextAndPrevPage() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mHasScheduledUpdateSelectedPage) {
            this.updateSelectedPage();
        }
        if (this.getTarget() != null) {
            int n4 = this.getPageCount();
            int n5 = this.mSelectedPageIndex.getValue();
            assert (bqP.XHT(n5 == this.clampPageToRange(n5)));
            this.mPageCount.setValue(n4);
            this.mHasPrevParameterPage.DVW(n5 > 0);
            this.mHasNextParameterPage.DVW(n5 < n4 - 1);
        } else {
            this.mPageCount.setValue(0);
            this.mHasPrevParameterPage.DVW(false);
            this.mHasNextParameterPage.DVW(false);
        }
    }

    private void scheduleUpdateSelectedPage() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateSelectedPage) {
            this.mHasScheduledUpdateSelectedPage = true;
            this.mWasChangingPageFromControllerWhenScheduling = this.mIsChangingPageFromController;
            this.runAtEndOfEvent(this::updateSelectedPage);
        }
    }

    private void updateSelectedPage() {
        assert (bqP.XHT(this.isDocumentThread()));
        this.ensurePagesUpdated();
        this.mHasScheduledUpdateSelectedPage = false;
        MFC mFC = this.mPageSelector != null ? this.mPageSelector.nrS() : null;
        this.mSelectedPageProxy.setTarget(mFC);
        if (mFC != null) {
            int n4 = this.getPageIndex(mFC);
            assert (bqP.XHT(n4 >= 0));
            this.mSelectedPageIndex.doSetValue(n4);
            if (this.mWasChangingPageFromControllerWhenScheduling) {
                this.getControlSurface().DVW(this);
            }
        } else {
            this.mSelectedPageIndex.doSetValue(0);
        }
        this.updateHasNextAndPrevPage();
    }

    protected int clampPageToRange(int n4) {
        int n5 = this.getPageCount();
        return n5 > 0 ? S1V.DVW(n4, 0, n5 - 1) : 0;
    }

    private List calculatePages() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.mPageSelector == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mPageSelector.gBO();
    }

    private void updatePageNames() {
        this.setPageNames(this.calculatePageNames());
    }

    private String[] calculatePageNames() {
        int n4 = this.getPageCount();
        if (n4 == 0) {
            return NO_PAGE_NAMES;
        }
        String[] stringArray = new String[n4];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)this.getPageAt(i2).jJc().getValue();
        }
        return stringArray;
    }

    private void setPageNames(String[] stringArray) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(stringArray != null));
        Object[] objectArray = (String[])this.mPageNames.getValue();
        assert (bqP.XHT(objectArray != null));
        if (!Arrays.equals(stringArray, objectArray)) {
            this.mPageNames.setValue(stringArray);
        }
    }

    public int getPageCount() {
        assert (bqP.XHT(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (bqP.XHT(!this.mHasScheduledUpdateToPages));
        return this.mPages != null ? this.mPages.size() : 0;
    }

    public MFC getPageAt(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (bqP.XHT(!this.mHasScheduledUpdateToPages));
        return (MFC)this.mPages.get(n4);
    }

    public int getPageIndex(MFC mFC) {
        assert (bqP.XHT(mFC != null));
        assert (bqP.XHT(this.isDocumentThread()));
        this.ensurePagesUpdated();
        return this.mPages.indexOf(mFC);
    }

    @Override
    public bTd createVisualizationWidget() {
        assert (bqP.DVW(this.isDocumentThread()));
        cti cti2 = cti.aQg();
        cti2.DVW(this::createWidgetForPage);
        bTd.DVW((skf)cti2.lnJ(), this.mSelectedPageIndex);
        return cti2;
    }

    private bTd createWidgetForPage(Object object) {
        assert (bqP.DVW(this.isDocumentThread()));
        bSX bSX2 = bSX.ZAh("");
        bSX2.XHT(bSX2.GWx().aOI());
        bSX2.gBO(bSr.hAB);
        bSX2.szR("Bold Smaller");
        bNK bNK2 = bNK.gBO(bSX2, true, false);
        bNK2.a_(new l1X(61L));
        csT csT2 = csT.DVW(0, bNK2);
        csT2.lTJ(0.5f);
        csT2.Mdo(true);
        int n4 = this.getParameterCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            RemoteControlProxy remoteControlProxy = this.getSelectedPage().getParameterUnchecked(i2);
            if (!remoteControlProxy.shouldIndicate()) continue;
            bTd bTd2 = remoteControlProxy.createVisualizationWidget();
            csT2.bfM(bTd2);
        }
        String[] stringArray = (String[])this.mPageNames.getValue();
        int n5 = this.mSelectedPageIndex.getValue();
        if (stringArray != null && n5 >= 0 && n5 < stringArray.length) {
            bSX2.vCp(stringArray[n5].toUpperCase());
        }
        return csT2;
    }

    @Override
    public void setHardwareLayout(HardwareControlType hardwareControlType, int n4) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(7);
        this.mHardwareControlType = hardwareControlType;
        this.mHardwareColumns = n4;
    }

    @Override
    public HardwareControlType getHardwareLayoutControlType() {
        return this.mHardwareControlType;
    }

    @Override
    public int getHardwareLayoutColumns() {
        return this.mHardwareColumns;
    }
}

