/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CueMarker;
import com.bitwig.extension.controller.api.CueMarkerBank;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CueMarkerProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.document.core.iface.oTe;

public class CueMarkerBankProxy
extends ControlSurfaceDocumentProxy
implements cPe,
CueMarkerBank {
    private final CueMarkerProxy[] mMarkers;
    private final ListValueBankItemTargetUpdater mBankUpdater;

    protected CueMarkerBankProxy(ControlSurfaceObject controlSurfaceObject, String string, int n4) {
        super(controlSurfaceObject);
        this.setKey(string);
        if (n4 < 1) {
            throw new FVt("At least 1 cue marker is required.");
        }
        this.mMarkers = new CueMarkerProxy[n4];
        this.mBankUpdater = new ListValueBankItemTargetUpdater(this, this.mMarkers, 0);
        for (int i2 = 0; i2 < n4; ++i2) {
            CueMarkerProxy cueMarkerProxy;
            this.mMarkers[i2] = cueMarkerProxy = this.createCueMarkerProxy(controlSurfaceObject, i2, this.getKey());
            this.addChild(cueMarkerProxy);
        }
    }

    private CueMarkerProxy createCueMarkerProxy(ControlSurfaceObject controlSurfaceObject, int n4, String string) {
        CueMarkerProxy cueMarkerProxy = new CueMarkerProxy(controlSurfaceObject);
        cueMarkerProxy.setKey(string + "/" + n4);
        return cueMarkerProxy;
    }

    protected void connectToTarget(oTe oTe2) {
        assert (bqP.lTJ(oTe2 != null));
        Hjp hjp = oTe2.Cae().zzR().gBO();
        this.mBankUpdater.setTarget(hjp.LsI());
    }

    protected void disconnectFromTarget(oTe oTe2) {
        assert (bqP.lTJ(oTe2 != null));
        this.mBankUpdater.setTarget(null);
    }

    @Override
    public int getSizeOfBank() {
        return this.mBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n4) {
        this.mBankUpdater.setSizeOfBank(n4);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mBankUpdater.getCapacityOfBank();
    }

    @Override
    public CueMarker getItemAt(int n4) {
        return (CueMarker)((Object)this.mBankUpdater.getItemAt(n4));
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n4) {
        this.newSince(7);
        this.mBankUpdater.scrollIntoView(n4);
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public void scrollByPages(int n4) {
        this.mBankUpdater.scrollByPages(n4);
    }

    @Override
    public void scrollPageForwards() {
        this.scrollByPages(1);
    }

    @Override
    public void scrollPageBackwards() {
        this.scrollByPages(-1);
    }

    @Override
    public void scrollBy(int n4) {
        this.mBankUpdater.scrollBy(n4);
    }

    @Override
    public void doStepForwards() {
        this.mBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollForwards() {
        this.scrollBy(1);
    }

    @Override
    public void scrollBackwards() {
        this.scrollBy(-1);
    }

    @Override
    public void scrollToMarker(int n4) {
        this.mBankUpdater.scrollIntoView(n4);
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mBankUpdater.scrollPageForwardsAction();
    }
}

