/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.base.sound.NBU;
import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.Callback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NoteStepChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.FnS;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$2;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.LaunchQuantizationProxy;
import com.bitwig.flt.control_surface.proxy.NoteStep;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableEnumAttributeProxy;
import com.bitwig.flt.document.core.iface.oTe;
import com.bitwig.ramona.core.GRo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.function.Consumer;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private static final boolean ENABLE_EARLY_LOCAL_CACHE_UPDATE = false;
    private final BAN mPlaybackPositionListener = sqC2 -> {
        double d3 = (Double)sqC2.gBO();
        assert (bqP.XHT(d3 >= 0.0 || d3 == -1.0));
        this.setPlayingStep(d3 >= 0.0 ? (int)Math.floor(d3 / this.getStepSize()) : -1);
    };
    private final GRo mHierarchyListener = new ClipProxy$1(this);
    private final X3g mSelectionChangeListener = new ClipProxy$2(this);
    private OMl mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private HashMap mNoteSteps = new HashMap();
    private int mBaseKey = 0;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private final SettableBooleanValueProxy mShuffle;
    private final RangedValueProxy mAccent;
    private final SettableBooleanValueProxy mIsLoopEnabled;
    private final BeatTimeProxy mPlayStart;
    private final BeatTimeProxy mPlayStop;
    private final BeatTimeProxy mLoopStart;
    private final BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private final TrackProxy mTrackSection;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList();
    private final List mNoteDataChangedCallback = new ArrayList();
    private TimerTask mUpdateTimerTask = null;
    private final SettableEnumAttributeProxy mLaunchQuantization;
    private final SettableBooleanValueProxy mUseLoopStartAsQuantizationReference;
    private final Runnable mClipEventsChanged = this::invalidateGrid;
    private final ClipLauncherSlotProxy mClipLauncherSlot;
    private final SettableEnumAttributeProxy mLaunchMode;
    private final SettableBooleanValueProxy mLegatoMode;

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n4, int n5) {
        super(controlSurfaceObject);
        this.setKey(string);
        this.mGridHeight = n5;
        this.mGridWidth = n4;
        this.mStepGrid = new S1c(this.mStepSize);
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackSection = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mLaunchQuantization = new LaunchQuantizationProxy((ControlSurfaceObject)this, true);
        this.mUseLoopStartAsQuantizationReference = new SettableBooleanValueProxy(this);
        this.mClipLauncherSlot = new ClipLauncherSlotProxy(this);
        this.mLaunchMode = new SettableEnumAttributeProxy((ControlSurfaceObject)this, eHK.DVW);
        this.mLegatoMode = new SettableBooleanValueProxy(this);
    }

    public int getGridWidth() {
        return this.mGridWidth;
    }

    public int getGridHeight() {
        return this.mGridHeight;
    }

    @Override
    public Class getTargetType() {
        return Za.class;
    }

    protected oTe getDocumentFromTarget(Za za3) {
        return za3.wr();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-this.mGridHeight));
    }

    private void doScrollKeysBy(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        int n5 = this.mBaseKey + n4;
        if (n5 >= 0 && n5 <= 127) {
            this.doScrollToKey(n5);
        }
    }

    @Override
    public void scrollKeysStepUp() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(1));
    }

    @Override
    public void scrollKeysStepDown() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-1));
    }

    @Override
    public void scrollToKey(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.validKey(n4);
        this.exec(() -> this.doScrollToKey(n4));
    }

    private void doScrollToKey(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(n4 >= 0 && n4 <= 127));
        if (n4 != this.mBaseKey) {
            this.mBaseKey = n4;
            Za za3 = (Za)this.getTarget();
            if (za3 != null) {
                this.updateGrid();
            }
        }
    }

    @Override
    public void scrollToStep(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n4));
    }

    private void doScrollToStep(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 != null && this.mBaseStep != n4) {
            this.mBaseStep = n4;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.notNull(string, "name");
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 != null && za3.mcc() != null) {
            za3.mcc().DVW(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.exec(() -> this.doScrollStepsBy(this.mGridWidth));
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.exec(() -> this.doScrollStepsBy(-this.mGridWidth));
    }

    @Override
    public void scrollStepsStepForward() {
        this.exec(() -> this.doScrollStepsBy(1));
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.exec(() -> this.doScrollStepsBy(-1));
    }

    private void doScrollStepsBy(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.doScrollToStep(this.mBaseStep + n4);
    }

    @Override
    public void toggleStep(int n4, int n5, int n6) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.toggleStepCommon(0, n4, n5, n6);
    }

    @Override
    public void toggleStep(int n4, int n5, int n6, int n7) {
        this.newSince(10);
        this.toggleStepCommon(n4, n5, n6, n7);
    }

    private void toggleStepCommon(int n4, int n5, int n6, int n7) {
        this.validPosition(n5, n6);
        this.inRange(n7, 0, 127, "insertVelocity");
        this.exec(() -> this.doToggleStep(n4, n5, n6, n7));
    }

    private void doToggleStep(int n4, int n5, int n6, int n7) {
        assert (bqP.XHT(this.isDocumentThread()));
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        Za za3 = (Za)this.getTarget();
        assert (bqP.XHT(za3 != null));
        int n8 = this.getKeyForY(n6);
        double d3 = this.getTimeForCell(n5);
        double d4 = d3 + this.getStepSize() - 1.0E-4;
        if (NBU.jpF(n8)) {
            eos eos2 = qtB2.gX_().DVW(n4, n8, false);
            List list = eos2 != null ? eos2.lTJ(d3, d4) : Collections.EMPTY_LIST;
            za3.vr().aQg();
            if (list.isEmpty()) {
                qtB2.DVW(d3, this.mStepSize, n4, n8, (float)n7 * 0.007874016f, za3.vr().qhn());
            } else {
                for (Ann ann2 : list) {
                    dyk dyk2 = (dyk)ann2;
                    if (dyk2.UY2() != n4) continue;
                    eos2.gBO(ann2);
                }
            }
        }
    }

    @Override
    public void setStep(int n4, int n5, int n6, double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.setStepCommon(0, n4, n5, n6, d3);
    }

    @Override
    public void setStep(int n4, int n5, int n6, int n7, double d3) {
        this.newSince(10);
        this.setStepCommon(n4, n5, n6, n7, d3);
    }

    public void setStepCommon(int n4, int n5, int n6, int n7, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.validPosition(n4, n5, n6);
        this.inRange(n7, 0, 127, "insertVelocity");
        this.greaterThan(d3, 0.0, "insertDuration");
        this.exec(() -> this.doSetStep(n4, n5, n6, n7, uLA.DVW(d3)));
    }

    private void doSetStep(int n4, int n5, int n6, int n7, double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        Za za3 = (Za)this.getTarget();
        assert (bqP.XHT(za3 != null));
        int n8 = n6 + this.mBaseKey;
        double d4 = this.getTimeForCell(n5);
        if (n8 >= 0 && n8 < 128) {
            qtB2.DVW(d4, d3, n4, n8, (float)n7 * 0.007874016f, za3.vr().qhn());
        }
    }

    public void updateStepVelocity(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, 0.0, 1.0, "velocity");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> axl2.g_(d3)));
    }

    public void updateStepReleaseVelocity(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, 0.0, 1.0, "velocity");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> axl2.gBO(d3)));
    }

    public void updateStepDuration(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, 0.0, 128.0, "duration");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> {
            eos eos2 = axl2.DnY();
            double d4 = uLA.qhn(d3);
            eos2.DVW((Brt)axl2, axl2.KQG(), d4);
        }));
    }

    public void updateStepPan(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, -1.0, 1.0, "pan");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> rJ1.DVW(axl2, "panning", 0.0, (d3 + 1.0) / 2.0)));
    }

    public void updateStepTranspose(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, -24.0, 24.0, "transpose");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> rJ1.DVW(axl2, "transpose", 0.0, (d3 + 24.0) / 48.0)));
    }

    public void updateStepGain(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, 0.0, 1.0, "gain");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> rJ1.DVW(axl2, "amplitude", 0.0, d3)));
    }

    public void updateStepTimbre(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, -1.0, 1.0, "timbre");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> rJ1.DVW(axl2, "timbre", 0.0, (d3 + 1.0) / 2.0)));
    }

    public void updateStepPressure(NoteStep noteStep, double d3) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        int n4 = noteStep.x();
        int n5 = noteStep.y();
        int n6 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n4, n5);
        this.validChannel(n6);
        this.inRange(d3, 0.0, 1.0, "pressure");
        this.exec(() -> this.doUpdateNoteEvent(n6, n4, n5, axl2 -> rJ1.DVW(axl2, "pressure", 0.0, d3)));
    }

    private void doUpdateNoteEvent(int n4, int n5, int n6, Consumer consumer) {
        assert (bqP.DVW(this.isDocumentThread()));
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        Za za3 = (Za)this.getTarget();
        assert (bqP.DVW(za3 != null));
        int n7 = n6 + this.mBaseKey;
        double d3 = this.getTimeForCell(n5);
        if (n7 < 0 || 128 <= n7) {
            return;
        }
        eos eos2 = qtB2.gX_().DVW(n4, n7, false);
        if (eos2 == null) {
            return;
        }
        List list = eos2.lTJ(d3, d3 + this.mStepSize - 0.001);
        if (list == null) {
            return;
        }
        oTe oTe2 = this.getDocument();
        oTe2.DVW("Update Note Data From Controller Extension", false);
        for (Ann ann2 : list) {
            if (!(ann2 instanceof Axl)) continue;
            Axl axl2 = (Axl)ann2;
            consumer.accept(axl2);
        }
        oTe2.DVW(false);
    }

    @Override
    public void clearStep(int n4, int n5) {
        this.clearStepCommon(0, n4, n5);
    }

    @Override
    public void clearStep(int n4, int n5, int n6) {
        this.newSince(10);
        this.clearStepCommon(n4, n5, n6);
    }

    public void clearStepCommon(int n4, int n5, int n6) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.validPosition(n4, n5, n6);
        this.exec(() -> this.doClearStep(n4, n5, n6));
    }

    private void doClearStep(int n4, int n5, int n6) {
        assert (bqP.XHT(this.isDocumentThread()));
        int n7 = n6 + this.mBaseKey;
        if (n7 < 0 || n7 > 128) {
            return;
        }
        Za za3 = (Za)this.getTarget();
        if (za3 == null) {
            return;
        }
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        double d3 = this.getTimeForCell(n5);
        double d4 = d3 + this.getStepSize() - 1.0E-4;
        eos eos2 = qtB2.gX_().DVW(n4, n7, false);
        if (eos2 == null) {
            return;
        }
        List list = eos2.lTJ(d3, d4);
        for (Axl axl2 : list) {
            eos2.gBO(axl2);
        }
        za3.vr().aQg();
    }

    @Override
    public void clearStepsAtX(int n4, int n5) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(10);
        this.validX(n5);
        this.validChannel(n4);
        this.exec(() -> this.doClearStepsAtX(n4, n5));
    }

    private void doClearStepsAtX(int n4, int n5) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 == null) {
            return;
        }
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        double d3 = this.getTimeForCell(n5);
        double d4 = d3 + this.getStepSize() - 1.0E-4;
        for (int i2 = 0; i2 < 128; ++i2) {
            eos eos2 = qtB2.gX_().DVW(n4, i2, false);
            if (eos2 == null) continue;
            List list = eos2.lTJ(d3, d4);
            for (Axl axl2 : list) {
                eos2.gBO(axl2);
            }
        }
        za3.vr().aQg();
    }

    @Override
    public void clearSteps() {
        this.exec(this::doClearSteps);
    }

    private void doClearSteps() {
        Za za3 = (Za)this.getTarget();
        if (za3 != null) {
            qtB qtB2 = this.getInstrumentClip();
            if (qtB2 == null) {
                return;
            }
            qtB2.lTJ().nrS(-1.7976931348623157E308, Double.MAX_VALUE);
            za3.vr().aQg();
        }
    }

    @Override
    public void clearSteps(int n4) {
        this.deprecated(1, 10, "Use clearStepsAtY(channel, y) instead.");
        this.validY(n4);
        this.exec(() -> this.doClearSteps(0, n4));
    }

    @Override
    public void clearStepsAtY(int n4, int n5) {
        this.validY(n5);
        this.validChannel(n4);
        this.exec(() -> this.doClearSteps(n4, n5));
    }

    private void doClearSteps(int n4, int n5) {
        assert (bqP.lTJ(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 == null) {
            return;
        }
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        int n6 = n5 + this.mBaseKey;
        if (n6 < 0 || n6 >= 128) {
            return;
        }
        eos eos2 = qtB2.gX_().DVW(n4, n6, false);
        if (eos2 != null) {
            eos2.UY2();
        }
    }

    @Override
    public void selectStepContents(int n4, int n5, boolean bl2) {
        this.selectStepContentsCommon(0, n4, n5, bl2);
    }

    @Override
    public void selectStepContents(int n4, int n5, int n6, boolean bl2) {
        this.newSince(10);
        this.selectStepContentsCommon(n4, n5, n6, bl2);
    }

    void selectStepContentsCommon(int n4, int n5, int n6, boolean bl2) {
        this.validPosition(n4, n5, n6);
        this.exec(() -> this.doSelectStepContents(0, n5, n6, bl2));
    }

    private void doSelectStepContents(int n4, int n5, int n6, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 == null) {
            return;
        }
        qtB qtB2 = this.getInstrumentClip();
        if (qtB2 == null) {
            return;
        }
        int n7 = n6 + this.mBaseKey;
        double d3 = this.getTimeForCell(n5);
        double d4 = d3 + this.getStepSize() - 1.0E-4;
        if (n7 < 0 || n7 >= 128) {
            return;
        }
        eos eos2 = qtB2.gX_().DVW(n4, n7, false);
        List list = eos2 != null ? eos2.lTJ(d3, d4) : Collections.EMPTY_LIST;
        SU sU2 = za3.vr();
        if (bl2) {
            sU2.aQg();
        }
        for (dyk dyk2 : list) {
            sU2.lTJ(dyk2.DVW(0, false));
        }
    }

    @Override
    public void setStepSize(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.greaterThan(d3, 0.0, "lengthInBeatTime");
        this.exec(() -> this.doSetStepSize(d3));
    }

    private void doSetStepSize(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (this.mStepSize != d3) {
            this.mStepSize = d3;
            this.mStepGrid = new S1c(this.mStepSize);
            if (!this.mHasInvalidatedGrid && za3 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateTimerTask != null) {
                    this.mUpdateTimerTask.cancel();
                }
                this.mUpdateTimerTask = this.scheduleTimerTaskOnDocumentThread(this::updateGridFromTimer, 100L);
            }
        }
    }

    private void updateGridFromTimer() {
        assert (bqP.DVW(this.isDocumentThread()));
        assert (bqP.DVW(this.mUpdateTimerTask != null));
        this.updateGrid();
        this.mHasInvalidatedGrid = false;
        this.mUpdateTimerTask = null;
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n4) {
        return uLA.DVW((double)(this.mBaseStep + n4) * this.getStepSize());
    }

    private int getKeyForY(int n4) {
        return this.mBaseKey + n4;
    }

    private Mlr getClipEvent() {
        Za za3 = (Za)this.getTarget();
        if (za3 != null && za3.mcc() != null) {
            return za3.mcc();
        }
        return null;
    }

    private qtB getInstrumentClip() {
        Mlr mlr = this.getClipEvent();
        return mlr instanceof qtB ? (qtB)mlr : null;
    }

    private void invalidateGrid() {
        assert (bqP.DVW(this.isDocumentThread()));
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            FnS.j_().hAB(() -> {
                this.updateGrid();
                this.mHasInvalidatedGrid = false;
            });
        }
    }

    private void updateGrid() {
        JkZ jkZ;
        assert (bqP.XHT(this.isDocumentThread()));
        qtB qtB2 = this.getInstrumentClip();
        Za za3 = (Za)this.getTarget();
        double d3 = this.getTimeForCell(0);
        double d4 = this.getTimeForCell(this.mGridWidth - 1) + this.getStepSize() - 1.0E-4;
        if (qtB2 != null) {
            assert (bqP.lTJ(qtB2.aeR().hAB()));
            jkZ = qtB2.gX_();
        } else {
            jkZ = null;
        }
        boolean bl2 = false;
        HashMap<Integer, NoteStep> hashMap = new HashMap<Integer, NoteStep>();
        List list = jkZ != null ? jkZ.DVW(d3, d4) : Collections.emptyList();
        for (Ann ann2 : list) {
            Axl axl2 = (Axl)ann2;
            boolean bl3 = za3.vr().DVW(axl2);
            bl2 |= bl3;
            double d5 = axl2.KQG();
            double d6 = axl2.nlg();
            int n4 = Math.max(0, (int)Math.floor((d5 - d3) / this.getStepSize()));
            int n5 = axl2.lTJ();
            int n6 = n5 - this.mBaseKey;
            int n7 = axl2.UY2();
            if (n6 < 0 || this.mGridHeight <= n6) continue;
            assert (bqP.DVW(NBU.jpF(n5)));
            assert (bqP.DVW(NBU.nrS(n7)));
            assert (bqP.DVW(n4 >= 0 && n4 < this.mGridWidth));
            assert (bqP.DVW(n6 >= 0 && n6 < this.mGridHeight));
            int n8 = d5 < d3 ? 1 : 2;
            NoteStep noteStep = new NoteStep(n4, n6, n7, this);
            noteStep.setCachedVelocity(axl2.nrS());
            noteStep.setCachedReleaseVelocity(axl2.jpF());
            noteStep.setCachedDuration(axl2.bMm());
            noteStep.setCachedIsSelected(bl3);
            fgT fgT2 = axl2.gY_();
            Dmu dmu = fgT2.kV_();
            if (dmu == null) {
                noteStep.setCachedPan(0.0);
            } else {
                noteStep.setCachedPan(((vIy)dmu.gBO().get(0)).gBO());
            }
            Uzc uzc = fgT2.pxg();
            if (uzc == null) {
                noteStep.setCachedTranspose(0.0);
            } else {
                noteStep.setCachedTranspose(((vIy)uzc.gBO().get(0)).gBO());
            }
            HDN hDN = fgT2.gBO();
            if (hDN == null) {
                noteStep.setCachedTimbre(0.0);
            } else {
                noteStep.setCachedTimbre(((vIy)hDN.gBO().get(0)).gBO());
            }
            I3E i3E = fgT2.lTJ();
            if (i3E == null) {
                noteStep.setCachedPressure(0.0);
            } else {
                noteStep.setCachedPressure(((vIy)i3E.gBO().get(0)).gBO());
            }
            mw mw2 = fgT2.Mdo();
            if (mw2 == null) {
                noteStep.setCachedGain(0.5);
            } else {
                noteStep.setCachedGain(((vIy)mw2.gBO().get(0)).fJ1());
            }
            noteStep.setCachedNoteState(n8);
            noteStep.setCachedIsSelected(bl3);
            hashMap.put(this.computeStepInfoIndex(n7, n4, n6), noteStep);
            for (int i2 = n4 + 1; i2 < this.mGridWidth && this.getTimeForCell(i2) < d6; ++i2) {
                assert (bqP.DVW(0 <= i2 && i2 < this.mGridWidth));
                NoteStep noteStep2 = new NoteStep(i2, n6, n7, this);
                noteStep2.copy(noteStep);
                noteStep2.setCachedNoteState(1);
                hashMap.put(this.computeStepInfoIndex(n7, i2, n6), noteStep2);
            }
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
        this.sendNoteStateToObservers(hashMap);
    }

    protected int computeStepInfoIndex(int n4, int n5, int n6) {
        return n4 + 16 * (n5 + n6 * this.mGridWidth);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public void addNoteStepObserver(NoteStepChangedCallback noteStepChangedCallback) {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(noteStepChangedCallback, "callback");
        this.mNoteDataChangedCallback.add(noteStepChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (bqP.XHT(this.isDocumentThread()));
        oTe oTe2 = this.getDocument();
        Za za3 = (Za)this.getTarget();
        if (za3 != null && oTe2 != null) {
            jaI jaI2 = za3.mcc();
            rMD rMD2 = (rMD)jaI2.lTJ(rMD.class);
            if (rMD2 != null) {
                Tcb tcb = oTe2.WRh().nrS();
                tcb.fJ1(rMD2);
                tcb.lsC();
                if (tcb.jgL()) {
                    tcb.bOf();
                }
            }
            jaI2.xwE();
        }
    }

    @Override
    public void duplicateContent() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 != null) {
            za3.mcc().xwE();
        }
    }

    @Override
    public void transpose(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n4));
    }

    private void doTranspose(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 != null) {
            za3.mcc().DVW(n4);
        }
    }

    @Override
    public void quantize(double d3) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (d3 <= 0.0 || d3 > 1.0) {
            throw new FVt("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d3));
    }

    private void doQuantize(double d3) {
        assert (bqP.XHT(this.isDocumentThread()));
        Za za3 = (Za)this.getTarget();
        if (za3 != null) {
            za3.DVW(d3, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackSection;
    }

    protected void connectToTarget(Za za3) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(za3 != null));
        jaI jaI2 = za3.mcc();
        Rzu rzu = jaI2.LsI();
        qtB qtB2 = this.getInstrumentClip();
        this.mUseLoopStartAsQuantizationReference.setTarget(jaI2.c3j());
        this.mLaunchMode.setTarget(jaI2.wr());
        this.mLegatoMode.setTarget(jaI2.EAf());
        if (qtB2 != null) {
            qtB2.lTJ().XHT(this.mPlaybackPositionListener);
            qtB2.bAk().DVW(this.mHierarchyListener);
        }
        za3.vr().CGM().DVW(this.mSelectionChangeListener);
        rzu.DVW(this.mClipEventsChanged);
        this.mShuffle.setTarget(rzu.kQ_());
        this.mAccent.setTarget(rzu.D2F());
        dat dat2 = rzu.Mdo();
        this.mPlayStart.setTarget(dat2.dP_().iRb());
        this.mPlayStop.setTarget(dat2.lh_().iRb());
        this.mIsLoopEnabled.setTarget(dat2.fJ1());
        this.mLoopStart.setTarget(dat2.pxg().iRb());
        this.mLoopLength.setTarget(dat2.pxg().nDt());
        this.mColor.setTarget(jaI2.gR_(), jaI2.UY2());
        this.mLaunchQuantization.setTarget(jaI2.zRa());
        if (this.mTrackSection != null) {
            rMD rMD2;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackSection.getClipLauncherSlots();
            MwI mwI = jaI2.pkX();
            this.mTrackSection.setTarget(mwI);
            if (clipLauncherSlotBankProxy != null && (rMD2 = (rMD)jaI2.lTJ(rMD.class)) != null) {
                this.mClipLauncherSlot.setTarget(rMD2);
                clipLauncherSlotBankProxy.scrollToScene(rMD2);
            }
        }
        this.connectObservers(jaI2);
    }

    protected void disconnectFromTarget(Za za3) {
        assert (bqP.XHT(za3 != null));
        jaI jaI2 = za3.mcc();
        this.disconnectObservers(jaI2);
        qtB qtB2 = this.getInstrumentClip();
        if (this.mTrackSection != null) {
            this.mTrackSection.clearTarget();
        }
        if (qtB2 != null) {
            qtB2.lTJ().hAB(this.mPlaybackPositionListener);
            qtB2.bAk().gBO(this.mHierarchyListener);
        }
        Rzu rzu = jaI2.LsI();
        rzu.gBO(this.mClipEventsChanged);
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        this.mLaunchQuantization.clearTarget();
        this.mUseLoopStartAsQuantizationReference.clearTarget();
        this.mClipLauncherSlot.clearTarget();
        this.mLaunchMode.clearTarget();
        this.mLegatoMode.clearTarget();
        za3.vr().CGM().gBO(this.mSelectionChangeListener);
        this.setPlayingStep(-1);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateGrid();
    }

    private void sendNoteStateToObservers(HashMap hashMap) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.queueCallback(() -> this.doSendNoteStateToObservers(hashMap));
    }

    private void doSendNoteStateToObservers(HashMap hashMap) {
        NoteStep noteStep;
        NoteStep noteStep2;
        HashMap hashMap2 = this.mNoteSteps;
        this.mNoteSteps = hashMap;
        Set set = hashMap2.keySet();
        Set set2 = hashMap.keySet();
        for (Integer n4 : set2) {
            noteStep2 = (NoteStep)hashMap.get(n4);
            noteStep = (NoteStep)hashMap2.get(n4);
            if (noteStep != null && noteStep.equals(noteStep2)) continue;
            this.notifyNoteStepToObservers(noteStep2);
        }
        for (Integer n4 : set) {
            noteStep2 = (NoteStep)hashMap.get(n4);
            if (noteStep2 != null) continue;
            noteStep = (NoteStep)hashMap2.get(n4);
            assert (bqP.DVW(noteStep.checkBounds(this.mGridWidth, this.mGridHeight)));
            NoteStep noteStep3 = new NoteStep(noteStep.x(), noteStep.y(), noteStep.channel(), this);
            this.notifyNoteStepToObservers(noteStep3);
        }
    }

    private void notifyNoteStepToObservers(NoteStep noteStep) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.DVW(noteStep.checkBounds(this.mGridWidth, this.mGridHeight)));
        for (Callback callback : this.mNoteDataChangedCallback) {
            callback.noteStepChanged(noteStep);
        }
        for (Callback callback : this.mStepDataChangedCallbacks) {
            callback.stepStateChanged(noteStep.x(), noteStep.y(), noteStep.noteState());
        }
    }

    private void setPlayingStep(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(n4 >= -1));
        if (n4 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n4;
            this.mPlayingStep.setIntegerValue(n4);
        }
    }

    private void validPosition(int n4, int n5, int n6) {
        this.validChannel(n4);
        this.validPosition(n5, n6);
    }

    private void validPosition(int n4, int n5) {
        this.validX(n4);
        this.validY(n5);
    }

    private void validChannel(int n4) {
        this.inRange(n4, 0, 15, "channel");
    }

    private void validKey(int n4) {
        this.inRange(n4, 0, 127, "key");
    }

    private void validX(int n4) {
        this.inRange(n4, 0, this.mGridWidth - 1, "x");
    }

    private void validY(int n4) {
        this.inRange(n4, 0, this.mGridHeight - 1, "y");
    }

    @Override
    public SettableEnumValue launchQuantization() {
        this.newSince(8);
        return this.mLaunchQuantization;
    }

    @Override
    public SettableBooleanValue useLoopStartAsQuantizationReference() {
        this.newSince(8);
        return this.mUseLoopStartAsQuantizationReference;
    }

    @Override
    public SettableBooleanValue launchLegato() {
        this.deprecated(8, 9);
        return this.mLegatoMode;
    }

    @Override
    public SettableEnumValue launchMode() {
        this.newSince(9);
        return this.mLaunchMode;
    }

    @Override
    public ClipLauncherSlot clipLauncherSlot() {
        this.newSince(10);
        return this.mClipLauncherSlot;
    }

    @Override
    public void launch() {
        this.newSince(10);
        this.exec(this::doLaunch);
    }

    private void doLaunch() {
        assert (bqP.DVW(this.isDocumentThread()));
        Mlr mlr = this.getClipEvent();
        if (mlr != null) {
            mlr.qhn(true);
        }
    }

    @Override
    public com.bitwig.extension.controller.api.NoteStep getStep(int n4, int n5, int n6) {
        this.newSince(10);
        this.validPosition(n4, n5, n6);
        NoteStep noteStep = (NoteStep)this.mNoteSteps.get(this.computeStepInfoIndex(n4, n5, n6));
        if (noteStep == null) {
            noteStep = new NoteStep(n5, n6, n4, this);
        }
        return noteStep;
    }
}

