/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NotePlaybackCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.Send;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableStringValue;
import com.bitwig.extension.controller.api.SoloValue;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$1;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$2;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$VuMeterObserver;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.SendBankProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedPlayingNoteArrayValue;
import com.bitwig.flt.control_surface.values.PlayingNote;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.flt.control_surface.values.SoloProxy;
import com.bitwig.flt.document.core.iface.GXb;
import com.bitwig.flt.document.core.iface.Rfh;
import com.bitwig.flt.document.core.iface.oTe;
import com.bitwig.ramona.core.z;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ChannelProxy
extends DeviceChainProxy
implements Channel {
    protected final SettableBooleanValueProxy mIsActivated;
    protected final SettableBooleanValueProxy mMute;
    protected final SoloProxy mSolo;
    protected final Map mPlayingNotes = new HashMap();
    protected final ComputedPlayingNoteArrayValue mPlayingNotesValue;
    protected final RemappableParameterProxy mVolume;
    protected final RemappableParameterProxy mPan;
    protected final SettableColorValueProxy mColor;
    private final SettableStringValueProxy mNameProxy;
    protected final SendBankProxy mSendBankProxy;
    private final List mNotePlaybackCallbacks = new ArrayList();
    private ljE mNoteObserverAtom;
    private final BAN mNotePlaybackListener = lzp2 -> this.notePlayed(lzp2.XHT(), lzp2.hAB(), lzp2.lTJ());
    private boolean mHasScheduledUpdatePlayingNotes = false;
    private final BooleanValueProxy mIsMutedBySolo;

    public ChannelProxy(ControlSurfaceObject controlSurfaceObject, String string, int n4, int n5) {
        super(controlSurfaceObject, string);
        this.mNameProxy = new SettableStringValueProxy(this);
        this.mIsActivated = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mMute = new SettableBooleanValueProxy(this);
        this.mPan = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Pan");
        this.mPan.setHardwareControlType(HardwareControlType.KNOB);
        this.mVolume = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Volume");
        this.mVolume.setHardwareControlType(HardwareControlType.SLIDER);
        this.mSolo = new SoloProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mPlayingNotesValue = new ComputedPlayingNoteArrayValue(this);
        this.mIsMutedBySolo = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.addChild(this.mIsActivated);
        this.addChild(this.mMute);
        this.addChild(this.mSolo);
        this.addChild(this.mVolume);
        this.addChild(this.mPan);
        this.addChild(this.mPlayingNotesValue);
        this.mVolume.setIndexInGroup(n4);
        this.mPan.setIndexInGroup(n4);
        this.mSendBankProxy = n5 > 0 ? new SendBankProxy(this, string + "/Send/", n5, n4) : null;
    }

    @Override
    protected int getNumSends() {
        return this.mSendBankProxy != null ? this.mSendBankProxy.getSizeOfBank() : 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void duplicate() {
        this.exec(() -> {
            FKF fKF;
            if (this.getTarget() != null && (fKF = this.getEditorChannelSelection((GXb)this.getTarget())) != null) {
                fKF.fJ1((z)this.getTarget());
                fKF.lsC();
                if (fKF.jgL()) {
                    fKF.bOf();
                }
            }
        });
    }

    @Override
    public SettableBooleanValue isActivated() {
        return this.mIsActivated;
    }

    @Override
    public RemappableParameterProxy getVolume() {
        this.deprecated(1, 5, "Use volume() instead");
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy volume() {
        this.newSince(5);
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy getPan() {
        this.deprecated(1, 5, "Use pan() instead");
        return this.mPan;
    }

    @Override
    public RemappableParameterProxy pan() {
        this.newSince(5);
        return this.mPan;
    }

    @Override
    public SettableBooleanValue getMute() {
        this.deprecated(1, 5, "Use mute() instead");
        return this.mMute;
    }

    @Override
    public SettableBooleanValue mute() {
        this.newSince(5);
        return this.mMute;
    }

    @Override
    public SoloProxy getSolo() {
        this.deprecated(1, 5, "Use solo() instead");
        return this.mSolo;
    }

    @Override
    public SoloValue solo() {
        this.newSince(5);
        return this.mSolo;
    }

    @Override
    public BooleanValue isMutedBySolo() {
        this.newSince(10);
        return this.mIsMutedBySolo;
    }

    @Override
    public SendBankProxy sendBank() {
        if (this.mSendBankProxy == null) {
            throw new FVt("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy;
    }

    public SendBankProxy getSendBankOnDocumentThread() {
        assert (bqP.DVW(this.isDocumentThread()));
        return this.mSendBankProxy;
    }

    @Override
    public Send getSend(int n4) {
        if (this.mSendBankProxy == null) {
            if (this.getRequiredApiVersion() == 1) {
                return null;
            }
            throw new FVt("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy.getItemAt(n4);
    }

    @Override
    public SettableStringValue name() {
        this.newSince(2);
        return this.mNameProxy;
    }

    @Override
    public void addNameObserver(int n4, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use name() instead");
        this.mNameProxy.addValueObserver(n4, string, stringValueChangedCallback);
    }

    @Override
    public void addVuMeterObserver(int n4, int n5, boolean bl2, IntegerValueChangedCallback integerValueChangedCallback) {
        if (n5 < -1 || n5 > 1) {
            throw new FVt("No such channel.");
        }
        this.addObserver(new ChannelProxy$VuMeterObserver(this.getControlSurface(), integerValueChangedCallback, n4, n5, bl2));
    }

    @Override
    public ComputedPlayingNoteArrayValue playingNotes() {
        return this.mPlayingNotesValue;
    }

    @Override
    public void addNoteObserver(NotePlaybackCallback notePlaybackCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(notePlaybackCallback, "callback");
        this.mNotePlaybackCallbacks.add(notePlaybackCallback);
    }

    private void notePlayed(boolean bl2, int n4, float f2) {
        assert (bqP.XHT(this.isDocumentThread()));
        if (!this.mNotePlaybackCallbacks.isEmpty()) {
            this.queueCallback(() -> this.notifyNotePlayed(bl2, n4, f2));
        }
        if (!this.mPlayingNotesValue.isInterested()) {
            return;
        }
        if (bl2) {
            this.mPlayingNotes.put(n4, new PlayingNote(n4, (int)(127.0f * f2)));
        } else {
            this.mPlayingNotes.remove(n4);
        }
        this.invalidatePlayingNotes();
    }

    private void invalidatePlayingNotes() {
        assert (bqP.DVW(this.isDocumentThread()));
        if (!this.mHasScheduledUpdatePlayingNotes) {
            this.mHasScheduledUpdatePlayingNotes = true;
            this.runAtEndOfEvent(this::updatePlayingNotes);
        }
    }

    private void updatePlayingNotes() {
        assert (bqP.DVW(this.isDocumentThread()));
        this.mHasScheduledUpdatePlayingNotes = false;
        PlayingNote[] playingNoteArray = this.mPlayingNotes.values().toArray(new PlayingNote[0]);
        this.mPlayingNotesValue.setValue(playingNoteArray);
    }

    private void notifyNotePlayed(boolean bl2, int n4, float f2) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        for (NotePlaybackCallback notePlaybackCallback : this.mNotePlaybackCallbacks) {
            notePlaybackCallback.notePlaybackEventOccurred(bl2, n4, f2);
        }
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    public bIC getColor() {
        HBA hBA = this.mColor.getEditableValue();
        if (hBA != null) {
            return (bIC)hBA.getValue();
        }
        return null;
    }

    protected abstract FKF getEditorChannelSelection(GXb var1);

    protected FKF getMixerChannelSelection() {
        oTe oTe2 = this.getDocument();
        if (oTe2 != null) {
            return oTe2.WRh().gBO();
        }
        return null;
    }

    @Override
    public void addIsSelectedInEditorObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new ChannelProxy$1(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void addIsSelectedInMixerObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new ChannelProxy$2(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void selectInEditor() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doSelectInEditor);
    }

    private void doSelectInEditor() {
        FKF fKF;
        assert (bqP.XHT(this.isDocumentThread()));
        eK eK2 = this.getDocumentGUIWrapper();
        if (eK2 != null && this.getTarget() != null && (fKF = this.getEditorChannelSelection((GXb)this.getTarget())) != null) {
            fKF.qhn((z)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void selectInMixer() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doSelectInMixer);
    }

    private void doSelectInMixer() {
        FKF fKF;
        assert (bqP.XHT(this.isDocumentThread()));
        eK eK2 = this.getDocumentGUIWrapper();
        if (eK2 != null && this.getTarget() != null && (fKF = this.getMixerChannelSelection()) != null) {
            fKF.qhn((z)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void makeVisibleInMixer() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInMixer);
    }

    private void doMakeVisibleInMixer() {
        fm fm2;
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.getTarget() != null && (fm2 = this.getDocumentWidget()) != null) {
            List list = fm2.XHT(afM.class, true);
            for (afM afM2 : list) {
                afM2.DVW((GXb)this.getTarget());
            }
        }
    }

    @Override
    public void makeVisibleInArranger() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInArranger);
    }

    private void doMakeVisibleInArranger() {
        fm fm2;
        assert (bqP.XHT(this.isDocumentThread()));
        if (this.getTarget() instanceof Rfh && (fm2 = this.getDocumentWidget()) != null) {
            List list = fm2.XHT(io.class, true);
            for (io io2 : list) {
                io2.gBO((Rfh)this.getTarget());
            }
        }
    }

    @Override
    protected String getName() {
        GXb gXb = (GXb)this.getTarget();
        if (gXb != null) {
            return gXb.dS_();
        }
        return "(none)";
    }

    protected void connectToTarget(GXb gXb) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(gXb != null));
        assert (bqP.XHT(gXb.SlJ()));
        hZV hZV2 = gXb.dV_();
        this.mNameProxy.setTarget(gXb.WqU(), gXb.Xnp());
        this.mIsActivated.setTarget(gXb.wr());
        this.mMute.setTarget(hZV2.jJc().ypE());
        this.mSolo.setMixerModule(hZV2);
        this.mVolume.setTargetAtom(hZV2.fe_());
        this.mPan.setTargetAtom(hZV2.jpF());
        this.mColor.setTarget(gXb.HRs(), gXb.Kor());
        this.mPlayingNotes.clear();
        this.mIsMutedBySolo.setTarget(hZV2.LsI());
        this.invalidatePlayingNotes();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.setTarget(gXb);
        }
        assert (bqP.XHT(this.mNoteObserverAtom == null));
        this.mNoteObserverAtom = gXb.LsI();
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.XHT(this.mNotePlaybackListener);
            this.mNoteObserverAtom.ypE().gBO();
        }
        for (HUd hUd : this.getObservers()) {
            if (!(hUd instanceof ChannelProxy$VuMeterObserver)) continue;
            ChannelProxy$VuMeterObserver channelProxy$VuMeterObserver = (ChannelProxy$VuMeterObserver)hUd;
            int n4 = channelProxy$VuMeterObserver.mChannel;
            if (channelProxy$VuMeterObserver.mPeak) {
                channelProxy$VuMeterObserver.sendValue(((Fd)hZV2.fJ1().eq_().get(n4)).er_());
                ((Fd)hZV2.fJ1().eq_().get(n4)).XHT(channelProxy$VuMeterObserver);
                continue;
            }
            channelProxy$VuMeterObserver.sendValue(((Fd)hZV2.fJ1().eq_().get(n4)).gBO());
            ((Fd)hZV2.fJ1().eq_().get(n4)).DVW(channelProxy$VuMeterObserver);
        }
        this.setDeviceChain(gXb.ft_());
        this.connectObservers(gXb);
    }

    protected void disconnectFromTarget(GXb gXb) {
        assert (bqP.XHT(this.getTarget() != null));
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.hAB(this.mNotePlaybackListener);
            this.mNoteObserverAtom.ypE().lTJ();
            this.mNoteObserverAtom = null;
        }
        this.mNameProxy.clearTarget();
        this.disconnectObservers(gXb);
        this.setDeviceChain(null);
        hZV hZV2 = ((GXb)this.getTarget()).dV_();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.clearTarget();
        }
        for (HUd hUd : this.getObservers()) {
            if (!(hUd instanceof ChannelProxy$VuMeterObserver)) continue;
            ChannelProxy$VuMeterObserver channelProxy$VuMeterObserver = (ChannelProxy$VuMeterObserver)hUd;
            int n4 = channelProxy$VuMeterObserver.mChannel;
            Fd fd2 = (Fd)hZV2.fJ1().eq_().get(n4);
            if (channelProxy$VuMeterObserver.mPeak) {
                fd2.hAB(channelProxy$VuMeterObserver);
            } else {
                fd2.gBO(channelProxy$VuMeterObserver);
            }
            channelProxy$VuMeterObserver.sendValue(0.0);
        }
        this.mIsActivated.clearTarget();
        this.mMute.clearTarget();
        this.mSolo.setMixerModule(null);
        this.mVolume.clearTarget();
        this.mPan.clearTarget();
        this.mColor.clearTarget();
        this.mIsMutedBySolo.clearTarget();
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
    }

    protected GXb getChannel() {
        return (GXb)this.getTarget();
    }

    @Override
    public void deleteObject() {
        assert (bqP.DVW(this.isControlSurfaceThread()));
        this.newSince(10);
        this.getHost().deleteObjects("Delete Channel From Controller", this);
    }
}

