/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.ChannelBank;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.ramona.core.z;

public abstract class ChannelBankProxy
extends ControlSurfaceDocumentObjectProxy
implements cPe,
ChannelBank {
    protected final int mNumChannels;
    protected final int mNumSends;
    protected final ListValueBankItemTargetUpdater mChannelBankUpdater;
    protected final ControlSurfaceProxy[] mChannels;
    protected int mChannelScrollStepSize = 1;
    private dIf mChannelsListValue;

    public ChannelBankProxy(ControlSurfaceObject controlSurfaceObject, String string, int n4, int n5) {
        super(controlSurfaceObject);
        this.setKey(string);
        if (n4 < 1) {
            throw new FVt("At least 1 track is required.");
        }
        this.mNumChannels = n4;
        this.mNumSends = n5;
        this.mChannels = new ControlSurfaceProxy[this.mNumChannels];
        this.mChannelBankUpdater = new ListValueBankItemTargetUpdater(this, this.mChannels, this.getScrollPositionThatPageShouldAlignTo());
    }

    protected void initChannelProxies() {
        for (int i2 = 0; i2 < this.mNumChannels; ++i2) {
            ControlSurfaceProxy controlSurfaceProxy;
            this.mChannels[i2] = controlSurfaceProxy = this.createChannelProxy(this.mNumSends, i2, this.getKey());
            this.addChild(controlSurfaceProxy);
        }
    }

    @Override
    public int getSizeOfBank() {
        return this.mChannelBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n4) {
        this.mChannelBankUpdater.setSizeOfBank(n4);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mChannelBankUpdater.getCapacityOfBank();
    }

    @Override
    public Channel getItemAt(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return (Channel)((Object)this.mChannelBankUpdater.getItemAt(n4));
    }

    @Override
    public IntegerValue itemCount() {
        return this.mChannelBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mChannelBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mChannelBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n4) {
        this.newSince(7);
        this.mChannelBankUpdater.scrollIntoView(n4);
    }

    @Override
    public void scrollBy(int n4) {
        this.mChannelBankUpdater.scrollBy(n4);
    }

    @Override
    public void doStepForwards() {
        this.mChannelBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mChannelBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n4) {
        this.mChannelBankUpdater.scrollByPages(n4);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mChannelBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mChannelBankUpdater.getCanScrollForwards();
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mChannelBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mChannelBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mChannelBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mChannelBankUpdater.scrollPageForwardsAction();
    }

    protected abstract ControlSurfaceProxy createChannelProxy(int var1, int var2, String var3);

    public void setTarget(z z2) {
        z z3 = (z)this.getTarget();
        if (z2 != z3) {
            this.setChannelsListValue(z2 != null ? this.getChannelsListValueFromTarget(z2) : null);
            super.setTarget(z2);
        }
    }

    protected abstract dIf getChannelsListValueFromTarget(z var1);

    protected dIf getChannelsListValue() {
        return this.mChannelsListValue;
    }

    private void setChannelsListValue(dIf dIf2) {
        if (dIf2 != this.mChannelsListValue) {
            this.mChannelsListValue = dIf2;
            this.mChannelBankUpdater.setTarget(dIf2);
        }
    }

    protected int getScrollPositionThatPageShouldAlignTo() {
        return 0;
    }

    @Override
    public void scrollChannelsPageUp() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollChannelsPageDown() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollChannelsUp() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollBy(-this.mChannelScrollStepSize);
    }

    @Override
    public void scrollChannelsDown() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollBy(this.mChannelScrollStepSize);
    }

    @Override
    public void scrollToChannel(int n4) {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollIntoView(n4);
    }

    @Override
    public void scrollSendsPageUp() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollPageBackwards();
        }
    }

    @Override
    public void scrollSendsPageDown() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollPageForwards();
        }
    }

    @Override
    public void scrollSendsUp() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollBackwards();
        }
    }

    @Override
    public void scrollSendsDown() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollForwards();
        }
    }

    @Override
    public void scrollToSend(int n4) {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollPosition().set(n4);
        }
    }

    @Override
    public Channel getChannel(int n4) {
        this.deprecated(1, 6);
        if (this.mChannels != null && n4 >= 0 && n4 < this.mNumChannels) {
            return (Channel)((Object)this.mChannels[n4]);
        }
        return null;
    }

    @Override
    public void setChannelScrollStepSize(int n4) {
        this.atLeast(n4, 1, "stepSize");
        this.mChannelScrollStepSize = n4;
    }

    @Override
    public IntegerValue channelScrollPosition() {
        this.newSince(2);
        return this.mChannelBankUpdater.getScrollPosition();
    }

    @Override
    public void addChannelScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n4) {
        this.mChannelBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n4);
    }

    @Override
    public void addCanScrollChannelsUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollChannelsUp().addValueObserver(callback)");
        this.mChannelBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollChannelsUp() {
        this.newSince(2);
        return this.mChannelBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollChannelsDown() {
        this.newSince(2);
        return this.mChannelBankUpdater.getCanScrollForwards();
    }

    @Override
    public void addCanScrollChannelsDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollChannelsDown().addValueObserver(callback)");
        this.mChannelBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollSendsUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
    }

    @Override
    public void addCanScrollSendsDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
    }

    @Override
    public IntegerValue channelCount() {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return this.mChannelBankUpdater.getListItemCount();
    }

    @Override
    public void addChannelCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.deprecated(1, 2, "Use channelCount().addValueObserver(callback)");
        this.mChannelBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addSendCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
    }

    public ListValueBankItemTargetUpdater getChannelBankUpdater() {
        return this.mChannelBankUpdater;
    }
}

