/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.BrowserItem;
import com.bitwig.extension.controller.api.BrowserItemBank;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BrowserColumnProxy;
import com.bitwig.flt.control_surface.proxy.BrowserItemProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObjectProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;

public abstract class BrowserItemBankProxy
extends ControlSurfaceObjectProxy
implements cPe,
BrowserItemBank {
    private final ListValueBankItemTargetUpdater mBankUpdater;
    protected BrowserItemProxy[] mItemProxies;

    public BrowserItemBankProxy(BrowserColumnProxy browserColumnProxy, int n4) {
        super(browserColumnProxy);
        if (n4 < 1) {
            throw new FVt("Item bank size must be >= 1");
        }
        this.mItemProxies = new BrowserItemProxy[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            this.mItemProxies[i2] = this.createResultProxy(i2, browserColumnProxy);
        }
        this.mBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mItemProxies);
    }

    public BrowserColumnProxy getColumn() {
        return (BrowserColumnProxy)this.getParent();
    }

    protected abstract BrowserItemProxy createResultProxy(int var1, BrowserColumnProxy var2);

    @Override
    public int getSizeOfBank() {
        return this.mBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n4) {
        this.mBankUpdater.setSizeOfBank(n4);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mBankUpdater.getCapacityOfBank();
    }

    @Override
    public int getSize() {
        return this.getSizeOfBank();
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n4) {
        this.newSince(7);
        this.mBankUpdater.scrollIntoView(n4);
    }

    @Override
    public void scrollBy(int n4) {
        this.mBankUpdater.scrollBy(n4);
    }

    @Override
    public void doStepForwards() {
        this.mBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n4) {
        this.mBankUpdater.scrollByPages(n4);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public BrowserItem getItemAt(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return (BrowserItem)((Object)this.mBankUpdater.getItemAt(n4));
    }

    @Override
    public BrowserItem getItem(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        return (BrowserItem)((Object)this.mBankUpdater.getItemAt(n4));
    }

    @Override
    public void scrollUp() {
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollPageUp() {
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.mBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    protected void connectToTarget(Object object) {
        dIf dIf2 = this.getResultsListValue(object);
        assert (bqP.XHT(dIf2 != null));
        this.mBankUpdater.setTarget(dIf2);
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        this.mBankUpdater.clearTarget();
    }

    protected abstract dIf getResultsListValue(Object var1);

    public void scrollToItem(zKU zKU2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(zKU2 != null));
        Object object = this.getTarget();
        if (object != null) {
            this.mBankUpdater.doScrollToItem(zKU2);
        }
    }
}

