/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.ramona.core.z;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BankItemTargetUpdater
extends ControlSurfaceProxy
implements AdS {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private boolean mHasScheduledUpdate;
    private z mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;
    private int mSize;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n4) {
        super(controlSurfaceObject);
        assert (bqP.XHT(controlSurfaceProxyArray != null));
        assert (bqP.XHT(n4 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mSize = controlSurfaceProxyArray.length;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n4;
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    public void setSizeOfBank(int n4) {
        this.newSince(7);
        this.inRange(n4, 0, this.getCapacityOfBank(), "size");
        this.mSize = n4;
    }

    public int getSizeOfBank() {
        return this.mSize;
    }

    public int getCapacityOfBank() {
        this.newSince(7);
        return this.mItemProxies.length;
    }

    public HardwareActionBindable scrollBackwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollBackwards);
    }

    public HardwareActionBindable scrollForwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollForwards);
    }

    public HardwareActionBindable scrollPageBackwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollPageBackwards);
    }

    public HardwareActionBindable scrollPageForwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollPageForwards);
    }

    public ControlSurfaceProxy getItemAt(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.inRange(n4, 0, this.getSizeOfBank(), "index");
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n4);
    }

    public void scrollTo(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.postEvent(sLv.DVW(this, Math.max(0, n4)));
    }

    public void scrollIntoView(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.postEvent(sLv.gBO(this, Math.max(0, n4)));
    }

    public void doScrollTo(int n4, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(n4 >= 0));
        if (n4 >= this.mListItemCount.getValue()) {
            return;
        }
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n4, bl2);
        } else {
            this.doScrollToImpl(n4, bl2);
        }
    }

    protected int quantizePosition(int n4, int n5) {
        assert (bqP.XHT(this.isDocumentThread()));
        int n6 = this.mItemProxies.length;
        int n7 = n6 < this.mScrollPositionThatPageShouldAlignTo ? this.mScrollPositionThatPageShouldAlignTo % n6 : 0;
        int n8 = (n4 - n7) / n6 * n6 + n7;
        if (n8 < this.mScrollPosition.getValue() - n6) {
            n8 += n6;
        }
        int n9 = (n5 - 1) / n6 * n6;
        return S1V.DVW(n8, 0, n9);
    }

    private void doScrollToImpl(int n4, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        int n5 = bl2 ? this.mListItemCount.getValue() - 1 : this.mListItemCount.getValue() - this.mSize;
        int n6 = S1V.DVW(n4, 0, Math.max(0, n5));
        List list = this.getList();
        int n7 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n8 = n6 + i2;
            if (n8 < list.size()) {
                object = (z)list.get(n8);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n7 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n8);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                ((BankItemTargetUpdater)controlSurfaceProxy).doScrollToImpl(n6, bl2);
            }
        }
        this.mScrollPosition.setIntegerValue(n6);
        if (n7 >= 0) {
            this.mCursorIndex.setIntegerValue(n7);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n6 + this.getSizeOfBank() < list.size());
        this.mCanScrollBackwards.setBoolValue(n6 > 0);
    }

    public void scrollBy(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (n4 != 0) {
            this.postEvent(sLv.DVW(this, n4, Math.abs(n4) > 1));
        }
    }

    public void doScrollForwards() {
        this.doScrollBy(1, false);
    }

    public void doScrollBackwards() {
        this.doScrollBy(-1, false);
    }

    public void doScrollPageForwards() {
        this.doScrollBy(this.mItemProxies.length, true);
    }

    public void doScrollPageBackwards() {
        this.doScrollBy(-this.mItemProxies.length, true);
    }

    public void doScrollBy(int n4, boolean bl2) {
        assert (bqP.XHT(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n4), bl2);
    }

    public void scrollByPages(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        this.scrollBy(n4 * this.mItemProxies.length);
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public SettableIntegerValue getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (bqP.XHT(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public void listChanged() {
        assert (bqP.XHT(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::update);
        }
    }

    private void update() {
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        this.update(list);
        this.mHasScheduledUpdate = false;
    }

    @Override
    protected void connectToTarget(Object object) {
        this.update();
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mItemProxies) {
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getList() {
        assert (bqP.XHT(this.isDocumentThread()));
        Object object = this.getTarget();
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        return this.calculateList(object);
    }

    protected abstract List calculateList(Object var1);

    protected void update(List list) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(list != null));
        int n4 = list.size() <= this.mItemProxies.length ? 0 : this.determineNewOffset(list);
        assert (bqP.XHT(n4 >= 0));
        assert (bqP.XHT(this.mItemProxies.length < list.size() ? n4 + this.mItemProxies.length <= list.size() : n4 == 0));
        int n5 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n6 = n4 + i2;
            if (n6 < list.size()) {
                object = (z)list.get(n6);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && object == this.mCursor) {
                    n5 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n6);
        }
        Object object = this.getTarget();
        if (object != null) {
            this.mScrollPosition.setIntegerValue(n4);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n4 + this.getSizeOfBank() < list.size());
            this.mCanScrollBackwards.setBoolValue(n4 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n5 >= 0) {
            this.mCursorIndex.setIntegerValue(n5);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (bqP.XHT(list.size() >= this.mItemProxies.length));
        assert (bqP.XHT(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mItemProxies) {
            int n4;
            z z2 = (z)controlSurfaceProxy.getTarget();
            if (z2 == null || (n4 = list.indexOf(z2)) < 0) continue;
            return S1V.DVW(n4, 0, list.size() - this.mItemProxies.length);
        }
        return S1V.DVW(this.mScrollPosition.getValue(), 0, list.size() - this.mItemProxies.length);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (bqP.XHT(bankItemTargetUpdater != null));
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (bqP.XHT(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (bqP.XHT(bankItemTargetUpdater != null));
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(this.isInitializingDriver()));
        assert (bqP.XHT(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (bqP.XHT(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (bqP.XHT(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public z getFirstItem(z z2) {
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (z)list.get(0);
        }
        return null;
    }

    @Override
    public z getLastItem(z z2) {
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (z)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public z getPreviousItem(z z2) {
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        if (z2 == null) {
            if (!list.isEmpty()) {
                return (z)list.get(0);
            }
            return null;
        }
        int n4 = list.indexOf(z2);
        if (n4 > 0) {
            return (z)list.get(n4 - 1);
        }
        return null;
    }

    @Override
    public z getNextItem(z z2) {
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        if (z2 == null) {
            if (!list.isEmpty()) {
                return (z)list.get(0);
            }
            return null;
        }
        int n4 = list.indexOf(z2);
        if (n4 + 1 < list.size()) {
            return (z)list.get(n4 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(z z2) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(this.mCursorProxyToFollow != null));
        this.mCursor = z2;
        if (z2 != null) {
            this.doScrollToItem(z2);
            int n4 = -1;
            for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
                ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
                z z3 = (z)controlSurfaceProxy.getTarget();
                if (z3 != z2) continue;
                n4 = i2;
                break;
            }
            if (n4 >= 0) {
                this.mCursorIndex.setIntegerValue(n4);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(z z2) {
        assert (bqP.XHT(z2 != null));
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        int n4 = list.indexOf(z2);
        if (n4 >= 0) {
            this.doScrollIntoView(n4, list.size(), true);
        }
    }

    public void doScrollIntoView(int n4) {
        assert (bqP.XHT(n4 >= 0));
        assert (bqP.XHT(this.isDocumentThread()));
        this.doScrollIntoView(n4, true);
    }

    public void doScrollIntoView(int n4, boolean bl2) {
        assert (bqP.XHT(n4 >= 0));
        assert (bqP.XHT(this.isDocumentThread()));
        List list = this.getList();
        this.doScrollIntoView(n4, list.size(), bl2);
    }

    private void doScrollIntoView(int n4, int n5, boolean bl2) {
        assert (bqP.XHT(n4 >= 0));
        assert (bqP.XHT(this.isDocumentThread()));
        int n6 = this.mScrollPosition.getValue();
        if (n4 < n6 || n4 >= n6 + this.mItemProxies.length) {
            int n7 = this.quantizePosition(n4, n5);
            assert (bqP.XHT(n4 >= n7 && n4 < n7 + this.mItemProxies.length));
            this.doScrollTo(n7, bl2);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new FVt("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (bqP.XHT(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        assert (bqP.XHT(n4 >= 0 && n4 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new FVt("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n4));
    }

    public void doMoveCursorToIndex(int n4) {
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(n4 >= 0 && n4 < this.getSizeOfBank()));
        assert (bqP.XHT(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n4];
        z z2 = (z)controlSurfaceProxy.getTarget();
        if (z2 != null) {
            this.mCursorProxyToFollow.doSelect(z2);
        }
    }

    protected void moveCursorIndexBy(int n4) {
        assert (bqP.XHT(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new FVt("This bank is not following any cursor");
        }
        if (n4 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n4));
        }
    }

    private void doMoveCursorIndexBy(int n4) {
        int n5;
        assert (bqP.XHT(this.isDocumentThread()));
        assert (bqP.XHT(n4 != 0));
        assert (bqP.XHT(this.mCursorProxyToFollow != null));
        int n6 = this.mCursorIndex.getValue();
        assert (bqP.XHT(n6 >= 0 && n6 < this.getSizeOfBank() || n6 == -1));
        if (n6 >= 0 && n6 < this.getSizeOfBank() && (n5 = n6 + n4) >= 0 && n5 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n5);
        }
    }
}

