/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscBundle;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.flt.control_surface.opensoundcontrol.UBm;
import com.bitwig.flt.control_surface.opensoundcontrol.fEf;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class tev {
    private ByteBuffer gBO = null;
    private byte[] XHT = null;

    tev() {
    }

    OscPacket DVW(byte[] byArray, int n4, int n5) {
        try {
            this.XHT = byArray;
            this.gBO = ByteBuffer.wrap(byArray, n4, n5);
            this.gBO.order(ByteOrder.BIG_ENDIAN);
            return this.DVW(null);
        }
        catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
            return null;
        }
    }

    private OscPacket DVW(OscBundle oscBundle) {
        String string = this.DVW();
        if (string.equals("#bundle")) {
            return this.gBO(oscBundle);
        }
        return this.DVW(oscBundle, string);
    }

    private String DVW() {
        byte by2;
        int n4 = this.gBO.position();
        assert (bqP.DVW(n4 % 4 == 0));
        while ((by2 = this.gBO.get()) != 0) {
        }
        String string = new String(this.XHT, n4, this.gBO.position() - n4 - 1);
        this.nrS();
        return string;
    }

    private int gBO() {
        assert (bqP.DVW(this.gBO.order() == ByteOrder.BIG_ENDIAN));
        return this.gBO.getInt();
    }

    private long XHT() {
        assert (bqP.DVW(this.gBO.order() == ByteOrder.BIG_ENDIAN));
        return this.gBO.getLong();
    }

    private float hAB() {
        return this.gBO.getFloat();
    }

    private double lTJ() {
        return this.gBO.getDouble();
    }

    private byte[] qhn() {
        int n4 = this.gBO();
        if (n4 < 0) {
            throw new IOException("Invalid blob size: " + n4);
        }
        byte[] byArray = new byte[n4];
        this.gBO.get(byArray);
        this.nrS();
        return byArray;
    }

    private void nrS() {
        int n4 = this.gBO.position() % 4;
        if (n4 != 0) {
            int n5 = this.gBO.position() + 4 - n4;
            this.gBO.position(n5);
        }
        assert (bqP.DVW(this.gBO.position() % 4 == 0));
    }

    private UBm DVW(OscBundle oscBundle, String string) {
        String string2 = this.DVW();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string2.isEmpty() && string2.charAt(0) == ',') {
            block11: for (int i2 = 1; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                switch (c2) {
                    case 'F': {
                        arrayList.add(false);
                        continue block11;
                    }
                    case 'T': {
                        arrayList.add(true);
                        continue block11;
                    }
                    case 'N': {
                        arrayList.add(null);
                        continue block11;
                    }
                    case 'i': {
                        arrayList.add(this.gBO());
                        continue block11;
                    }
                    case 'h': {
                        arrayList.add(this.XHT());
                        continue block11;
                    }
                    case 'f': {
                        arrayList.add(Float.valueOf(this.hAB()));
                        continue block11;
                    }
                    case 'd': {
                        arrayList.add(this.lTJ());
                        continue block11;
                    }
                    case 'b': {
                        arrayList.add(this.qhn());
                        continue block11;
                    }
                    case 's': {
                        arrayList.add(this.DVW());
                        continue block11;
                    }
                    default: {
                        i2 = string2.length();
                    }
                }
            }
        }
        return new UBm(oscBundle, string, string2, arrayList);
    }

    private fEf gBO(OscBundle oscBundle) {
        long l2 = this.XHT();
        fEf fEf2 = new fEf(oscBundle, l2);
        while (this.gBO.position() < this.gBO.limit()) {
            int n4 = this.gBO();
            if (this.gBO.limit() < this.gBO.position() + n4) {
                throw new IOException("OSC: Invalid Packet Size (" + n4 + ") which exceeds the packet by " + (this.gBO.position() + n4 - this.XHT.length) + " bytes.");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.XHT, this.gBO.position(), n4);
            ByteBuffer byteBuffer2 = this.gBO;
            byteBuffer2.position(byteBuffer2.position() + n4);
            this.gBO = byteBuffer;
            OscPacket oscPacket = this.DVW(fEf2);
            fEf2.DVW(oscPacket);
            assert (bqP.DVW(byteBuffer.position() <= byteBuffer2.position()));
            this.gBO = byteBuffer2;
        }
        return fEf2;
    }
}

