/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscInvalidArgumentTypeException;
import com.bitwig.extension.api.opensoundcontrol.OscPacketSizeExceededException;
import com.bitwig.flt.control_surface.opensoundcontrol.c;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Stack;

class NBU {
    private final byte[] gBO = new byte[65536];
    private final ByteBuffer XHT = ByteBuffer.wrap(this.gBO);
    private int hAB = 0;
    private final Stack lTJ = new Stack();

    NBU() {
        this.XHT.order(ByteOrder.BIG_ENDIAN);
    }

    void DVW() {
        this.XHT.position(0);
        this.hAB = 0;
        this.lTJ.clear();
    }

    void gBO() {
        try {
            if (this.hAB > 0) {
                this.lTJ.add(this.XHT.position());
                this.DVW(0);
            }
            this.DVW("#bundle");
            this.DVW(42L);
            ++this.hAB;
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    void XHT() {
        try {
            if (this.hAB == 0) {
                throw new IllegalStateException("Call to endBundle() without a call to startBundle() first.");
            }
            --this.hAB;
            if (this.hAB > 0) {
                int n4 = this.XHT.position();
                int n5 = (Integer)this.lTJ.pop();
                this.XHT.putInt(n5, n4 - n5 - 4);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    void DVW(String string, Object ... objectArray) {
        try {
            int n4 = this.XHT.position();
            if (this.hAB > 0) {
                this.XHT.putInt(0);
            }
            this.DVW(string);
            String string2 = c.DVW(objectArray);
            this.DVW(string2);
            if (objectArray == null) {
                return;
            }
            for (Object object : objectArray) {
                if (object == null || object instanceof Boolean) continue;
                if (object instanceof Integer) {
                    this.DVW((Integer)object);
                    continue;
                }
                if (object instanceof Long) {
                    this.gBO((Long)object);
                    continue;
                }
                if (object instanceof Float) {
                    this.DVW(((Float)object).floatValue());
                    continue;
                }
                if (object instanceof Double) {
                    this.DVW((Double)object);
                    continue;
                }
                if (object instanceof String) {
                    this.DVW((String)object);
                    continue;
                }
                if (object instanceof byte[]) {
                    this.gBO((byte[])object);
                    continue;
                }
                throw new OscInvalidArgumentTypeException(object);
            }
            if (this.hAB > 0) {
                this.XHT.putInt(n4, this.XHT.position() - n4 - 4);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    int hAB() {
        return this.hAB;
    }

    private void DVW(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length % 4 == 0) {
            this.XHT.put(byArray);
            this.XHT.putInt(0);
        } else {
            this.DVW(byArray);
        }
    }

    private void DVW(byte[] byArray) {
        this.XHT.put(byArray);
        int n4 = byArray.length > 0 ? (4 - byArray.length % 4) % 4 : 4;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.XHT.put((byte)0);
        }
    }

    private void DVW(long l2) {
        this.gBO(l2);
    }

    private void DVW(int n4) {
        assert (bqP.DVW(this.XHT.order() == ByteOrder.BIG_ENDIAN));
        this.XHT.putInt(n4);
    }

    private void gBO(long l2) {
        assert (bqP.DVW(this.XHT.order() == ByteOrder.BIG_ENDIAN));
        this.XHT.putLong(l2);
    }

    private void DVW(float f2) {
        this.XHT.putFloat(f2);
    }

    private void DVW(double d3) {
        this.XHT.putDouble(d3);
    }

    private void gBO(byte[] byArray) {
        this.XHT.putInt(byArray.length);
        this.DVW(byArray);
    }

    byte[] lTJ() {
        return this.gBO;
    }

    int qhn() {
        return this.XHT.position();
    }
}

