/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests.dnd;

import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.MJG;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.flt.app.testing.tests.dnd.GXb;
import com.bitwig.flt.app.testing.tests.dnd.MwA;
import com.bitwig.flt.app.testing.tests.dnd.MzQ;
import com.bitwig.flt.app.testing.tests.dnd.NBU;
import com.bitwig.flt.app.testing.tests.dnd.UBm;
import com.bitwig.flt.app.testing.tests.dnd.c;
import com.bitwig.flt.app.testing.tests.dnd.kSG;
import com.bitwig.flt.app.testing.tests.dnd.tev;
import com.bitwig.flt.app.testing.tests.dnd.uuS;
import com.bitwig.flt.app.testing.tests.dnd.wEG;
import com.bitwig.flt.document.core.iface.Rfh;
import com.bitwig.flt.document.core.iface.XT;
import com.bitwig.flt.document.core.iface.clipboard.clip.ArrangerClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.clip.ClipLauncherClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.DeviceChainInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.track.TrackHeaderInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.track.fEf;
import com.bitwig.flt.document.core.master.device.eUa;
import com.bitwig.flt.document.core.master.device.wHx;
import com.bitwig.ramona.core.UMx;
import com.bitwig.ramona.core.jPS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AutoDragAndDropTests
extends BitwigStudioTestDataFileTest {
    private tev mDataSourceCreator;
    private uuS mInsertionPointCreator;
    private TestProject mProject;
    private int mInsertModifiers = -1;
    private NBU mExpectedAction;
    private kSG mExpectedInsertActionsFile;
    private static final String CORRECT_INSERT_ACTION_NAME = "insert-action";
    private static final int MODIFIERS_TO_IGNORE = 0;
    private TestProject mProjectWeOpenedToFindTestHierarchy;
    private List mAllDataSourceCreators;
    private List mAllInsertionPointCreators;

    @Override
    protected String getTopLevelDirectoryPath() {
        return "auto-drag-and-drop/projects";
    }

    @Override
    protected boolean shouldCreateTestForFileType(ZdU zdU) {
        return zdU instanceof kfq;
    }

    @Override
    protected boolean hasChildTestsPerFile(nwb nwb2) {
        return true;
    }

    @Override
    protected String getTestNodeNameForFile(nwb nwb2) {
        return nwb2.jpF();
    }

    @Override
    public String getTestName() {
        if (this.mDataSourceCreator != null) {
            if (this.mInsertionPointCreator != null) {
                if (this.mInsertModifiers == 0) {
                    return "none";
                }
                if (this.mInsertModifiers != -1) {
                    return sFp.hAB(this.mInsertModifiers);
                }
                return this.mInsertionPointCreator.DVW();
            }
            return this.mDataSourceCreator.DVW();
        }
        return super.getTestName();
    }

    @Override
    protected void listChildrenForFile(nwb nwb2, Collection collection) {
        if (this.shouldCreateTestForFile(nwb2)) {
            if (this.mDataSourceCreator == null) {
                this.listDataSourceTests(nwb2, collection);
            } else if (this.mInsertionPointCreator == null) {
                this.listInsertionPointTests(nwb2, collection);
            } else if (this.mInsertModifiers == -1) {
                this.listInsertModifierTests(nwb2, collection);
            }
        } else {
            super.listChildrenForFile(nwb2, collection);
        }
    }

    private void listDataSourceTests(nwb nwb2, Collection collection) {
        assert (bqI.gBO(this.mAllDataSourceCreators == null));
        assert (bqI.gBO(this.mAllInsertionPointCreators == null));
        assert (bqI.gBO(this.mExpectedInsertActionsFile == null));
        nwb nwb3 = nwb2.hAB(nwb2.jpF() + ".expected");
        this.mProjectWeOpenedToFindTestHierarchy = this.openTestProject(nwb2);
        this.mAllDataSourceCreators = new ArrayList();
        this.mAllInsertionPointCreators = new ArrayList();
        nwb nwb4 = this.getTopLevelDirectory().fJ1().lTJ("files");
        nwb4.DVW(new MwA(this, nwb4));
        this.exec(() -> {
            iuL iuL2 = (iuL)this.mProjectWeOpenedToFindTestHierarchy.hAB();
            this.listDataSourcesAndInsertionPointsForDocument(iuL2);
        });
        this.mExpectedInsertActionsFile = new kSG(nwb3, this.mAllDataSourceCreators, this.mAllInsertionPointCreators);
        this.exec(() -> {
            for (tev tev2 : this.mAllDataSourceCreators) {
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(nwb2, true);
                autoDragAndDropTests.mDataSourceCreator = tev2;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertionPointTests(nwb nwb2, Collection collection) {
        assert (bqI.gBO(this.mDataSourceCreator != null));
        assert (bqI.gBO(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            iuL iuL2 = (iuL)this.mProjectWeOpenedToFindTestHierarchy.hAB();
            eLf eLf2 = this.mDataSourceCreator.DVW(iuL2);
            for (uuS uuS2 : this.mAllInsertionPointCreators) {
                EHN eHN = uuS2.DVW(iuL2);
                if (!eHN.hAB(eLf2)) continue;
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(nwb2, true);
                autoDragAndDropTests.mInsertionPointCreator = uuS2;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertModifierTests(nwb nwb2, Collection collection) {
        assert (bqI.gBO(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            Object object;
            Iterator iterator2;
            iuL iuL2 = (iuL)this.mProjectWeOpenedToFindTestHierarchy.hAB();
            eLf eLf2 = this.mDataSourceCreator.DVW(iuL2);
            this.check(eLf2).jJc();
            EHN eHN = this.mInsertionPointCreator.DVW(iuL2);
            this.check(eHN).jJc();
            this.check(eHN.hAB(eLf2));
            int n4 = eHN.lTJ(eLf2) & 0xFFFFFFFF;
            cWA cWA2 = new cWA(4);
            for (Iterator iterator2 : sFp.DVW(n4)) {
                cWA2.hAB(((sFp)((Object)iterator2)).hAB());
            }
            cWA cWA3 = new cWA(4);
            this.listModifierCombinations(cWA2, cWA3);
            iterator2 = cWA3.XHT();
            while (iterator2.hasNext()) {
                int n5 = (Integer)iterator2.next();
                object = (AutoDragAndDropTests)this.createChild(nwb2, false);
                ((AutoDragAndDropTests)object).init(n5);
                collection.add(object);
            }
            for (sFp sFp2 : sFp.DVW) {
                if (sFp2.gBO(n4) || sFp2.gBO(0) || (object = this.mExpectedInsertActionsFile.DVW(this.mDataSourceCreator, this.mInsertionPointCreator, sFp2.hAB())) == null) continue;
                if (((NBU)object).DVW()) {
                    this.checkCorrectable("Did not list " + sFp2.DVW() + " as a possible insert modifier but the expected actions says that it should be possible", "RemoveInsertModifier", sFp2.DVW()).DVW("");
                    continue;
                }
                this.mExpectedInsertActionsFile.gBO(this.mDataSourceCreator, this.mInsertionPointCreator, sFp2.hAB());
            }
        });
    }

    private void listModifierCombinations(cWX cWX2, cWX cWX3) {
        cWX3.hAB(0);
        this.listModifierCombinations(cWX2, cWX3, 0, 0);
    }

    private void listModifierCombinations(cWX cWX2, cWX cWX3, int n4, int n5) {
        for (int i2 = n5; i2 < cWX2.size(); ++i2) {
            int n6 = cWX2.szR(i2);
            cWX3.hAB(n4 | n6);
            this.listModifierCombinations(cWX2, cWX3, n4, n5 + 1);
            this.listModifierCombinations(cWX2, cWX3, n4 | n6, n5 + 1);
        }
    }

    @Override
    protected void afterTestHierachyUpdated() {
        super.afterTestHierachyUpdated();
        this.mAllDataSourceCreators = null;
        this.mAllInsertionPointCreators = null;
        if (this.mDataSourceCreator == null && this.mProjectWeOpenedToFindTestHierarchy != null && this.getFile() != null && this.getFile().Mdo()) {
            try {
                this.mProjectWeOpenedToFindTestHierarchy.jJc();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mProjectWeOpenedToFindTestHierarchy = null;
    }

    private void init(int n4) {
        this.mInsertModifiers = n4;
        this.mExpectedAction = this.mExpectedInsertActionsFile.DVW(this.mDataSourceCreator, this.mInsertionPointCreator, n4);
    }

    @Override
    protected com.bitwig.base.testing.NBU getRootTestForSetup() {
        if (this.getFile() != null && this.mDataSourceCreator == null && this.mInsertionPointCreator == null && this.mInsertModifiers == -1) {
            return this;
        }
        return super.getRootTestForSetup();
    }

    @Override
    protected void setupDescendandTest(com.bitwig.base.testing.NBU nBU2) {
        super.setupDescendandTest(nBU2);
        AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)nBU2;
        if (this.mProject == null || ((iuL)this.mProject.hAB()).O_()) {
            this.mProject = autoDragAndDropTests.openTestProject(autoDragAndDropTests.getFile());
        }
        MJG mJG = (MJG)((iuL)this.mProject.hAB()).zER();
        mJG.DVW(autoDragAndDropTests);
        autoDragAndDropTests.mProject = new TestProject((BitwigStudioTest)autoDragAndDropTests, (iuL)this.mProject.hAB());
        autoDragAndDropTests.openedProject(autoDragAndDropTests.mProject);
    }

    @Override
    protected void tearDownDescendantTest(com.bitwig.base.testing.NBU nBU2, boolean bl2) {
        super.tearDownDescendantTest(nBU2, bl2);
        if (!bl2) {
            AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)nBU2;
            autoDragAndDropTests.mProject.jJc();
            this.mProject = null;
        }
    }

    @S1a
    public void testDragAndDrop() {
        if (this.mProject.vCp()) {
            this.mProject.D2F();
        }
        this.mProject.pxg();
        oTe oTe2 = new oTe();
        this.asyncExec(() -> {
            iuL iuL2 = (iuL)this.mProject.hAB();
            eLf eLf2 = this.mDataSourceCreator.DVW(iuL2);
            this.check(eLf2).jJc();
            EHN eHN = this.mInsertionPointCreator.DVW(iuL2);
            this.check(eHN).jJc();
            int n4 = eHN.lTJ(eLf2);
            ykS ykS2 = this.mInsertModifiers == 0 || (n4 | this.mInsertModifiers) == n4 ? eHN.DVW(eLf2, this.mInsertModifiers) : null;
            if (ykS2 == null) {
                this.checkActionIsExpected(NBU.gBO);
                oTe2.DVW();
                return;
            }
            if (!ykS2.DVW()) {
                this.checkActionIsExpected(NBU.DVW);
                oTe2.DVW();
                return;
            }
            this.asyncExec(() -> {
                ykS2.nrS().DVW(true);
                if (ykS2.gBO()) {
                    try {
                        ykS2.fJ1();
                    }
                    catch (B1t b1t) {
                        this.checkActionIsExpected(NBU.gBO);
                        oTe2.DVW();
                        return;
                    }
                }
                this.asyncExec(() -> {
                    if (ykS2.gBO()) {
                        ykS2.hAB();
                    }
                    ykS2.nrS().DVW(false);
                });
                this.asyncExec(() -> ykS2.gBO(this.inNewEvent(MJG.DVW(new wEG(this, iuL2, ykS2, eHN), oTe2))));
            });
        });
        try {
            this.waitForAsyncTask("Insert to finish", oTe2, 10L, TimeUnit.SECONDS);
        }
        catch (B1t | jPS exception) {
            // empty catch block
        }
        ylD ylD2 = ((iuL)this.mProject.hAB()).Lu2();
        if (ylD2 != null) {
            this.waitForLatch("Bounce to finish", ylD2.pxg(), 10L, TimeUnit.SECONDS);
        }
    }

    private void checkActionIsExpected(NBU nBU2) {
        if (this.mExpectedAction == null) {
            if (nBU2.DVW()) {
                this.mExpectedInsertActionsFile.DVW(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, nBU2);
            }
            this.mExpectedAction = NBU.hAB;
        }
        this.checkCorrectable("Actual insert action is correct", CORRECT_INSERT_ACTION_NAME, nBU2).DVW(this.mExpectedAction);
    }

    @Override
    public void autoCorrect(String string, String string2) {
        if (string.equals(CORRECT_INSERT_ACTION_NAME)) {
            try {
                NBU nBU2;
                this.mExpectedAction = nBU2 = NBU.DVW(string2);
                this.mExpectedInsertActionsFile.DVW(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, nBU2);
            }
            catch (jZi jZi2) {
                jZi2.printStackTrace();
            }
        } else if (string.equals("RemoveInsertModifier")) {
            sFp sFp2 = sFp.XHT(string2);
            this.mExpectedInsertActionsFile.gBO(this.mDataSourceCreator, this.mInsertionPointCreator, sFp2.hAB());
        } else {
            super.autoCorrect(string, string2);
        }
    }

    private void listDataSourcesAndInsertionPointsForDocument(iuL iuL2) {
        qQe qQe2 = iuL2.QP();
        this.listDataSourcesAndInsertionPointsForTrackGroup(qQe2);
        Collections.sort(this.mAllDataSourceCreators);
        Collections.sort(this.mAllInsertionPointCreators);
    }

    private void listDataSourcesAndInsertionPointsForTrackGroup(qQe qQe4) {
        fht fht3;
        HZV hZV3;
        int n4;
        int n5;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(qQe4);
        for (n5 = 0; n5 < qQe4.Kjp(); ++n5) {
            n4 = n5;
            hZV3 = qQe4.vr(n4);
            if (hZV3 instanceof UOM) {
                this.listDataSourcesAndInsertionPointsForTrack((UOM)hZV3);
            } else {
                this.listDataSourcesAndInsertionPointsForTrackGroup((qQe)hZV3);
            }
            this.addInsertionPoint(hZV3, "Before", hZV2 -> new TrackHeaderInsertionPoint(hZV2.cjp(), oFS.DVW, n4));
        }
        this.addInsertionPoint(qQe4, "EndOfMainTracksIn", qQe2 -> new TrackHeaderInsertionPoint((XT)((Object)qQe2), oFS.DVW, qQe2.Kjp()));
        if (qQe4.Kjp() > 1) {
            this.addDataSource(qQe4, "AllMainTracksIn", qQe2 -> new fEf(qQe2.VHA()));
        }
        if (qQe4.BIH() > 1) {
            this.addDataSource(qQe4, "AllEffectTracksIn", qQe2 -> new fEf(qQe2.mcc()));
        }
        n5 = 0;
        while (n5 < qQe4.BIH()) {
            n4 = n5++;
            hZV3 = qQe4.wr(n4);
            this.listDataSourcesAndInsertionPointsForTrack((UOM)hZV3);
            this.addInsertionPoint(hZV3, "Before", uOM -> new TrackHeaderInsertionPoint(uOM.cjp(), oFS.gBO, n4));
        }
        this.addInsertionPoint(qQe4, "EndOfEffectTracksIn", qQe3 -> new TrackHeaderInsertionPoint((XT)((Object)qQe3), oFS.gBO, qQe4.BIH()));
        fht fht4 = AutoDragAndDropTests.firstSceneWithClips(qQe4);
        if (fht4 != null) {
            this.addDataSource(fht4, fht2 -> new uWt(Collections.singleton(fht2), (vC3)fht2));
        }
        if ((fht3 = AutoDragAndDropTests.firstEmptyScene(qQe4)) != null) {
            this.addDataSource(fht3, fht2 -> new uWt(Collections.singleton(fht2), (vC3)fht2));
        }
    }

    private void listDataSourcesAndInsertionPointsForTrack(UOM uOM) {
        bii bii2;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(uOM);
        eUa eUa2 = uOM.CVI();
        this.listDataSourcesAndInsertionPointsForDeviceChain(eUa2);
        bii bii3 = AutoDragAndDropTests.firstSlotWithClip(uOM);
        if (bii3 != null) {
            this.listDataSourcesAndInsertionPointsForSlot(bii3);
        }
        if ((bii2 = AutoDragAndDropTests.firstEmptySlot(uOM)) != null) {
            this.listDataSourcesAndInsertionPointsForSlot(bii2);
        }
    }

    private void listDataSourcesAndInsertionPointsForSlot(bii bii3) {
        UxS uxS = bii3.nqb();
        if (uxS != null) {
            this.addDataSource(bii3, bii2 -> new uWt(Collections.singletonList(bii2), (vC3)bii2));
        }
        this.listDataSourcesAndInsertionPointsForSlotOrScene(bii3);
    }

    private void listDataSourcesAndInsertionPointsForSlotOrScene(vC3 vC33) {
        this.addInsertionPoint(vC33, vC32 -> new ClipLauncherClipInsertionPoint((hfG)((Object)vC32), vC32.THm().Vuu().iZz()));
    }

    private static bii firstSlotWithClip(UOM uOM) {
        for (bii bii2 : uOM.XUe().KAx()) {
            if (bii2.nqb() == null) continue;
            return bii2;
        }
        return null;
    }

    private static bii firstEmptySlot(UOM uOM) {
        for (bii bii2 : uOM.XUe().KAx()) {
            if (bii2.nqb() != null) continue;
            return bii2;
        }
        return null;
    }

    private static fht firstSceneWithClips(qQe qQe2) {
        for (fht fht2 : qQe2.yDO()) {
            ArrayList arrayList = new ArrayList();
            fht2.XHT(arrayList);
            if (arrayList.isEmpty()) continue;
            return fht2;
        }
        return null;
    }

    private static fht firstEmptyScene(qQe qQe2) {
        for (fht fht2 : qQe2.yDO()) {
            ArrayList arrayList = new ArrayList();
            fht2.XHT(arrayList);
            if (!arrayList.isEmpty()) continue;
            return fht2;
        }
        return null;
    }

    private void listDataSourcesAndInsertionPointsForTrackOrTrackGroup(HZV hZV3) {
        this.addDataSource(hZV3, hZV2 -> new fEf(Collections.singletonList(hZV2)));
        if (hZV3.vgs().WCJ() > 0) {
            this.addDataSource(hZV3.vgs().jpF(0), fkR -> new zR2(Collections.singleton(fkR), (FkR)fkR, fkR.KQG() + fkR.bMm() / 2.0));
        }
        if (hZV3.cjp() != null) {
            this.addInsertionPoint(hZV3, "Onto", hZV2 -> TrackHeaderInsertionPoint.DVW(hZV2, true, hZV2.ENw().Vuu().viw()));
        }
        this.addInsertionPoint(hZV3, "Time0In", hZV2 -> new ArrangerClipInsertionPoint((Rfh)((Object)hZV2), 0.0, null, hZV2.ENw().Vuu().AFD()));
    }

    private void listDataSourcesAndInsertionPointsForDeviceChain(eUa eUa3) {
        this.addInsertionPoint(eUa3, "StartOf", eUa2 -> new DeviceChainInsertionPoint((YQ)((Object)eUa2), 0, ((UOM)eUa2.lTJ(UOM.class)).OOU().nqb()));
        for (int i2 = 0; i2 < eUa3.D2F(); ++i2) {
            int n4 = i2;
            wHx wHx3 = eUa3.XHT(i2);
            this.listDataSourcesAndInsertionPointsForDevice(wHx3);
            if (i2 <= 0) continue;
            this.addInsertionPoint(wHx3, "Before", wHx2 -> new DeviceChainInsertionPoint(wHx2.YAD(), n4, wHx2.ZzP().OOU().nqb()));
        }
        if (eUa3.D2F() > 1) {
            this.addInsertionPoint(eUa3, "EndOf", eUa2 -> new DeviceChainInsertionPoint((YQ)((Object)eUa2), eUa2.D2F(), ((UOM)eUa2.lTJ(UOM.class)).OOU().nqb()));
            this.addDataSource(eUa3, "AllDevicesIn", eUa2 -> new com.bitwig.flt.document.core.iface.clipboard.device.UBm(eUa2.fJ1()));
        }
    }

    private void listDataSourcesAndInsertionPointsForDevice(wHx wHx3) {
        this.addDataSource(wHx3, wHx2 -> new com.bitwig.flt.document.core.iface.clipboard.device.UBm(Collections.singletonList(wHx2)));
        this.addInsertionPoint(wHx3, "Onto", wHx2 -> {
            eUa eUa2 = wHx2.YAD();
            int n4 = eUa2.DVW((brV)((Object)wHx2));
            UOM uOM = wHx2.ZzP();
            return new DeviceChainInsertionPoint(eUa2, n4, true, true, uOM.OOU().nqb());
        });
    }

    private void addDataSource(UMx uMx, GXb gXb) {
        this.addDataSource(uMx, "", gXb);
    }

    private void addDataSource(UMx uMx, String string, GXb gXb) {
        com.bitwig.ramona.path.MzQ mzQ2 = uMx.CtZ();
        String string2 = string + AutoDragAndDropTests.getObjectName(uMx);
        Class<?> clazz = uMx.getClass();
        this.mAllDataSourceCreators.add(new c(this, string2, mzQ2, clazz, gXb));
    }

    private void addInsertionPoint(UMx uMx, MzQ mzQ2) {
        this.addInsertionPoint(uMx, "", mzQ2);
    }

    private void addInsertionPoint(UMx uMx, String string, MzQ mzQ2) {
        com.bitwig.ramona.path.MzQ mzQ3 = uMx.CtZ();
        String string2 = string + AutoDragAndDropTests.getObjectName(uMx);
        Class<?> clazz = uMx.getClass();
        this.mAllInsertionPointCreators.add(new UBm(this, string2, mzQ3, clazz, mzQ2));
    }

    private static String getObjectName(UMx uMx) {
        com.bitwig.ramona.path.MzQ mzQ2 = uMx.CtZ();
        String string = mzQ2.toString();
        String string2 = "track_group/";
        if (string.startsWith("track_group/")) {
            string = string.substring("track_group/".length());
        }
        return BXN.DVW(uMx.szR().tMs(), true) + "[" + string.replace('/', ':') + "]";
    }
}

