/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestItemSelection;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import java.util.ArrayList;

public class TrackOperationTests
extends BitwigStudioTest {
    @S1a
    public void testTrackGrouping() {
        Object object;
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n4 = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            object = testProject.DVW(vNA.gBO);
            arrayList.add((TestTrack)object);
        }
        TestItemSelection testItemSelection = testProject.iRw();
        testItemSelection.qhn();
        for (TestTrack testTrack : arrayList) {
            testItemSelection.DVW(testTrack);
        }
        this.check("Created Tracks", testItemSelection.nrS()).DVW(16);
        testItemSelection.jpF();
        object = (TestTrackGroup)this.cast(testProject.jpF().gBO(0), TestTrackGroup.class);
        this.check("Tracks in TrackGroup", ((TestTrackGroup)object).fJ1()).DVW(16);
    }

    @S1a
    public void testTrackGroupingAndUngrouping() {
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n4 = 24;
        for (int i2 = 0; i2 < 24; ++i2) {
            TestTrack testTrack = testProject.DVW(vNA.gBO);
            arrayList.add(testTrack);
        }
        TestItemSelection testItemSelection = testProject.iRw();
        testItemSelection.qhn();
        for (TestTrack testTrackOrTrackGroup2 : arrayList) {
            testItemSelection.DVW(testTrackOrTrackGroup2);
        }
        this.check("Created Tracks", testItemSelection.nrS()).DVW(24);
        int n5 = testProject.jpF().fJ1();
        testItemSelection.jpF();
        TestTrackGroup testTrackGroup = (TestTrackGroup)this.cast(testProject.jpF().gBO(0), TestTrackGroup.class);
        testTrackGroup.F_();
        testItemSelection.jJc();
        int n6 = testProject.jpF().fJ1();
        this.check("Tracks Before/After", n5).DVW(n6);
    }

    @S1a
    public void testTrackRename() {
        this.testRenameTrack("Renamed");
    }

    @S1a
    public void testTrackRenameInvalid() {
        String string = new String(new char[]{'\ud800', 'H', 'E', 'L', 'L', 'O'});
        this.testRenameTrack(string);
    }

    @S1a
    public void testDuplicateTrackWithMidiAutomations() {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.DVW(vNA.DVW);
        this.exec(() -> {
            int n4;
            UOM uOM = (UOM)testTrack.hAB();
            for (int i2 = 0; i2 < 16; ++i2) {
                uOM.DVW(i2, Ju2.DVW, 0);
                uOM.DVW(i2, Ju2.gBO, 0);
                for (n4 = 0; n4 < 128; ++n4) {
                    uOM.DVW(i2, Ju2.XHT, n4);
                }
            }
            Yrz yrz = uOM.uyk();
            n4 = yrz.ypE();
            for (int i3 = 0; i3 < n4; ++i3) {
                ZmX zmX = yrz.lTJ(i3);
                dGu dGu2 = uOM.gBO((qhO)zmX);
                nRb nRb2 = dGu2.nlg().wr();
                nRb2.XHT(nxX.DVW(0.0, 0.0));
                nRb2.XHT(nxX.DVW(16.0, 127.0));
            }
        });
        testTrack.qhn();
        TestTrack testTrack2 = (TestTrack)testProject.jpF().gBO(1);
        this.check("Duplicated Track Exists", testTrack2).jJc();
        this.check("Automation Lane Count", testTrack2.D2F()).DVW(testTrack.D2F());
        this.exec(() -> {
            UOM uOM = (UOM)testTrack2.hAB();
            Yrz yrz = uOM.uyk();
            for (int i2 = 0; i2 < 16; ++i2) {
                this.checkMidiParameterAutomation(uOM, yrz, i2, Ju2.DVW, 0);
                this.checkMidiParameterAutomation(uOM, yrz, i2, Ju2.gBO, 0);
                for (int i3 = 0; i3 < 128; ++i3) {
                    this.checkMidiParameterAutomation(uOM, yrz, i2, Ju2.XHT, i3);
                }
            }
        });
    }

    private void checkMidiParameterAutomation(UOM uOM, Yrz yrz, int n4, Ju2 ju2, int n5) {
        ZmX zmX = yrz.gBO(n4, ju2, n5);
        this.check("Has " + ju2.XHT() + "/" + n5 + " Atom on channel " + n4, zmX).jJc();
        if (zmX == null) {
            return;
        }
        dGu dGu2 = uOM.gBO((qhO)zmX);
        this.check("Has " + ju2.XHT() + "/" + n5 + " AutomationLane on channel " + n4, dGu2).jJc();
    }

    private void testRenameTrack(String string) {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.DVW(vNA.DVW);
        this.check(testTrack.nrS()).hAB();
        this.check(testTrack.jpF()).lTJ();
        testTrack.gBO(string);
        this.check(testTrack.nrS()).DVW(string);
        this.check(testTrack.jpF()).DVW(string);
        this.check(testProject.vCp());
        this.check(!testProject.LsI());
        testProject.D2F();
        this.check(testTrack.nrS()).hAB();
        this.check(testTrack.jpF()).lTJ();
        this.check(testProject.LsI());
        testProject.szR();
        this.check(testTrack.nrS()).DVW(string);
        this.check(testTrack.jpF()).DVW(string);
    }
}

