/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteEvent;
import com.bitwig.flt.app.testing.TestMatrixSlot;
import com.bitwig.flt.app.testing.TestNoteClipEvent;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTimeSignatureEvent;
import com.bitwig.flt.app.testing.TestTimeSignatureTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;

public class SessionRecordingTests
extends BitwigStudioTest {
    @Override
    public int getBlockSize() {
        return 1859;
    }

    @S1a
    public void testRecordingEmptyInstrumentClipToArranger() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.pxg();
        TestTrack testTrack = testProject.DVW(vNA.DVW);
        TestMatrixSlot testMatrixSlot = testTrack.XHT(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.jpF(), TestInstrumentNoteClipEvent.class);
        testInstrumentNoteClipEvent.gBO(false);
        TestTransport testTransport = testProject.nrS();
        double d3 = 150.0;
        testTransport.nrS().DVW(150.0);
        testTransport.gBO(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.pxg();
        this.check("clip count", testNoteClipEventTimeline.nrS()).DVW(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.D2F()).DVW(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.jpF()).gBO().gBO(16.0, this.getBlockBeatLength(150.0));
    }

    @S1a
    public void testRecordingTimeSignatureChangesToArranger() {
        TestProject testProject = this.openTestProject("record-time-signature-changes-from-clip-launcher-to-arranger");
        testProject.pxg();
        TestTrack testTrack = testProject.jpF().pxg();
        TestNoteClipEvent testNoteClipEvent = testTrack.XHT(0).nrS();
        testNoteClipEvent.gBO(false);
        TestTransport testTransport = testProject.nrS();
        testTransport.gBO(0.0, 8.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.pxg();
        this.check("clip count", testNoteClipEventTimeline.nrS()).DVW(2);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(0), TestInstrumentNoteClipEvent.class);
        this.check("clip1 start time", testInstrumentNoteClipEvent.D2F()).DVW(0.0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(1), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("clip2 start time", testInstrumentNoteClipEvent2.D2F()).DVW(4.0);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testTrack.gBO(testTransport.qhn());
        TestTimeSignatureTimeline testTimeSignatureTimeline = (TestTimeSignatureTimeline)this.cast(testArrangementAutomationTimeline.qhn(), TestTimeSignatureTimeline.class);
        this.check("event count", testTimeSignatureTimeline.nrS()).DVW(2);
        TestTimeSignatureEvent testTimeSignatureEvent = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.XHT(0), TestTimeSignatureEvent.class);
        this.checkBeatTime("time1", testTimeSignatureEvent.D2F()).DVW(0.0);
        this.check("numerator1", testTimeSignatureEvent.nrS()).DVW(4);
        this.check("denominator1", testTimeSignatureEvent.jpF()).DVW(4);
        TestTimeSignatureEvent testTimeSignatureEvent2 = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.XHT(1), TestTimeSignatureEvent.class);
        this.check("time2", testTimeSignatureEvent2.D2F()).DVW(4.0);
        this.check("numerator2", testTimeSignatureEvent2.nrS()).DVW(3);
        this.check("denominator2", testTimeSignatureEvent2.jpF()).DVW(4);
    }

    @S1a
    public void testRecordingClipWithStartMarkerNotAtTimeZero() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.pxg();
        TestTrack testTrack = testProject.DVW(vNA.DVW);
        TestMatrixSlot testMatrixSlot = testTrack.XHT(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.jpF(), TestInstrumentNoteClipEvent.class);
        double d3 = 2.75;
        int n4 = 40;
        double d4 = 1.0;
        testInstrumentNoteClipEvent.gBO(2.75);
        testInstrumentNoteClipEvent.DVW(eiY.DVW(2.75, 1.0), 0, 40);
        testInstrumentNoteClipEvent.gBO(false);
        TestTransport testTransport = testProject.nrS();
        double d5 = 150.0;
        testTransport.nrS().DVW(150.0);
        testTransport.gBO(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.pxg();
        this.check("clip count", testNoteClipEventTimeline.nrS()).DVW(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.D2F()).DVW(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.jpF()).gBO().gBO(16.0, this.getBlockBeatLength(150.0));
        this.checkBeatTime("play start in recorded clip", testInstrumentNoteClipEvent2.fJ1()).DVW(2.75);
        TestNoteEventTimeline testNoteEventTimeline = testInstrumentNoteClipEvent2.nrS().DVW(40, 0);
        int n5 = testNoteEventTimeline.nrS();
        this.check("recorded note count", n5).DVW(1);
        TestInstrumentNoteEvent testInstrumentNoteEvent = (TestInstrumentNoteEvent)this.cast(testNoteEventTimeline.gBO(0), TestInstrumentNoteEvent.class);
        this.check("recorded note start time", testInstrumentNoteEvent.D2F()).DVW(2.75);
        this.check("recorded note duration", testInstrumentNoteEvent.jpF()).DVW(1.0);
    }
}

